package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.interfaces.DamageSourcesInterface;
import com.github.suninvr.virtualadditions.interfaces.PlayerEntityInterface;
import com.github.suninvr.virtualadditions.network.PlayerProjectionMovementC2SPayload;
import com.github.suninvr.virtualadditions.network.PlayerProjectionS2CPayload;
import com.github.suninvr.virtualadditions.registry.VAEntityType;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.github.suninvr.virtualadditions.registry.VATrackedDataHandlerRegistry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_10339;
import net.minecraft.class_11890;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_746;
import net.minecraft.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;

public class PlayerProjectionEntity extends class_11890 {
    private static final class_2940<UUID> PLAYER_ID = class_2945.method_12791(PlayerProjectionEntity.class, VATrackedDataHandlerRegistry.UUID);
    private static final UUID EMPTY_ID = UUID.fromString("0-0-0-0-0");
    private class_1657 player;
    private boolean isPhasingThroughWall;
    public boolean lookDirectionChanged = false;
    private long isPhasingThroughWallLastCheck = -1;
    boolean isMainPlayer;

    public PlayerProjectionEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5960 = true;
        this.method_5875(true);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PLAYER_ID, EMPTY_ID);
    }

    public static PlayerProjectionEntity createForPlayer(class_1657 player) {
        PlayerProjectionEntity entity = VAEntityType.PLAYER_PROJECTION.method_5883(player.method_73183(), class_3730.field_16471);
        if (entity == null) return null;
        class_243 vec3d = player.method_33571().method_1019(player.method_5720().method_1021(1.6));
        entity.method_23327(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
        entity.method_5710(player.method_36454(), player.method_36455());
        entity.field_5982 = entity.field_6283 = entity.field_6241 = entity.method_36454();
        entity.player = player;
        entity.field_6011.method_12778(PLAYER_ID, player.method_5667());
        player.method_73183().method_8649(entity);
        if (player instanceof class_3222 serverPlayerEntity) ServerPlayNetworking.send(serverPlayerEntity, new PlayerProjectionS2CPayload(entity.field_6021));
        entity.method_5665(player.method_5477());
        ((PlayerEntityInterface)(player)).virtualAdditions$setProjectionEntity(entity);
        return entity;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.getPlayer() == null || this.getPlayer().method_31481() || !this.getPlayer().method_6115() || !this.getPlayer().method_6030().method_31574(VAItems.SPECTRAL_SPYGLASS) || this.method_5739(this.getPlayer()) > 72) {
            if (!this.method_73183().method_8608()) {
                this.method_5650(class_5529.field_26999);
            }
        } else {
            this.isMainPlayer = this.getPlayer().method_7340();
        }
    }

    @Override
    protected void method_6031(float bodyRotation) {
        super.method_6031(bodyRotation);
    }

    @Override
    public void method_5683(float yaw, int interpolationSteps) {
        super.method_5683(yaw, interpolationSteps);
    }

    @Override
    protected void method_52532(int step, double x, double y, double z, double yaw, double pitch) {
        super.method_52532(step, x, y, z, yaw, pitch);
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.player == null && this.field_6011.method_12789(PLAYER_ID) instanceof UUID playerId && !playerId.equals(EMPTY_ID)) {
            this.player = this.method_73183().method_18470(playerId);
        }
        if (this.method_73183().method_8608() && this.player != null && this.field_6012 % 2 == 0) {
            this.spawnTrailParticles();
        }
    }

    public boolean isPhasingThroughWall() {
        if (this.isPhasingThroughWallLastCheck != this.method_73183().method_8510()) {
            this.field_5960 = false;
            this.isPhasingThroughWall = this.method_5757();
            this.field_5960 = true;
            this.isPhasingThroughWallLastCheck = this.method_73183().method_8510();
        }
        return this.isPhasingThroughWall;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public void method_36209() {
        if (this.getPlayer() != null) {
            if (this.getPlayer().method_7340()) class_310.method_1551().method_1504(class_310.method_1551().field_1724);
        }
    }

    @Override
    public void method_5650(class_5529 reason) {
        super.method_5650(reason);
        if (this.getPlayer() instanceof class_3222 serverPlayer) {
            if (!serverPlayer.method_7357().method_7904(VAItems.SPECTRAL_SPYGLASS.method_7854())) serverPlayer.method_7357().method_62835(VAItems.SPECTRAL_SPYGLASS.method_7854(), 20);
            serverPlayer.method_6021();
            ((PlayerEntityInterface)(player)).virtualAdditions$setProjectionEntity(null);
        }
    }

    @Environment(EnvType.CLIENT)
    @Override
    protected void method_49481(class_1657 controllingPlayer, class_243 movementInput) {
        super.method_49481(controllingPlayer, movementInput);
        if (controllingPlayer instanceof class_746 clientPlayerEntity) {
            class_241 vec2f1 = class_746.method_67271(clientPlayerEntity.field_3913.method_3128());
            double d = clientPlayerEntity.field_3913.field_54155.comp_3163() ? 0.2 : clientPlayerEntity.field_3913.field_54155.comp_3164() ? -0.2 : 0.0;
            class_243 vec3d = new class_243(vec2f1.field_1343 * 0.2, d , vec2f1.field_1342 * 0.2);
            this.method_5724(0.15F, vec3d);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(this.isPhasingThroughWall() ? 0.2F : 0.91F));
        }
    }

    @Environment(EnvType.CLIENT)
    private void spawnTrailParticles() {
        if (this.getPlayer() == null) return;
        class_243 playerRelative = this.player.method_33571().method_1020(this.method_33571());
        class_243 pos = new class_243(this.method_23322(0.35), this.method_23319(), this.method_23325(0.35)).method_1019(playerRelative.method_1021(0.5 / Math.max(playerRelative.method_1033(), 0.001)));
        class_243 playerPos = new class_243(this.player.method_23322(0.6), this.player.method_23319(), this.player.method_23325(0.6));
        class_2394 effect = new class_10339(playerPos, 0xE0EFFF, this.method_73183().field_9229.method_43048(20) + 10);
        this.method_73183().method_8466(effect, true, true, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
    }

    @Environment(EnvType.CLIENT)
    public void sendMovementPackets() {
        boolean anglesChanged = this.lookDirectionChanged;
        boolean posChanged = this.method_73189().field_1352 != this.field_6014 || this.method_73189().field_1351 != this.field_6036 || this.method_73189().field_1350 != this.field_5969;
        PlayerProjectionMovementC2SPayload payload = null;
        if (anglesChanged && posChanged) {
            payload = PlayerProjectionMovementC2SPayload.createFull(this);
        } else if (posChanged) {
            payload = PlayerProjectionMovementC2SPayload.createPosOnly(this);
        } else if (anglesChanged) {
            payload = PlayerProjectionMovementC2SPayload.createAnglesOnly(this);
        }
        this.lookDirectionChanged = false;
        if (payload != null) ClientPlayNetworking.send(payload);
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        if (this.getPlayer() != null && this.method_73183() instanceof class_3218 serverWorld) {
            this.player.method_64397(serverWorld, ((DamageSourcesInterface)this.method_48923()).virtualAdditions$soulDestroyed(this, damageSource.method_5529()), 1000);
        }
    }

    @Override
    public float method_5705(float tickProgress) {
        return this.method_66248() ? this.field_6241 : super.method_36454();
    }

    @Nullable
    @Override
    public class_1309 method_5642() {
        return this.getPlayer();
    }

    @Override
    protected boolean method_66248() {
        return this.isMainPlayer;
    }

    @Override
    public boolean method_65038() {
        return true;
    }

    @Override
    public class_1306 method_6068() {
        return this.getPlayer() != null ? this.getPlayer().method_6068() : super.method_6068();
    }

    @Override
    public boolean method_74091(class_1664 part) {
        return (part.method_7429().equals("head") || part.method_7429().equals("hat")) && super.method_74091(part);
    }

    @Override
    public class_4048 method_55694(class_4050 pose) {
        return this.method_5864().method_18386().method_18383(this.method_17825());
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    @Environment(EnvType.CLIENT)
    public void setClientPlayer(class_746 player) {
        this.player = player;
    }
}
