package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.component.ExplosiveContentComponent;
import com.github.suninvr.virtualadditions.registry.VADataComponentTypes;
import com.github.suninvr.virtualadditions.registry.VAEntityType;
import com.github.suninvr.virtualadditions.registry.VAItems;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.entity.*;

public class SteelBombEntity extends class_3857 {
    class_1799 stack;
    int fuseLength;

    private final class_5362 explosionBehavior = new class_5361(this) {
        @Override
        public boolean method_29554(class_1927 explosion, class_1922 world, class_2338 pos, class_2680 state, float power) {
            ExplosiveContentComponent component = SteelBombEntity.this.stack.method_58694(VADataComponentTypes.EXPLOSIVE_CONTENTS);
            if (component != null && !component.shouldDestroyBlocks()) return false;
            return super.method_29554(explosion, world, pos, state, power);
        }

        @Override
        public boolean method_55504(class_1927 explosion, class_1297 entity) {
            return !(entity instanceof class_1542) && !(entity instanceof class_1303);
        }

        @Override
        public float method_55115(class_1927 explosion, class_1297 entity, float amount) {
            return Math.min(super.method_55115(explosion, entity, amount) * 1.25F, 6.0F * explosion.method_55107());
        }
    };

    public SteelBombEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public SteelBombEntity(class_1937 world, class_1309 owner) {
        super(VAEntityType.STEEL_BOMB, owner, world, VAItems.STEEL_BOMB.method_7854());
    }

    public SteelBombEntity(class_1937 world, double x, double y, double z) {
        super(VAEntityType.STEEL_BOMB, x, y, z, world, VAItems.STEEL_BOMB.method_7854());
    }

    public SteelBombEntity(class_3218 serverWorld, class_1309 livingEntity, class_1799 itemStack) {
        super(VAEntityType.STEEL_BOMB, livingEntity, serverWorld, itemStack);
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        this.explode();
        this.method_31472();
    }

    @Override
    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
    }

    protected void explode() {
        if (!this.method_73183().method_8608()) {
            this.method_73183().method_55117(this, this.method_73183().method_48963().method_48819(this, this.method_24921()), this.explosionBehavior, this.method_23317(), this.method_23318(), this.method_23321(), this.getExplosivePower(), this.method_5809(), class_1937.class_7867.field_40891);
            this.method_73183().method_8421(this, (byte)3);
            this.method_31472();
        }
    }

    protected float getExplosivePower() {
        ExplosiveContentComponent component = this.stack.method_58694(VADataComponentTypes.EXPLOSIVE_CONTENTS);
        if (component != null) return component.getExplosionStrength();
        return 2;
    }

    protected int getFuseLength() {
        ExplosiveContentComponent component = this.stack.method_58694(VADataComponentTypes.EXPLOSIVE_CONTENTS);
        if (component != null) return component.getFuseLength();
        return 200;
    }

    @Override
    protected class_1792 method_16942() {
        return VAItems.STEEL_BOMB;
    }

    @Override
    public void method_16940(class_1799 stack) {
        super.method_16940(stack);
        this.stack = stack;
        this.fuseLength = this.getFuseLength();
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if( this.fuseLength > 0 ) {
            this.fuseLength -= 1;
        } else if (this.fuseLength == 0) {
            this.explode();
        }
        if(this.method_73183().method_8608() && !this.field_6000) {
            this.method_73183().method_8406(class_2398.field_17430, this.method_23317(), this.method_23318(), this.method_23321(), 0.0F, 0.05F, 0.0F);
        }
    }
}
