package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.item.GildType;
import com.github.suninvr.virtualadditions.item.GildedToolUtil;
import com.github.suninvr.virtualadditions.item.interfaces.GildedToolItem;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReceiver;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1731;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_5250;
import net.minecraft.class_8047;
import net.minecraft.class_8828;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.screen.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

@Mixin(class_1706.class)
public abstract class AnvilScreenHandlerMixin extends class_4861 {

    @Shadow @Final private class_3915 levelCost;

    @Shadow @Nullable private String newItemName;

    public AnvilScreenHandlerMixin(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context, class_8047 forgingSlotsManager) {
        super(type, syncId, playerInventory, context, forgingSlotsManager);
    }

    @WrapOperation(method = "updateResult", at = @At(value = "INVOKE", target = "Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal = 0))
    boolean virtualAdditions$compareGildedToolItems(class_1799 instance, class_1792 item, Operation<Boolean> original) {
        return original.call(instance, item) || GildedToolUtil.getBaseStack(instance).method_31574(item instanceof GildedToolItem gildedToolItem ? gildedToolItem.getBaseItem() : item);
    }

    @WrapOperation(method = "onTakeOutput", at = @At(value = "INVOKE", target = "Lnet/minecraft/inventory/Inventory;setStack(ILnet/minecraft/item/ItemStack;)V"))
    void virtualAdditions$setEngravingChiselStack(class_1263 instance, int i, class_1799 stack, Operation<Void> original) {
        class_1799 stack1 = instance.method_5438(1);
        class_3218 world = this.field_22482.method_73183().method_8608() ? null : (class_3218) this.field_22482.method_73183();
        if (!(world == null) && i == 1 && stack1.method_31574(VAItems.ENGRAVING_CHISEL) && stack1.method_7919() < 63) {
            int j = field_22482.method_68878() ? 0 : class_1890.method_60117(world, stack1, 1);
            stack1.method_7974(stack1.method_7919() + j);
            instance.method_5447(1, stack1);
        }
        else original.call(instance, i, stack);
    }

    @WrapOperation(method = "updateResult", at = @At(value = "INVOKE", target = "Lnet/minecraft/inventory/CraftingResultInventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal = 4))
    void virtualAdditions$setStack(class_1731 instance, int slot, class_1799 stack, Operation<Void> original) {
        class_1799 baseStack = this.method_7611(0).method_7677();
        class_1799 additionsStack = this.method_7611(1).method_7677();

        if (baseStack.method_7909() instanceof GildedToolItem || additionsStack.method_7909() instanceof GildedToolItem) {
            class_1799 baseBaseStack = GildedToolUtil.getBaseStack(baseStack);
            class_1799 additionsBaseStack = GildedToolUtil.getBaseStack(additionsStack);
            GildType baseType = GildedToolItem.getGildType(baseStack);
            GildType additionsType = GildedToolItem.getGildType(additionsStack);
            if (baseBaseStack.method_31574(additionsBaseStack.method_7909()) && !(baseType.equals(additionsType))) {
                class_1799 resultStack = baseStack.method_7972();
                resultStack.method_57365(stack.method_57353());
                this.levelCost.method_17404(this.levelCost.method_17407() + 3);
                instance.method_5447(slot, resultStack);
                return;
            }
        }
        original.call(instance, slot, stack);
    }

    @Inject(method = "updateResult", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$updateResultForInscryptionChisel(CallbackInfo ci) {
        class_1799 baseStack = this.method_7611(0).method_7677();
        class_1799 additionsStack = this.method_7611(1).method_7677();

        if (additionsStack.method_31574(VAItems.ENGRAVING_CHISEL) && this.newItemName != null) {
            class_1799 resultStack = baseStack.method_7972();
            class_9290 lore = resultStack.method_57826(class_9334.field_49632) ? resultStack.method_58694(class_9334.field_49632) : new class_9290(List.of());
            int color = additionsStack.method_57826(class_9334.field_49644) ? additionsStack.method_58694(class_9334.field_49644).comp_2384() : 0x757D97;
            if (lore.comp_2400().size() >= 10) return;
            lore = lore.method_57499(class_5250.method_43477(class_8828.method_54232(this.newItemName)).method_27696(class_2583.field_24360.method_36139(color).method_10978(false)));
            resultStack.method_57379(class_9334.field_49632, lore);
            this.levelCost.method_17404(1);
            this.field_22479.method_5447(0, resultStack);
            ci.cancel();
        }

    }
}
