package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.client.VARenderers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_10034;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_630;

@Mixin(class_572.class)
public abstract class BipedEntityModelMixin<T extends class_10034> extends class_583 {
    @Shadow @Final public class_630 leftArm;

    @Shadow @Final public class_630 rightArm;

    @Shadow @Final public class_630 head;

    protected BipedEntityModelMixin(class_630 root) {
        super(root);
    }

    @Inject(method = "positionLeftArm", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$positionLeftArmForHalberd(T state, class_572.class_573 armPose, CallbackInfo ci) {
        if (state.field_53414 && Boolean.TRUE.equals(state.getData(VARenderers.IS_HOLDING_HALBERD)) && Objects.nonNull(state.getData(VARenderers.HALBERD_READINESS))) {
            float f = state.getData(VARenderers.HALBERD_READINESS);
            float ef = (float) Math.sin(Math.PI * (f / 2));
            float eg = 1.0F - ef;
            this.field_54014.field_3675 = (float) ((ef * -55) * Math.PI / 180.0F);
            this.head.field_3675 = (state.field_53447 + (ef * 55)) * (float) (Math.PI / 180.0);
            this.leftArm.field_3654 = (float) (-80.0F * (Math.PI / 180.0F));
            this.leftArm.field_3675 = (float) (ef * -40.0F * (Math.PI / 180.0F));
            this.leftArm.field_3674 = (float) (eg * -20.0F * (Math.PI / 180.0F));
            this.rightArm.field_3654 = (float) ( (eg*40 + -95.0F) * (Math.PI / 180.0F));
            this.rightArm.field_3675 = (float) ((-20.0F + -40.0F*eg) * (Math.PI / 180.0F));
            this.rightArm.field_3674 = (float) ((30.0F + 30.0 * ef) * (Math.PI / 180.0F));
            ci.cancel();
        }
    }
    @Inject(method = "positionRightArm", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$positionRightArmForHalberd(T state, class_572.class_573 armPose, CallbackInfo ci) {
        if (state.field_53414 && Boolean.TRUE.equals(state.getData(VARenderers.IS_HOLDING_HALBERD)) && Objects.nonNull(state.getData(VARenderers.HALBERD_READINESS))) {
            float f = state.getData(VARenderers.HALBERD_READINESS);
            float ef = (float) Math.sin(Math.PI * (f / 2));
            float eg = 1.0F - ef;
            this.field_54014.field_3675 = (float) ((ef * 55) * Math.PI / 180.0F);
            this.head.field_3675 = (state.field_53447 + (ef * -55)) * (float) (Math.PI / 180.0);
            this.rightArm.field_3654 = (float) (-80.0F * (Math.PI / 180.0F));
            this.rightArm.field_3675 = (float) (ef * 40.0F * (Math.PI / 180.0F));
            this.rightArm.field_3674 = (float) (eg * 20.0F * (Math.PI / 180.0F));
            this.leftArm.field_3654 = (float) ( (eg*40 + -95.0F) * (Math.PI / 180.0F));
            this.leftArm.field_3675 = (float) ((20.0F + 40.0F*eg) * (Math.PI / 180.0F));
            this.leftArm.field_3674 = (float) ((-30.0F + -30.0 * ef) * (Math.PI / 180.0F));
            ci.cancel();
        }
    }
}
