package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.client.sound.FlyingLumwaspSoundInstance;
import com.github.suninvr.virtualadditions.entity.LumwaspEntity;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_2535;
import net.minecraft.class_2726;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public abstract class ClientPlayNetworkHandlerMixin extends class_8673 {

    protected ClientPlayNetworkHandlerMixin(class_310 client, class_2535 connection, class_8675 connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method = "playSpawnSound", at = @At("HEAD"))
    void virtualAdditions$playLumwaspLoopSound(class_1297 entity, CallbackInfo ci) {
        if (entity instanceof LumwaspEntity lumwaspEntity && lumwaspEntity.method_6581()) {
            this.field_45588.method_1483().method_22140(new FlyingLumwaspSoundInstance(lumwaspEntity));
        }
    }

    @Inject(method = "onEntitySetHeadYaw", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/Entity;updateTrackedHeadRotation(FI)V", shift = At.Shift.BEFORE), cancellable = true)
    void virtualAdditions$surpressYawSyncForPlayerProjection(class_2726 packet, CallbackInfo ci, @Local class_1297 entity) {
        if (entity instanceof PlayerProjectionEntity playerProjectionEntity && playerProjectionEntity.getPlayer() == this.field_45588.field_1724) ci.cancel();
    }
}
