package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.entity.AcidSpitEntity;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.interfaces.DamageSourcesInterface;
import com.github.suninvr.virtualadditions.registry.VADamageTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_8109;
import net.minecraft.class_8110;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_8109.class)
public abstract class DamageSourcesMixin implements DamageSourcesInterface {

    @Shadow public abstract class_1282 create(class_5321<class_8110> key);

    @Shadow public abstract class_1282 create(class_5321<class_8110> key, @Nullable class_1297 source, @Nullable class_1297 attacker);

    private class_1282 acid;

    @Inject(method = "<init>", at = @At("TAIL"), locals = LocalCapture.CAPTURE_FAILHARD)
    void virtualAdditions$customDamageSources(class_5455 registryManager, CallbackInfo ci) {
        this.acid = this.create(VADamageTypes.ACID);
    }

    @Override
    public class_1282 virtualAdditions$acid() {
        return this.acid;
    }

    public class_1282 virtualAdditions$acidSpit(AcidSpitEntity source, @Nullable class_1297 attacker) {
        return this.create(VADamageTypes.ACID_SPIT, source, attacker);
    }

    public class_1282 virtualAdditions$soulDestroyed(@Nullable PlayerProjectionEntity source, @Nullable class_1297 attacker) {
        return this.create(VADamageTypes.SOUL_DESTROYED, source, attacker);
    }
}
