package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.item.ProjectionSpyglassItem;
import net.minecraft.class_10799;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

@Mixin(class_329.class)
public class InGameHudMixin {
    @Shadow @Final private class_310 client;

    @Shadow private float spyglassScale;
    @Unique
    private static final class_2960 SPECTRAL_SPYGLASS_SCOPE = idOf("textures/misc/spectral_spyglass_scope.png");

    @Unique
    private void virtualAdditions$renderSpectralSpyglassOverlay(class_332 context, float scale) {
        float f = (float)Math.min(context.method_51421(), context.method_51443());
        float h = Math.min((float)context.method_51421() / f, (float)context.method_51443() / f) * scale;
        int i = class_3532.method_15375(f * h);
        int j = class_3532.method_15375(f * h);
        int k = (context.method_51421() - i) / 2;
        int l = (context.method_51443() - j) / 2;
        int m = k + i;
        int n = l + j;
        context.method_25290(class_10799.field_56883, SPECTRAL_SPYGLASS_SCOPE, k, l, 0.0F, 0.0F, i, j, i, j);
        context.method_48196(class_10799.field_56879, 0, n, context.method_51421(), context.method_51443(), -16777216);
        context.method_48196(class_10799.field_56879, 0, 0, context.method_51421(), l, -16777216);
        context.method_48196(class_10799.field_56879, 0, l, k, n, -16777216);
        context.method_48196(class_10799.field_56879, m, l, context.method_51421(), n, -16777216);
    }

    @Inject(method = "renderMiscOverlays", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$renderSpectralSpyglassMiscOverlay(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        if (this.client.field_1690.method_31044().method_31034() && ProjectionSpyglassItem.isInUseBy(this.client.field_1724)) {
            float f = tickCounter.method_60636();
            this.spyglassScale = class_3532.method_16439(0.5F * f, this.spyglassScale, 1.125F);
            this.virtualAdditions$renderSpectralSpyglassOverlay(context, this.spyglassScale);
            ci.cancel();
        }
    }

    @Inject(method = "getCameraPlayer", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$getCameraPlayerFromProjection(CallbackInfoReturnable<class_1657> cir) {
        if (this.client.method_1560() instanceof PlayerProjectionEntity playerProjectionEntity && ProjectionSpyglassItem.isInUseBy(this.client.field_1724)) cir.setReturnValue(playerProjectionEntity.getPlayer());
    }
}
