package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.component.EffectsOnHitComponent;
import com.github.suninvr.virtualadditions.registry.VADataComponentTypes;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@SuppressWarnings("DataFlowIssue")
@Mixin(class_1792.class)
public class ItemMixin {

    @Inject(at = @At("HEAD"), method = "getItemBarColor", cancellable = true)
    private void virtualAdditions$getItemBarColorForAppliedEffect(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        EffectsOnHitComponent component;
        if ((component = stack.method_58694(VADataComponentTypes.EFFECTS_ON_HIT)) != null && component.hasEffectsComponent() && component.getRemainingUses() > 0) cir.setReturnValue(component.getColor());
    }

    @Inject(at = @At("HEAD"), method = "getItemBarStep", cancellable = true)
    void virtualAdditions$getItemBarStepForAppliedPotion(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        EffectsOnHitComponent component;
        if ((component = stack.method_58694(VADataComponentTypes.EFFECTS_ON_HIT)) != null && component.getRemainingUses() > 0) {
            cir.setReturnValue(component.getItemBarAmount());
        }
    }

    @Inject(at = @At("HEAD"), method = "isItemBarVisible", cancellable = true)
    void virtualAdditions$isAppliedPotionBarVisible(class_1799 stack, CallbackInfoReturnable<Boolean> cir) {
        EffectsOnHitComponent component = stack.method_58694(VADataComponentTypes.EFFECTS_ON_HIT);
        if (component != null && component.getRemainingUses() > 0) cir.setReturnValue(true);
    }

}
