package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.entity.SpectreEntity;
import com.github.suninvr.virtualadditions.item.GildTypes;
import com.github.suninvr.virtualadditions.item.interfaces.GildedToolItem;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VAStatusEffects;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Collection;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5709;
import net.minecraft.class_5745;
import net.minecraft.class_6880;

@SuppressWarnings("ConstantValue")
@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {

    @Shadow protected boolean dead;

    @Shadow @Nullable public abstract class_1293 getStatusEffect(class_6880<class_1291> effect);

    @Shadow public abstract boolean hasStatusEffect(class_6880<class_1291> effect);

    @Shadow public abstract Collection<class_1293> getStatusEffects();

    @Unique private long lastHurtByFesteringWounds;

    @Unique private float experienceMultiplier = 1.0F;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "onDeath", at = @At("HEAD"))
    void virtualAdditions$setExperienceMultiplier(class_1282 source, CallbackInfo ci) {
        if (!this.method_31481() && !this.dead && !((class_1309)(Object)(this) instanceof class_1657)) {
            class_1297 entity = source.method_5529();
            if (entity instanceof class_1657 playerEntity) {
                class_1799 stack = playerEntity.method_6047();
                if (GildedToolItem.getGildType(stack).equals(GildTypes.EMERALD)) {
                    this.experienceMultiplier = 1.6F;
                }
            }
        }
    }

    @Inject(method = "onRemove", at = @At("HEAD"))
    void virtualAdditions$onRemoveSpectre(class_5529 reason, CallbackInfo ci) {
        if ((Object)(this) instanceof SpectreEntity spectre) {
            spectre.setBuffTarget(null);
        }
    }

    @Inject(method = "modifyAppliedDamage", at = @At("RETURN"), cancellable = true)
    void virtualAdditions$modifyAppliedDamageForFrailty(class_1282 source, float amount, CallbackInfoReturnable<Float> cir) {
        if (this.hasStatusEffect(VAStatusEffects.FRAILTY)) cir.setReturnValue(cir.getReturnValueF() * (1.0F + (0.2F * (this.getStatusEffect(VAStatusEffects.FRAILTY).method_5578() + 1))));
    }

    @Inject(method = "applyDamage", at = @At("TAIL"))
    void virtualAdditions$spreadDamageForFesteringWoundsEffect(class_3218 world, class_1282 source, float amount, CallbackInfo ci) {
        if (this.hasStatusEffect(VAStatusEffects.FESTERING_WOUNDS) && this.lastHurtByFesteringWounds != world.method_8510()) {
            this.lastHurtByFesteringWounds = world.method_8510();
            world.method_18467(class_1309.class, this.method_5829().method_1009(12, 12, 12)).stream().filter(entity -> entity != (Object)this).forEach(entity -> {
                if (entity.method_6059(VAStatusEffects.FESTERING_WOUNDS)) {
                    if (entity.method_64397(world, source, amount)) {
                        this.getStatusEffects().forEach(statusEffectInstance -> {
                            class_6880<class_1291> effect = statusEffectInstance.method_5579();
                            if (!entity.method_6059(effect) || entity.method_6112(effect).method_5587(statusEffectInstance) < 0) {
                                entity.method_6092(statusEffectInstance);
                            }
                        });
                        world.method_65096(new class_5745(new class_5709(entity, entity.method_18381(entity.method_18376())), 8), this.method_23317(), this.method_23320(), this.method_23321(), 1, 0, 0, 0, 0);
                        world.method_8396(entity, entity.method_24515(), class_3417.field_37358, entity.method_5634(), 1.0F, 0.5F);
                    }
                };
            });
        }
    }

    @Inject(method = "isClimbing", at = @At("HEAD"), cancellable = true)
    void virtualAdditions$isClimbingRope(CallbackInfoReturnable<Boolean> cir) {
        if (!this.method_7325() && !(this.method_73183() == null)) {
            if (this.method_73183().method_8320(this.method_24515()).method_26220(this.method_73183(), this.method_24515()).equals(class_259.method_1073())) {
                class_2338 blockPos = this.method_24515().method_10074();
                class_2680 state = this.method_73183().method_8320(blockPos);
                if (state.method_26164(VABlockTags.CLIMBING_ROPES)) cir.setReturnValue(true);
            }
        }
    }

    @Inject(method = "getExperienceToDrop(Lnet/minecraft/server/world/ServerWorld;Lnet/minecraft/entity/Entity;)I", at = @At("RETURN"), cancellable = true)
    void virtualAdditions$getModifiedXpToDrop(class_3218 world, class_1297 attacker, CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((int) (cir.getReturnValueI() * this.experienceMultiplier));
    }

    @Inject(method = "travelControlled", at = @At("HEAD"))
    void virtualAdditions$travelConteolled(class_1657 controllingPlayer, class_243 movementInput, CallbackInfo ci) {
    }
}
