package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.block.OxidizableClimbingRopeAnchor;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VACollections;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_5955;

@Mixin(class_5955.class)
public interface OxidizableMixin {
    @Inject(method = "getDecreasedOxidationBlock", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$getDecreasedOxidationClimbingRope(class_2248 block, CallbackInfoReturnable<Optional<class_2248>> cir) {
        if (block instanceof OxidizableClimbingRopeAnchor) {
            cir.setReturnValue(Optional.ofNullable(VACollections.CLIMBING_ROPE_OXIDIZATION_DECREASES.get().get(block)));
        }
    }

    @Inject(method = "getIncreasedOxidationBlock", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$getIncreasedOxidationClimbingRope(class_2248 block, CallbackInfoReturnable<Optional<class_2248>> cir) {
        if (block instanceof OxidizableClimbingRopeAnchor) {
            cir.setReturnValue(Optional.ofNullable(VACollections.CLIMBING_ROPE_OXIDIZATION_INCREASES.get().get(block)));
        }
    }

    @Inject(method = "getUnaffectedOxidationBlock", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$getUnaffectedOxidationClimbingRope(class_2248 block, CallbackInfoReturnable<Optional<class_2248>> cir) {
        if (block instanceof OxidizableClimbingRopeAnchor) {
            cir.setReturnValue(Optional.ofNullable(VABlocks.CLIMBING_ROPE_ANCHOR));
        }
    }

}
