package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.interfaces.PlayerEntityInterface;
import com.github.suninvr.virtualadditions.item.GildTypes;
import com.github.suninvr.virtualadditions.item.GildedToolUtil;
import com.github.suninvr.virtualadditions.registry.VADamageTypes;
import com.github.suninvr.virtualadditions.registry.VAEntityAttributes;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalFloatRef;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.apache.logging.log4j.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements PlayerEntityInterface {
    @Shadow public abstract boolean method_5681();

    @Shadow public abstract class_1796 getItemCooldownManager();

    @Unique private PlayerProjectionEntity projection = null;

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    public PlayerProjectionEntity virtualAdditions$getProjectionEntity() {
        return this.projection;
    }

    @Override
    public void virtualAdditions$setProjectionEntity(PlayerProjectionEntity projection) {
        this.projection = projection;
    }

    @Override
    public boolean virtualAdditions$hasProjectionEntity() {
        return this.projection != null;
    }

    @ModifyVariable(method = "attack", at = @At("STORE"), ordinal = 3)
     float virtualAdditions$setCriticalHitDamage(float value, @Local(ordinal = 2) boolean bl3, @Local(ordinal = 0) float f, @Local(ordinal = 1) float g) {
        if (bl3) {
            float h = f + (f * 0.333333333F * ((float) this.method_45325(VAEntityAttributes.CRITICAL_HIT_FACTOR) - 1));
            return h + g;
        } else return value;
    }

    @Inject(method = "createPlayerAttributes", at = @At("RETURN"), cancellable = true)
    private static void virtualAdditions$createPlayerAttributes(CallbackInfoReturnable<class_5132.class_5133> cir) {
        cir.setReturnValue(cir.getReturnValue().method_26867(VAEntityAttributes.CRITICAL_HIT_FACTOR));
    }

    @Inject(method = "getBlockBreakingSpeed", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/effect/StatusEffectUtil;hasHaste(Lnet/minecraft/entity/LivingEntity;)Z", shift = At.Shift.BEFORE))
    void virtualAdditions$getBlockBreakingSpeedForSculkGildedTools(class_2680 block, CallbackInfoReturnable<Float> cir, @Local LocalFloatRef f) {
        if (f.get() <= 1.0F) return;
        class_1657 player = ((class_1657)(Object)this);
        class_1799 stack = player.method_6047();
        if (GildedToolUtil.getGildType(stack).equals(GildTypes.SCULK)) {
            f.set((float) (f.get() - player.method_45325(class_5134.field_51581)));
        }
    }

    @Inject(method = "getBlockBreakingSpeed", at = @At("RETURN"), cancellable = true)
    public void virtualAdditions$getBlockBreakingSpeed(class_2680 block, CallbackInfoReturnable<Float> cir) {
        float r = cir.getReturnValue();
        class_1657 player = ((class_1657)(Object)this);

        class_1297 entity = player.method_5668();
        boolean bl = entity.method_24828() || (entity instanceof class_1309 livingEntity && livingEntity.method_6101());
        if (bl && !player.method_24828()) r *= 5.0F;

        cir.setReturnValue(r);
    }

    @Inject(method = "damageArmor", at = @At("HEAD"))
    void virtualAdditions$damageArmorFromAcid(class_1282 source, float amount, CallbackInfo ci, @Local(argsOnly = true) LocalFloatRef amountRef) {
        if (source.method_48789(VADamageTypes.INCREASED_ARMOR_DAMAGE)) amountRef.set(amountRef.get() * 3.0F);
    }

    @Inject(method = "damage", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V", shift = At.Shift.AFTER))
    void virtualAdditions$cancelSpectralSpyglassUsage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_6115() && this.method_6030().method_31574(VAItems.SPECTRAL_SPYGLASS)) {
            this.getItemCooldownManager().method_62835(this.method_6030(), 100);
            this.method_6021();
        }
    }
}
