package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.interfaces.RecipeManagerInterface;
import com.github.suninvr.virtualadditions.recipe.ColoringRecipe;
import com.github.suninvr.virtualadditions.recipe.ColoringRecipeDisplay;
import com.github.suninvr.virtualadditions.recipe.ColoringStationRecipe;
import com.github.suninvr.virtualadditions.registry.VAItems;
import net.minecraft.class_10289;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_7699;
import net.minecraft.class_8786;
import net.minecraft.recipe.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Mixin(class_1863.class)
public class ServerRecipeManagerMixin implements RecipeManagerInterface {
    @Shadow private class_10289 preparedRecipes;
    @Unique private ColoringRecipeDisplay.Grouping<ColoringStationRecipe> coloringRecipes = ColoringRecipeDisplay.Grouping.empty();

    @Inject(method = "initialize", at = @At("TAIL"))
    void virtualAdditions$initializeColoringRecipes(class_7699 features, CallbackInfo ci) {
        List<ColoringRecipeDisplay.GroupEntry<ColoringStationRecipe>> recipes = new ArrayList<>();
        this.preparedRecipes.method_64695().forEach(recipeEntry -> {
            class_1860<?> recipe = recipeEntry.comp_1933();
            if (recipe instanceof ColoringStationRecipe coloringRecipe) {
                class_8786<ColoringStationRecipe> coloringRecipeEntry = (class_8786<ColoringStationRecipe>) recipeEntry;
                recipes.add(new ColoringRecipeDisplay.GroupEntry<>(
                        coloringRecipe.getIngredient(),
                        new ColoringRecipeDisplay<>(coloringRecipe.getStackSlotDisplay(), Optional.of(coloringRecipeEntry))
                        ));
            }
        });
        this.coloringRecipes = new ColoringRecipeDisplay.Grouping<>(recipes);
    }

    @Override
    public ColoringRecipeDisplay.Grouping<ColoringStationRecipe> virtualAdditions$getColoringRecipes() {
        return this.coloringRecipes;
    }
}
