package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.registry.VATextureIdentifiers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_8052;

@Mixin(class_8052.class)
public class SmithingTemplateItemMixin {
    @Inject(method = "getArmorTrimEmptyAdditionsSlotTextures", at = @At("RETURN"), cancellable = true)
    private static void virtualAdditions$getArmorTrimEmptyAdditionsSlotTextures(CallbackInfoReturnable<List<class_2960>> cir) {
        ArrayList<class_2960> list = new ArrayList<>(cir.getReturnValue());
        list.add(VATextureIdentifiers.EMPTY_SLOT_IOLITE_TEXTURE);
        list.add(VATextureIdentifiers.EMPTY_SLOT_ROCK_SALT_TEXTURE);
        cir.setReturnValue(list);
    }
}
