package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.registry.VADyeColors;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

@Mixin(class_4722.class)
public class TexturedRenderLayersMixin {
    @Inject(method = "createColorId", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$createVirtualAdditionsColorId(class_1767 color, CallbackInfoReturnable<class_2960> cir) {
        if (VADyeColors.isFromVirtualAdditions(color)) cir.setReturnValue(
                idOf(color.method_7792())
        );
    }
    @Inject(method = "createShulkerId", at = @At("HEAD"), cancellable = true)
    private static void virtualAdditions$createVirtualAdditionsShulkerId(class_1767 color, CallbackInfoReturnable<class_2960> cir) {
        if (VADyeColors.isFromVirtualAdditions(color)) cir.setReturnValue(
                idOf("shulker_" + color.method_7792())
        );
    }
}
