package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.registry.VAItems;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.*;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_3853;

@Mixin(class_3853.class)
public abstract class TradeOffersMixin {
    @Shadow @Final @Mutable
    public static List<Pair<class_3853.class_1652[], Integer>> WANDERING_TRADER_TRADES;

    @Unique private static final class_3853.class_1652 SOULBLOOM_SAPLING_TRADE_OFFER = new class_3853.class_4165(VAItems.SOULBLOOM_SAPLING, 5, 1, 8, 1);
    @Unique private static final class_3853.class_1652 SOULBLOOM_LOG_TRADE_OFFER = new class_3853.class_4165(VAItems.SOULBLOOM_LOG, 1, 8, 4, 1);
    @Unique private static final class_3853.class_1652 CHARTREUSE_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.CHARTREUSE_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 MAROON_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.MAROON_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 INDIGO_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.INDIGO_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 PLUM_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.PLUM_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 VIRIDIAN_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.VIRIDIAN_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 TAN_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.TAN_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 SINOPIA_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.SINOPIA_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 LILAC_DYE_TRADE_OFFER = new class_3853.class_4165(VAItems.LILAC_DYE, 1, 3, 12, 1);
    @Unique private static final class_3853.class_1652 LIGHTNING_BOTTLE_TRADE_OFFER = new class_3853.class_4165(VAItems.LIGHTNING_BOTTLE, 15, 1, 12, 1);
    @Unique private static final class_3853.class_1652 SPRING_LOTUS_TRADE_OFFER = new class_3853.class_4165(VAItems.SMALL_SPRING_LOTUS, 1, 1, 12, 1);

    static {
        ArrayList<Pair<class_3853.class_1652[], Integer>> TRADES = new ArrayList<>();
        ArrayList<class_3853.class_1652> BUY_ITEM_TRADES = new ArrayList<>(List.of(WANDERING_TRADER_TRADES.getFirst().getLeft()));
        ArrayList<class_3853.class_1652> SELL_ITEM_TRADES = new ArrayList<>(List.of(WANDERING_TRADER_TRADES.get(1).getLeft()));
        ArrayList<class_3853.class_1652> SELL_ITEM_TRADES_2 = new ArrayList<>(List.of(WANDERING_TRADER_TRADES.get(2).getLeft()));

        SELL_ITEM_TRADES.add(SOULBLOOM_LOG_TRADE_OFFER);

        SELL_ITEM_TRADES_2.add(SOULBLOOM_SAPLING_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(CHARTREUSE_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(MAROON_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(INDIGO_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(PLUM_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(VIRIDIAN_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(TAN_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(SINOPIA_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(LILAC_DYE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(LIGHTNING_BOTTLE_TRADE_OFFER);
        SELL_ITEM_TRADES_2.add(SPRING_LOTUS_TRADE_OFFER);

        TRADES.add(Pair.of(BUY_ITEM_TRADES.toArray(new class_3853.class_1652[]{}), WANDERING_TRADER_TRADES.getFirst().getRight()));
        TRADES.add(Pair.of(SELL_ITEM_TRADES.toArray(new class_3853.class_1652[]{}), WANDERING_TRADER_TRADES.get(1).getRight()));
        TRADES.add(Pair.of(SELL_ITEM_TRADES_2.toArray(new class_3853.class_1652[]{}), WANDERING_TRADER_TRADES.get(2).getRight()));

        //TRADES.add(Pair.of(new TradeOffers.Factory[]{
        //        LIGHTNING_BOTTLE_TRADE_OFFER
        //        }, 1
        //));

        WANDERING_TRADER_TRADES = TRADES;
    }
}
