package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.registry.VABiomeKeys;
import com.mojang.datafixers.util.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6554;

@Mixin(class_6554.class)
public abstract class VanillaBiomeParametersMixin {
    @Shadow protected abstract void writeCaveBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome);

    @Shadow protected abstract void writeBiomeParameters(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 temperature, class_6544.class_6546 humidity, class_6544.class_6546 continentalness, class_6544.class_6546 erosion, class_6544.class_6546 weirdness, float offset, class_5321<class_1959> biome);

    @Shadow @Final private class_6544.class_6546 defaultParameter;

    @Shadow @Final private class_6544.class_6546[] temperatureParameters;

    @Shadow @Final private class_6544.class_6546[] erosionParameters;

    @Shadow @Final private class_6544.class_6546[] humidityParameters;

    @Shadow @Final private class_6544.class_6546 nearInlandContinentalness;

    @Shadow @Final private class_6544.class_6546 midInlandContinentalness;

    @Shadow @Final private class_6544.class_6546 farInlandContinentalness;

    @Unique private final class_6544.class_6546 farInlandContinentalnessUpper = class_6544.class_6546.method_38121(0.63333F, 1.0F);

    @Inject(method = "writeCaveBiomes", at = @At("TAIL"))
    void virtualAdditions$writeCaveBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, CallbackInfo ci) {
        this.writeCaveBiomeParameters(
                parameters,
                class_6544.class_6546.method_38121(0.7F, 1.0F),
                class_6544.class_6546.method_38121(-1.0F, -0.5F),
                this.defaultParameter,
                this.defaultParameter,
                this.defaultParameter,
                0.0F,
                VABiomeKeys.WASP_DEN
        );
        this.writeCaveBiomeParameters(
                parameters,
                this.defaultParameter,
                this.defaultParameter,
                class_6544.class_6546.method_38121(-0.9F, -0.44F),
                class_6544.class_6546.method_38121(0.6F, 1.0F),
                this.defaultParameter,
                0.0F,
                VABiomeKeys.SALTY_CAVES
        );
    }

    @Inject(method = "writeLowBiomes", at = @At("TAIL"))
    void virtualAdditions$writeLowBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo ci) {
        if (weirdness.comp_104() <= 0.0) return;
        virtualAdditions$writeSoulGrove(parameters, weirdness);
    }

    @Inject(method = "writeMidBiomes", at = @At("TAIL"))
    void virtualAdditions$writeMidBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo ci) {
        if (weirdness.comp_104() <= 0.0) return;
        virtualAdditions$writeSoulGrove(parameters, weirdness);
    }

    @Inject(method = "writeHighBiomes", at = @At("TAIL"))
    void virtualAdditions$writeHighBiomes(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness, CallbackInfo ci) {
        if (weirdness.comp_104() <= 0.0) return;
        virtualAdditions$writeSoulGrove(parameters, weirdness);
    }

    @Unique
    void virtualAdditions$writeSoulGrove(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, class_6544.class_6546 weirdness) {
        this.writeBiomeParameters(
                parameters,
                this.temperatureParameters[2],
                class_6544.class_6546.method_38123(this.humidityParameters[3], this.humidityParameters[4]),
                class_6544.class_6546.method_38121(0.46667F, 1.0F),
                class_6544.class_6546.method_38123(this.erosionParameters[0], this.erosionParameters[4]),
                weirdness,
                0.0F,
                VABiomeKeys.SOUL_GROVE
        );
    }
}
