package com.github.suninvr.virtualadditions.mixin;

import com.github.suninvr.virtualadditions.registry.VAItems;
import com.google.common.collect.ImmutableMap;
import org.spongepowered.asm.mixin.*;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1646;
import net.minecraft.class_1792;

@Mixin(class_1646.class)
public class VillagerEntityMixin {

    @Shadow @Final @Mutable
    public static Map<class_1792, Integer> ITEM_FOOD_VALUES;

    @Unique
    private static final Map<class_1792, Integer> virtualAddition$ITEM_FOOD_VALUES = ImmutableMap.of(
            VAItems.CORN, 1,
            VAItems.TOMATO, 1,
            VAItems.CABBAGE, 2,
            VAItems.WISDOM_BERRY, 1
    );

    static {
        ArrayList<class_1792> newItemFoodKeys = new ArrayList<>(ITEM_FOOD_VALUES.keySet());
        ArrayList<Integer> newItemFoodValues = new ArrayList<>(ITEM_FOOD_VALUES.values());
        newItemFoodKeys.addAll(virtualAddition$ITEM_FOOD_VALUES.keySet());
        newItemFoodValues.addAll(virtualAddition$ITEM_FOOD_VALUES.values());
        ArrayList<Map.Entry<class_1792, Integer>> entries = new ArrayList<>();
        int i = 0;
        while (i < newItemFoodKeys.size()) {
            entries.add(Map.entry(newItemFoodKeys.get(i), newItemFoodValues.get(i)));
            i++;
        }
        ITEM_FOOD_VALUES = ImmutableMap.ofEntries(entries.toArray(new Map.Entry[]{}));
    }
}
