package com.github.suninvr.virtualadditions.network;

import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import com.github.suninvr.virtualadditions.registry.VAPackets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_4844;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record PlayerProjectionMovementC2SPayload(UUID entityId, Optional<class_243> pos, Optional<Float> pitch, Optional<Float> yaw) implements class_8710 {
    public static final class_9139<class_2540, PlayerProjectionMovementC2SPayload> CODEC = class_9139.method_56905(
            class_4844.field_48453, PlayerProjectionMovementC2SPayload::entityId,
            class_9135.method_56382(class_243.field_52694), PlayerProjectionMovementC2SPayload::pos,
            class_9135.field_48552.method_56433(class_9135::method_56382), PlayerProjectionMovementC2SPayload::pitch,
            class_9135.field_48552.method_56433(class_9135::method_56382), PlayerProjectionMovementC2SPayload::yaw,
            PlayerProjectionMovementC2SPayload::new
    );

    public static PlayerProjectionMovementC2SPayload createFull(PlayerProjectionEntity entity) {
        return new PlayerProjectionMovementC2SPayload(entity.method_5667(), Optional.of(entity.method_73189()), Optional.of(entity.method_36455()), Optional.of(entity.method_36454()));
    }

    public static PlayerProjectionMovementC2SPayload createPosOnly(PlayerProjectionEntity entity) {
        return new PlayerProjectionMovementC2SPayload(entity.method_5667(), Optional.of(entity.method_73189()), Optional.empty(), Optional.empty());
    }

    public static PlayerProjectionMovementC2SPayload createAnglesOnly(PlayerProjectionEntity entity) {
        return new PlayerProjectionMovementC2SPayload(entity.method_5667(), Optional.empty(), Optional.of(entity.method_36455()), Optional.of(entity.method_36454()));
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return VAPackets.PLAYER_PROJECTION_MOVEMENT_C2S_ID;
    }
}
