package com.github.suninvr.virtualadditions.recipe;

import com.github.suninvr.virtualadditions.block.entity.DyeContents;
import com.github.suninvr.virtualadditions.registry.VADyeColors;
import com.github.suninvr.virtualadditions.registry.VARecipeType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_314;
import net.minecraft.class_3489;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9282;
import net.minecraft.class_9695;
import net.minecraft.class_9887;
import net.minecraft.recipe.*;
import java.util.List;
import java.util.Optional;

public class ArmorColoringRecipe implements class_1860<class_9695>, ColoringStationRecipe {
    public final class_1856 ingredient;
    public final int index;
    public final class_1769 dyeItem;
    private class_9887 ingredientPlacement;

    public ArmorColoringRecipe(class_1856 ingredient, int index) {
        this.ingredient = ingredient;
        this.index = index;
        class_5321<class_1792>[] key = new class_5321[1];
        ingredient.method_8105().findFirst().ifPresent(item -> key[0] = item.method_40230().get());
        this.dyeItem = key[0] == null ? null : class_7923.field_41178.method_29107(key[0]) instanceof class_1769 dyeItem ? dyeItem : null;
    }

    @Override
    public boolean method_8115(class_9695 inventory, class_1937 world) {
        return inventory.method_59984(0).method_31573(class_3489.field_48803);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public Optional<class_1856> getIngredient() {
        return Optional.of(this.ingredient);
    }

    @Override
    public class_10302.class_10307 getStackSlotDisplay() {
        return new class_10302.class_10307(this.dyeItem.method_7854());
    }

    @Override
    public class_1799 craftWithDye(class_9695 input, class_5455 registryManager, DyeContents dyeContents) {
        DyeContents cost = this.getDyeCost(true);
        if (dyeContents.getR() - cost.getR() >= 0 && dyeContents.getG() - cost.getG() >= 0 && dyeContents.getB() - cost.getB() >= 0 && dyeContents.getY() - cost.getY() >= 0 && dyeContents.getK() - cost.getK() >= 0 && dyeContents.getW() - cost.getW() >= 0) {
            return method_8116(input, registryManager);
        }
        return class_1799.field_8037;
    }

    @Override
    public DyeContents getDyeCost(boolean inverted) {
        DyeContents contents = this.dyeItem != null ? VADyeColors.getContents(this.dyeItem, 4) : DyeContents.empty();
        if (!inverted) contents.multiply(-1);
        return contents;
    }

    @Override
    public class_1799 getResultStack(class_5455 registryManager, class_1799 input) {
        return getResultStack(input);
    }

    public class_1799 getResultStack(class_1799 input) {
        if (!input.method_7960() && this.dyeItem != null) {
            class_1799 result = input.method_7972();
            return class_9282.method_57471(result, List.of(this.dyeItem));
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 method_8116(class_9695 inventory, class_7225.class_7874 wrapperLookup) {
        class_1799 stack = inventory.method_59984(1);
        return this.getResultStack( stack);
    }

    @Override
    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return VARecipeType.ARMOR_COLORING_SERIALIZER;
    }

    @Override
    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return VARecipeType.COLORING;
    }

    @Override
    public class_9887 method_61671() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = class_9887.method_61683(List.of(Optional.of(this.ingredient)));
        }

        return this.ingredientPlacement;
    }

    @Override
    public class_10355 method_64668() {
        return class_314.field_17764;
    }

    public static class Serializer implements class_1865<ArmorColoringRecipe> {
        private final MapCodec<ArmorColoringRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance.group(
                        class_1856.field_46095.fieldOf("dye").forGetter(armorColoringRecipe -> armorColoringRecipe.ingredient),
                        Codec.INT.optionalFieldOf("index", 0).forGetter(recipe -> recipe.index)
                ).apply(instance, ArmorColoringRecipe::new)
        );
        private static final class_9139<class_9129, ArmorColoringRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        @Override
        public MapCodec<ArmorColoringRecipe> method_53736() {
            return CODEC;
        }

        @Override
        public class_9139<class_9129, ArmorColoringRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static ArmorColoringRecipe read(class_9129 buf) {
            class_1856 ingredient = class_1856.field_48355.decode(buf);
            int index = buf.readInt();
            return new ArmorColoringRecipe(ingredient, index);
        }

        private static void write(class_9129 buf, ArmorColoringRecipe recipe) {
            class_1856.field_48355.encode(buf, recipe.ingredient);
            buf.method_53002(recipe.index);
        }
    }
}
