package com.github.suninvr.virtualadditions.recipe;

import com.github.suninvr.virtualadditions.block.entity.DyeContents;
import com.github.suninvr.virtualadditions.registry.VARecipeType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_10302;
import net.minecraft.class_10355;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2480;
import net.minecraft.class_314;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.class_9887;
import net.minecraft.recipe.*;
import java.util.List;
import java.util.Optional;

public class ColoringRecipe implements class_1860<class_9695>, ColoringStationRecipe {
    public final DyeContents cost;
    public final int index;
    protected final Optional<class_1856> ingredient;
    protected final class_1799 result;
    private class_9887 ingredientPlacement;

    public ColoringRecipe(Optional<class_1856> ingredient, class_1799 result, DyeContents cost, int index) {
        this.ingredient = ingredient;
        this.result = result;
        this.cost = cost;
        this.index = index;
    }

    public ColoringRecipe(Optional<class_1856> ingredient, class_1799 result, int r, int g, int b, int y, int k, int w, int index) {
        this.ingredient = ingredient;
        this.result = result;
        this.cost = new DyeContents(r, g, b, y, k, w);
        this.index = index;
    }

    @Override
    public boolean method_8115(class_9695 inventory, class_1937 world) {
        return this.ingredient.map(value -> value.method_8093(inventory.method_59984(0))).orElseGet(() -> inventory.method_59984(0).method_7960());
    }

    @Override
    public class_1799 method_8116(class_9695 inventory, class_7225.class_7874 wrapperLookup) {
        class_1799 stack = inventory.method_59984(1);
        if ((stack.method_7909() instanceof class_1747 blockItem && blockItem.method_7711() instanceof class_2480) || stack.method_7909() instanceof class_5537) {
            return stack.method_56701(this.result.method_7909(), this.result.method_7947());
        }
        return this.result.method_7972();
    }

    public class_1799 craftWithDye(class_9695 inventory, class_5455 registryManager, DyeContents contents) {
        if (contents.canAdd(this.cost.copyAndMultiply(-1)) && !inventory.method_59984(0).method_31574(this.result.method_7909())) {
            return method_8116(inventory, registryManager);
        }
        return class_1799.field_8037;
    }

    public class_1799 getResult() {
        return this.result;
    }

    @Override
    public class_1865<? extends class_1860<class_9695>> method_8119() {
        return VARecipeType.COLORING_SERIALIZER;
    }

    @Override
    public class_3956<? extends class_1860<class_9695>> method_17716() {
        return VARecipeType.COLORING;
    }

    @Override
    public class_9887 method_61671() {
        if (this.ingredientPlacement == null) {
            this.ingredientPlacement = class_9887.method_61683(List.of(this.ingredient));
        }

        return this.ingredientPlacement;
    }

    @Override
    public class_10355 method_64668() {
        return class_314.field_17764;
    }

    public int getIndex() {
        return this.index;
    }

    public DyeContents getDyeCost(boolean inverted) {
        return inverted ? this.cost : this.cost.copyAndMultiply(-1);
    }

    public Optional<class_1856> getIngredient() {
        return ingredient;
    }

    public class_10302.class_10307 getStackSlotDisplay() {
        return new class_10302.class_10307(this.result);
    };

    @Override
    public class_1799 getResultStack(class_5455 registryManager, class_1799 input) {
        return this.getResult();
    }

    @Override
    public class_1799 getResultStack(class_1799 input) {
        return this.getResult();
    }

    public static class Serializer implements class_1865<ColoringRecipe> {
        private final MapCodec<ColoringRecipe> CODEC = RecordCodecBuilder.mapCodec(
                instance -> instance.group(
                        class_1856.field_46095.optionalFieldOf("ingredient").forGetter(recipe -> recipe.ingredient),
                        class_1799.field_24671.fieldOf("result").forGetter(recipe -> recipe.result),
                        Codec.INT.optionalFieldOf("red_cost", 0).forGetter(recipe -> recipe.cost.getR()),
                        Codec.INT.optionalFieldOf("green_cost", 0).forGetter(recipe -> recipe.cost.getG()),
                        Codec.INT.optionalFieldOf("blue_cost", 0).forGetter(recipe -> recipe.cost.getB()),
                        Codec.INT.optionalFieldOf("yellow_cost", 0).forGetter(recipe -> recipe.cost.getY()),
                        Codec.INT.optionalFieldOf("black_cost", 0).forGetter(recipe -> recipe.cost.getK()),
                        Codec.INT.optionalFieldOf("white_cost", 0).forGetter(recipe -> recipe.cost.getW()),
                        Codec.INT.optionalFieldOf("index", 0).forGetter(recipe -> recipe.index)
                ).apply(instance, ColoringRecipe::new)
        );
        private static final class_9139<class_9129, ColoringRecipe> PACKET_CODEC = class_9139.method_56437(Serializer::write, Serializer::read);

        @Override
        public MapCodec<ColoringRecipe> method_53736() {
            return this.CODEC;
        }

        @Override
        public class_9139<class_9129, ColoringRecipe> method_56104() {
            return PACKET_CODEC;
        }

        private static ColoringRecipe read(class_9129 buf) {
            Optional<class_1856> ingredient = class_1856.field_52595.decode(buf);
            class_1799 stack = class_1799.field_48349.decode(buf);
            DyeContents cost = DyeContents.PACKET_CODEC.decode(buf);
            int index = buf.readInt();
            return new ColoringRecipe(ingredient, stack, cost, index);
        }

        private static void write(class_9129 buf, ColoringRecipe recipe) {
            class_1856.field_52595.encode(buf, recipe.ingredient);
            class_1799.field_48349.encode(buf, recipe.result);
            DyeContents.PACKET_CODEC.encode(buf, recipe.cost);
            buf.method_53002(recipe.index);
        }
    }
}
