package com.github.suninvr.virtualadditions.recipe;

import com.github.suninvr.virtualadditions.block.entity.DyeContents;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_3489;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record ColoringRecipeDisplay<T extends ColoringStationRecipe>(class_10302 optionDisplay, Optional<class_8786<T>> recipeEntry) {

    public static <T extends ColoringStationRecipe> class_9139<class_9129, ColoringRecipeDisplay<T>> codec() {
        return class_9139.method_56434(class_10302.field_54672, ColoringRecipeDisplay::optionDisplay, display -> new ColoringRecipeDisplay<>(display, Optional.empty()));
    }

    public Optional<class_8786<T>> recipe() {return this.recipeEntry;}

    public record Grouping<T extends ColoringStationRecipe>(List<ColoringRecipeDisplay.GroupEntry<T>> entries) {
        public static <T extends ColoringStationRecipe> ColoringRecipeDisplay.Grouping<T> empty() {
            return new ColoringRecipeDisplay.Grouping<T>(List.of());
        }

        public static <T extends ColoringStationRecipe> class_9139<class_9129, ColoringRecipeDisplay.Grouping<T>> codec() {
            return class_9139.method_56434(GroupEntry.<T>codec().method_56433(class_9135.method_56363()), Grouping::entries, Grouping::new);
        }

        public boolean contains(class_1799 stack) {
            return this.entries.stream().anyMatch(entry -> entry.input.map(ingredient -> ingredient.method_8093(stack)).orElseGet(stack::method_7960));
        }

        public ColoringRecipeDisplay.Grouping<T> filter(class_1799 stack) {
            Grouping<T> grouping = new ColoringRecipeDisplay.Grouping<>(this.entries.stream().filter(tGroupEntry -> tGroupEntry.input.map(ingredient -> ingredient.method_8093(stack)).orElseGet(stack::method_7960)).toList());
            if (grouping.isEmpty()) grouping = new ColoringRecipeDisplay.Grouping<>(this.entries.stream().filter(tGroupEntry -> tGroupEntry.recipe.recipeEntry.isPresent() && tGroupEntry.recipe.recipeEntry.get().comp_1933() instanceof ArmorColoringRecipe && stack.method_31573(class_3489.field_48803)).toList());
            return grouping;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public int size() {
            return this.entries.size();
        }
    }

    public record GroupEntry<T extends ColoringStationRecipe>(Optional<class_1856> input, ColoringRecipeDisplay<T> recipe) {
        public static <T extends ColoringStationRecipe> class_9139<class_9129, ColoringRecipeDisplay.GroupEntry<T>> codec() {
            return class_9139.method_56435(class_1856.field_52595, ColoringRecipeDisplay.GroupEntry::input, ColoringRecipeDisplay.codec(), ColoringRecipeDisplay.GroupEntry::recipe, ColoringRecipeDisplay.GroupEntry::new);
        }

        public DyeContents getDyeContents() {
            return this.recipe.recipeEntry.isPresent() && this.recipe.recipeEntry.get().comp_1933() instanceof ColoringRecipe coloringRecipe ? coloringRecipe.getDyeCost() : DyeContents.empty();
        }
    }
}
