package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.item.*;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1821;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7696;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9886;
import net.minecraft.item.*;
import java.util.function.Consumer;
import java.util.function.Function;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

@SuppressWarnings({"unused"})
public class RegistryHelper {

    public static class BlockRegistryHelper {

        public static <T extends class_2248> class_2248 register(String id, Function<class_4970.class_2251, class_2248> factory, class_4970.class_2251 settings) {
            class_5321<class_2248> key = class_5321.method_29179(class_7924.field_41254, idOf(id));
            class_2248 block = (class_2248)factory.apply(settings.method_63500(key));
            return (class_2248)class_2378.method_39197(class_7923.field_41175, key, block);
        }

    }

    public static class ItemRegistryHelper {

        public record ToolSet(class_1792 SWORD, class_1792 SHOVEL, class_1792 PICKAXE, class_1792 AXE, class_1792 HOE, class_1792 HALBERD, class_9886 MATERIAL, String NAME){
            public class_1792[] getItems() {
                return new class_1792[]{AXE, HOE, PICKAXE, SHOVEL, SWORD, HALBERD};
            }

            public void forEach(Consumer<class_1792> consumer) {
                consumer.accept(AXE);
                consumer.accept(HOE);
                consumer.accept(PICKAXE);
                consumer.accept(SHOVEL);
                consumer.accept(SWORD);
                consumer.accept(HALBERD);
            }
        }

        public record ItemGroupLocation(class_5321<class_1761> GROUP, class_1792 AFTER){ }
        public static class_1792 prev;

        private static <T extends net.minecraft.class_1792> net.minecraft.class_1792 register(String id, T item) { // Register a given item
            net.minecraft.class_1792 item1 = class_2378.method_10230(class_7923.field_41178, idOf(id), item);
            prev = item1;
            return item1;
        }

        private static <T extends net.minecraft.class_1792> net.minecraft.class_1792 register(String id, T item, class_5321<class_1761> itemGroup) { // Register an item, add to a group
            net.minecraft.class_1792 item1 = register(id, item);
            ItemGroupEvents.modifyEntriesEvent(itemGroup).register( (content) -> content.method_45421(item1));
            prev = item1;
            return item1;
        }

        private static <T extends net.minecraft.class_1792> net.minecraft.class_1792 register(String id, T item, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter) { // Register an item, add to a specific location in a group
            net.minecraft.class_1792 item1 = register(id, item);
            ItemGroupEvents.modifyEntriesEvent(itemGroup).register( (content) -> content.addAfter(itemAfter, item1));
            prev = item1;
            return item1;
        }

        private static <T extends net.minecraft.class_1792> net.minecraft.class_1792 register(String id, T item, ItemGroupLocation... locations) { // Register an item, add to several locations
            net.minecraft.class_1792 item1 = register(id, item);
            for (ItemGroupLocation location : locations) {
                ItemGroupEvents.modifyEntriesEvent(location.GROUP).register( (content) -> content.addAfter(location.AFTER, item1));
            }
            prev = item1;
            return item1;
        }

        public static class_1792 register(String id, class_1792.class_1793 settings, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter) {
            settings = settings.method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new class_1792(settings), itemGroup, itemAfter);
        }

        public static class_1792 register(String id, class_1792.class_1793 settings, ItemGroupLocation... locations) {
            settings = settings.method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new class_1792(settings), locations);
        }

        public static class_1792 register(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings) {
            settings = settings.method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, factory.apply(settings));
        }

        public static class_1792 register(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter) {
            settings = settings.method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, factory.apply(settings), itemGroup, itemAfter);
        }

        public static class_1792 register(String id, Function<class_1792.class_1793, class_1792> factory, class_1792.class_1793 settings, ItemGroupLocation... itemGroupLocations) {
            settings = settings.method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, factory.apply(settings), itemGroupLocations);
        }

        public static ItemGroupLocation at(class_5321<class_1761> group, class_1792 after) {
            return new ItemGroupLocation(group, after);
        };


        /**
         * Registers an item without applying settings
         *
         * @param id The in-game ID. This will be "modid:id"
         * **/
        public static net.minecraft.class_1792 register(String id) { // Create and register an item
            class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new net.minecraft.class_1792(settings));
        }

        /**
         * Registers an item without applying settings
         *
         * @param id The in-game ID. This will be "modid:id"
         * @param itemGroup The group to place the item into
         * **/
        public static net.minecraft.class_1792 register(String id, class_5321<class_1761> itemGroup) { // Create and register an item, give a group
            class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new net.minecraft.class_1792(settings), itemGroup);
        }

        /**
         * Registers an item without applying settings
         *
         * @param id The in-game ID. This will be "modid:id"
         * @param itemGroup The group to place the item into
         * @param itemAfter The item to place the registered item after
         * **/
        public static net.minecraft.class_1792 register(String id, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter) { // Create and register an item, give a location in a group
            class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new net.minecraft.class_1792(settings), itemGroup, itemAfter);
        }

        /**
         * Registers an item without applying settings
         *
         * @param id The in-game ID. This will be "modid:id"
         * @param itemGroup The group to place the item into
         * @param itemAfter The item to place the registered item after
         * @param features What feature flags need to be enabled in-game for this item to appear
         * **/
        public static net.minecraft.class_1792 register(String id, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter, class_7696... features) { // Create and register an item, give a location in a group
            class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id))).method_45434(features);
            return register(id, new net.minecraft.class_1792(settings), itemGroup, itemAfter);
        }


        /**
         * Registers an item without applying settings
         *
         * @param id The in-game ID. This will be "modid:id"
         * @param locations A location to place the item into
         * @see ItemGroupLocation
         * **/
        public static net.minecraft.class_1792 register(String id, ItemGroupLocation... locations) { // Create and register an item, give several locations
            class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)));
            return register(id, new net.minecraft.class_1792(settings), locations);
        }

        /**
         * Registers an item for a block. No settings are applied
         *
         * @param id The in-game ID. This will be "modid:id"
         * @param block The block to create an item for.
         * **/
        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block) { // Create and register a block item
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)))));
        }

        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block, class_5321<class_1761> itemGroup) { // Create and register a block item, give a group
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)))), itemGroup);
        }

        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter) { // Create and register a block item, give a location in a group
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)))), itemGroup, itemAfter);
        }

        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block, ItemGroupLocation... locations) { // Create and register a block item, give several locations
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id)))), locations);
        }

        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block, class_5321<class_1761> itemGroup, net.minecraft.class_1792 itemAfter, class_7696... features) { // Create and register a block item, give a location in a group, assign required feature flags
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id))).method_45434(features)), itemGroup, itemAfter);
        }

        public static net.minecraft.class_1792 registerBlockItem(String id, class_2248 block, ItemGroupLocation[] locations, class_7696... features) { // Create and register a block item, give several locations, assign required feature flags
            return register(id, new class_1747(block, new class_1792.class_1793().method_63684(block.method_63499()).method_63686(class_5321.method_29179(class_7924.field_41197, idOf(id))).method_45434(features)), locations);
        }

        public static ToolSet registerGildedToolSet(ToolSet baseSet, GildType type) {
            String newName = type.getId().method_12832() +"_"+ baseSet.NAME;
            return new ToolSet(
                    register(newName +"_sword", settings -> new GildedSwordItem(type, baseSet.MATERIAL, baseSet.SWORD, settings), new class_1792.class_1793()),
                    register(newName +"_shovel", settings -> new GildedShovelItem(type, baseSet.MATERIAL, (class_1821) baseSet.SHOVEL, settings), new class_1792.class_1793()),
                    register(newName +"_pickaxe", settings -> new GildedPickaxeItem(type, baseSet.MATERIAL, baseSet.PICKAXE, settings), new class_1792.class_1793()),
                    register(newName +"_axe", settings -> new GildedAxeItem(type, baseSet.MATERIAL, (class_1743) baseSet.AXE, settings), new class_1792.class_1793()),
                    register(newName +"_hoe", settings -> new GildedHoeItem(type, baseSet.MATERIAL, (class_1794) baseSet.HOE, settings), new class_1792.class_1793()),
                    register(newName +"_halberd", settings -> new GildedHalberdItem(type, baseSet.MATERIAL, baseSet.HALBERD, settings), new class_1792.class_1793()),
                    type.getModifiedMaterial(baseSet.MATERIAL).asToolMaterial(),
                    newName
            );
        }

        public static ToolSet registerGildedToolSet(ToolSet baseSet, GildType type, class_1792.class_1793 baseSettings) {
            String newName = type.getId().method_12832() +"_"+ baseSet.NAME;
            return new ToolSet(
                    register(newName +"_sword", settings -> new GildedSwordItem(type, baseSet.MATERIAL, baseSet.SWORD, settings), baseSettings),
                    register(newName +"_shovel", settings -> new GildedShovelItem(type, baseSet.MATERIAL, (class_1821) baseSet.SHOVEL, settings), baseSettings),
                    register(newName +"_pickaxe", settings -> new GildedPickaxeItem(type, baseSet.MATERIAL, baseSet.PICKAXE, settings), baseSettings),
                    register(newName +"_axe", settings -> new GildedAxeItem(type, baseSet.MATERIAL, (class_1743) baseSet.AXE, settings), baseSettings),
                    register(newName +"_hoe", settings -> new GildedHoeItem(type, baseSet.MATERIAL, (class_1794) baseSet.HOE, settings), baseSettings),
                    register(newName +"_halberd", settings -> new GildedHalberdItem(type, baseSet.MATERIAL, baseSet.HALBERD, settings), baseSettings),
                    type.getModifiedMaterial(baseSet.MATERIAL).asToolMaterial(),
                    newName
            );
        }
    }
}
