package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.registry.collection.ColorfulBlockSet;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableBiMap;
import java.util.function.Supplier;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_5793;
import net.minecraft.class_5794;

import static com.github.suninvr.virtualadditions.registry.VABlocks.*;
import static net.minecraft.class_2246.*;

public class VACollections {

    public static final class_5794 CUT_STEEL;
    public static final class_5794 EXPOSED_CUT_STEEL;
    public static final class_5794 WEATHERED_CUT_STEEL;
    public static final class_5794 OXIDIZED_CUT_STEEL;
    public static final class_5794 WAXED_CUT_STEEL;
    public static final class_5794 WAXED_EXPOSED_CUT_STEEL;
    public static final class_5794 WAXED_WEATHERED_CUT_STEEL;
    public static final class_5794 WAXED_OXIDIZED_CUT_STEEL;
    public static final class_5794 COBBLED_HORNFELS;
    public static final class_5794 POLISHED_HORNFELS;
    public static final class_5794 HORNFELS_TILES;
    public static final class_5794 COBBLED_BLUESCHIST;
    public static final class_5794 POLISHED_BLUESCHIST;
    public static final class_5794 BLUESCHIST_BRICKS;
    public static final class_5794 COBBLED_SYENITE;
    public static final class_5794 POLISHED_SYENITE;
    public static final class_5794 SYENITE_BRICKS;
    public static final class_5794 ROCK_SALT_BRICKS;
    public static final class_5794 SOULBLOOM;
    public static final class_5794 WITHERED;
    public static final class_5794 PORPHYRY;
    public static final class_5794 PORPHYRY_BRICKS;
    public static final class_5794 POLISHED_PORPHYRY;

    public static final ColorfulBlockSet WHITE;
    public static final ColorfulBlockSet LIGHT_GRAY;
    public static final ColorfulBlockSet GRAY;
    public static final ColorfulBlockSet BLACK;
    public static final ColorfulBlockSet TAN;
    public static final ColorfulBlockSet BROWN;
    public static final ColorfulBlockSet LILAC;
    public static final ColorfulBlockSet MAROON;
    public static final ColorfulBlockSet RED;
    public static final ColorfulBlockSet SINOPIA;
    public static final ColorfulBlockSet ORANGE;
    public static final ColorfulBlockSet YELLOW;
    public static final ColorfulBlockSet CHARTREUSE;
    public static final ColorfulBlockSet LIME;
    public static final ColorfulBlockSet GREEN;
    public static final ColorfulBlockSet VIRIDIAN;
    public static final ColorfulBlockSet CYAN;
    public static final ColorfulBlockSet LIGHT_BLUE;
    public static final ColorfulBlockSet BLUE;
    public static final ColorfulBlockSet INDIGO;
    public static final ColorfulBlockSet PURPLE;
    public static final ColorfulBlockSet PLUM;
    public static final ColorfulBlockSet MAGENTA;
    public static final ColorfulBlockSet PINK;

    public static final Supplier<ImmutableBiMap<class_2248, class_2248>> CLIMBING_ROPE_OXIDIZATION_INCREASES;
    public static final Supplier<ImmutableBiMap<class_2248, class_2248>> CLIMBING_ROPE_OXIDIZATION_DECREASES;
    public static final Supplier<ImmutableBiMap<class_2248, class_2248>> UNWAXED_TO_WAXED_CLIMBING_ROPES;
    public static final Supplier<ImmutableBiMap<class_2248, class_2248>> WAXED_TO_UNWAXED_CLIMBING_ROPES;

    static {
        CUT_STEEL = register(VABlocks.CUT_STEEL).method_33493(VABlocks.CUT_STEEL_STAIRS).method_33492(VABlocks.CUT_STEEL_SLAB).method_45966(VABlocks.STEEL_FENCE).method_33486(CHISELED_STEEL).method_33481();
        EXPOSED_CUT_STEEL = register(VABlocks.EXPOSED_CUT_STEEL).method_33493(VABlocks.EXPOSED_CUT_STEEL_STAIRS).method_33492(VABlocks.EXPOSED_CUT_STEEL_SLAB).method_33486(EXPOSED_CHISELED_STEEL).method_45966(VABlocks.EXPOSED_STEEL_FENCE).method_33481();
        WEATHERED_CUT_STEEL = register(VABlocks.WEATHERED_CUT_STEEL).method_33493(VABlocks.WEATHERED_CUT_STEEL_STAIRS).method_33492(VABlocks.WEATHERED_CUT_STEEL_SLAB).method_33486(WEATHERED_CHISELED_STEEL).method_45966(VABlocks.WEATHERED_STEEL_FENCE).method_33481();
        OXIDIZED_CUT_STEEL = register(VABlocks.OXIDIZED_CUT_STEEL).method_33493(VABlocks.OXIDIZED_CUT_STEEL_STAIRS).method_33492(VABlocks.OXIDIZED_CUT_STEEL_SLAB).method_33486(OXIDIZED_CHISELED_STEEL).method_45966(VABlocks.OXIDIZED_STEEL_FENCE).method_33481();
        WAXED_CUT_STEEL = register(VABlocks.WAXED_CUT_STEEL).method_33493(VABlocks.WAXED_CUT_STEEL_STAIRS).method_33492(VABlocks.WAXED_CUT_STEEL_SLAB).method_33486(WAXED_CHISELED_STEEL).method_45966(VABlocks.WAXED_STEEL_FENCE).method_33481();
        WAXED_EXPOSED_CUT_STEEL = register(VABlocks.WAXED_EXPOSED_CUT_STEEL).method_33493(VABlocks.WAXED_EXPOSED_CUT_STEEL_STAIRS).method_33492(VABlocks.WAXED_EXPOSED_CUT_STEEL_SLAB).method_33486(WAXED_EXPOSED_CHISELED_STEEL).method_45966(VABlocks.WAXED_EXPOSED_STEEL_FENCE).method_33481();
        WAXED_WEATHERED_CUT_STEEL = register(VABlocks.WAXED_WEATHERED_CUT_STEEL).method_33493(VABlocks.WAXED_WEATHERED_CUT_STEEL_STAIRS).method_33492(VABlocks.WAXED_WEATHERED_CUT_STEEL_SLAB).method_33486(WAXED_WEATHERED_CHISELED_STEEL).method_45966(VABlocks.WAXED_WEATHERED_STEEL_FENCE).method_33481();
        WAXED_OXIDIZED_CUT_STEEL = register(VABlocks.WAXED_OXIDIZED_CUT_STEEL).method_33493(VABlocks.WAXED_OXIDIZED_CUT_STEEL_STAIRS).method_33492(VABlocks.WAXED_OXIDIZED_CUT_STEEL_SLAB).method_33486(WAXED_OXIDIZED_CHISELED_STEEL).method_45966(VABlocks.WAXED_OXIDIZED_STEEL_FENCE).method_33481();
        COBBLED_HORNFELS = register(VABlocks.COBBLED_HORNFELS).method_33493(VABlocks.COBBLED_HORNFELS_STAIRS).method_33492(VABlocks.COBBLED_HORNFELS_SLAB).method_33497(VABlocks.COBBLED_HORNFELS_WALL).method_33481();
        POLISHED_HORNFELS = register(VABlocks.POLISHED_HORNFELS).method_33493(VABlocks.POLISHED_HORNFELS_STAIRS).method_33492(VABlocks.POLISHED_HORNFELS_SLAB).method_33486(CHISELED_HORNFELS).method_33481();
        HORNFELS_TILES = register(VABlocks.HORNFELS_TILES).method_33493(VABlocks.HORNFELS_TILE_STAIRS).method_33492(VABlocks.HORNFELS_TILE_SLAB).method_34593(VABlocks.CRACKED_HORNFELS_TILES).method_33486(CHISELED_HORNFELS_TILES).method_33481();
        COBBLED_BLUESCHIST = register(VABlocks.COBBLED_BLUESCHIST).method_33493(VABlocks.COBBLED_BLUESCHIST_STAIRS).method_33492(VABlocks.COBBLED_BLUESCHIST_SLAB).method_33497(VABlocks.COBBLED_BLUESCHIST_WALL).method_33481();
        POLISHED_BLUESCHIST = register(VABlocks.POLISHED_BLUESCHIST).method_33493(VABlocks.POLISHED_BLUESCHIST_STAIRS).method_33492(VABlocks.POLISHED_BLUESCHIST_SLAB).method_33497(POLISHED_BLUESCHIST_WALL).method_33481();
        BLUESCHIST_BRICKS = register(VABlocks.BLUESCHIST_BRICKS).method_33493(VABlocks.BLUESCHIST_BRICK_STAIRS).method_33492(VABlocks.BLUESCHIST_BRICK_SLAB).method_33497(VABlocks.BLUESCHIST_BRICK_WALL).method_34593(VABlocks.CRACKED_BLUESCHIST_BRICKS).method_33486(VABlocks.CHISELED_BLUESCHIST).method_33481();
        COBBLED_SYENITE = register(VABlocks.COBBLED_SYENITE).method_33493(VABlocks.COBBLED_SYENITE_STAIRS).method_33492(VABlocks.COBBLED_SYENITE_SLAB).method_33497(VABlocks.COBBLED_SYENITE_WALL).method_33481();
        POLISHED_SYENITE = register(VABlocks.POLISHED_SYENITE).method_33493(VABlocks.POLISHED_SYENITE_STAIRS).method_33492(VABlocks.POLISHED_SYENITE_SLAB).method_33497(POLISHED_SYENITE_WALL).method_33481();
        SYENITE_BRICKS = register(VABlocks.SYENITE_BRICKS).method_33493(VABlocks.SYENITE_BRICK_STAIRS).method_33492(VABlocks.SYENITE_BRICK_SLAB).method_33497(VABlocks.SYENITE_BRICK_WALL).method_34593(VABlocks.CRACKED_SYENITE_BRICKS).method_33486(VABlocks.CHISELED_SYENITE).method_33481();
        ROCK_SALT_BRICKS = register(VABlocks.ROCK_SALT_BRICKS).method_33493(ROCK_SALT_BRICK_STAIRS).method_33492(ROCK_SALT_BRICK_SLAB).method_33497(ROCK_SALT_BRICK_WALL).method_33481();
        SOULBLOOM = register(VABlocks.SOULBLOOM_PLANKS).method_33482(VABlocks.SOULBLOOM_BUTTON).method_33490(VABlocks.SOULBLOOM_FENCE).method_33491(VABlocks.SOULBLOOM_FENCE_GATE).method_33483(VABlocks.SOULBLOOM_SIGN, VABlocks.SOULBLOOM_WALL_SIGN).method_33494(VABlocks.SOULBLOOM_PRESSURE_PLATE).method_33492(VABlocks.SOULBLOOM_SLAB).method_33493(VABlocks.SOULBLOOM_STAIRS).method_33489(VABlocks.SOULBLOOM_DOOR).method_33496(VABlocks.SOULBLOOM_TRAPDOOR).method_33484("wooden").method_33487("has_planks").method_33481();
        WITHERED = register(VABlocks.WITHERED_PLANKS).method_33482(VABlocks.WITHERED_BUTTON).method_33490(VABlocks.WITHERED_FENCE).method_33491(VABlocks.WITHERED_FENCE_GATE).method_33483(VABlocks.WITHERED_SIGN, VABlocks.WITHERED_WALL_SIGN).method_33494(VABlocks.WITHERED_PRESSURE_PLATE).method_33492(VABlocks.WITHERED_SLAB).method_33493(VABlocks.WITHERED_STAIRS).method_33489(VABlocks.WITHERED_DOOR).method_33496(VABlocks.WITHERED_TRAPDOOR).method_33484("wooden").method_33487("has_planks").method_33481();
        PORPHYRY = register(VABlocks.PORPHYRY).method_33493(VABlocks.PORPHYRY_STAIRS).method_33492(VABlocks.PORPHYRY_SLAB).method_33497(VABlocks.PORPHYRY_WALL).method_33481();
        PORPHYRY_BRICKS = register(VABlocks.PORPHYRY_BRICKS).method_33493(VABlocks.PORPHYRY_BRICK_STAIRS).method_33492(VABlocks.PORPHYRY_BRICK_SLAB).method_33497(VABlocks.PORPHYRY_BRICK_WALL).method_33481();
        POLISHED_PORPHYRY = register(VABlocks.POLISHED_PORPHYRY).method_33493(VABlocks.POLISHED_PORPHYRY_STAIRS).method_33492(VABlocks.POLISHED_PORPHYRY_SLAB).method_33497(VABlocks.POLISHED_PORPHYRY_WALL).method_33481();
        
        WHITE = ColorfulBlockSet.Builder.create(class_1802.field_8446).wool(field_10446).carpet(field_10466).terracotta(field_10611).concrete(field_10107).concretePowder(field_10197).stainedGlass(field_10087).stainedGlassPane(field_9991).candle(field_27100).candleCake(field_27143).silkbulb(WHITE_SILKBULB).bed(field_10120).shulkerBox(field_10199).banner(field_10154).wallBanner(field_10202).glazedTerracotta(field_10595).build();
        LIGHT_GRAY = ColorfulBlockSet.Builder.create(class_1802.field_8851).wool(field_10222).carpet(field_10209).terracotta(field_10590).concrete(field_10172).concretePowder(field_10628).stainedGlass(field_9996).stainedGlassPane(field_10129).candle(field_27108).candleCake(field_27151).silkbulb(LIGHT_GRAY_SILKBULB).bed(field_10326).shulkerBox(field_10320).banner(field_9985).wallBanner(field_10604).glazedTerracotta(field_10052).build();
        GRAY = ColorfulBlockSet.Builder.create(class_1802.field_8298).wool(field_10423).carpet(field_10591).terracotta(field_10349).concrete(field_10038).concretePowder(field_10353).stainedGlass(field_10555).stainedGlassPane(field_10077).candle(field_27107).candleCake(field_27150).silkbulb(GRAY_SILKBULB).bed(field_10141).shulkerBox(field_10140).banner(field_10185).wallBanner(field_10267).glazedTerracotta(field_10220).build();
        BLACK = ColorfulBlockSet.Builder.create(class_1802.field_8226).wool(field_10146).carpet(field_10106).terracotta(field_10626).concrete(field_10458).concretePowder(field_10506).stainedGlass(field_9997).stainedGlassPane(field_10070).candle(field_27141).candleCake(field_27158).silkbulb(BLACK_SILKBULB).bed(field_10461).shulkerBox(field_10371).banner(field_10062).wallBanner(field_10537).glazedTerracotta(field_10501).build();
        BROWN = ColorfulBlockSet.Builder.create(class_1802.field_8099).wool(field_10113).carpet(field_10473).terracotta(field_10123).concrete(field_10439).concretePowder(field_10023).stainedGlass(field_10073).stainedGlassPane(field_10163).candle(field_27112).candleCake(field_27155).silkbulb(BROWN_SILKBULB).bed(field_10288).shulkerBox(field_10373).banner(field_10602).wallBanner(field_10370).glazedTerracotta(field_10004).build();
        LILAC = ColorfulBlockSet.Builder.create(VAItems.LILAC_DYE).wool(LILAC_WOOL).carpet(LILAC_CARPET).terracotta(LILAC_TERRACOTTA).concrete(LILAC_CONCRETE).concretePowder(LILAC_CONCRETE_POWDER).stainedGlass(LILAC_STAINED_GLASS).stainedGlassPane(LILAC_STAINED_GLASS_PANE).candle(LILAC_CANDLE).candleCake(LILAC_CANDLE_CAKE).silkbulb(LILAC_SILKBULB).bed(LILAC_BED).shulkerBox(LILAC_SHULKER_BOX).banner(LILAC_BANNER).wallBanner(LILAC_WALL_BANNER).glazedTerracotta(LILAC_GLAZED_TERRACOTTA).build();
        MAROON = ColorfulBlockSet.Builder.create(VAItems.MAROON_DYE).wool(MAROON_WOOL).carpet(MAROON_CARPET).terracotta(MAROON_TERRACOTTA).concrete(MAROON_CONCRETE).concretePowder(MAROON_CONCRETE_POWDER).stainedGlass(MAROON_STAINED_GLASS).stainedGlassPane(MAROON_STAINED_GLASS_PANE).candle(MAROON_CANDLE).candleCake(MAROON_CANDLE_CAKE).silkbulb(MAROON_SILKBULB).bed(MAROON_BED).shulkerBox(MAROON_SHULKER_BOX).banner(MAROON_BANNER).wallBanner(MAROON_WALL_BANNER).glazedTerracotta(MAROON_GLAZED_TERRACOTTA).build();
        RED = ColorfulBlockSet.Builder.create(class_1802.field_8264).wool(field_10314).carpet(field_10536).terracotta(field_10328).concrete(field_10058).concretePowder(field_10287).stainedGlass(field_10272).stainedGlassPane(field_10118).candle(field_27140).candleCake(field_27157).silkbulb(RED_SILKBULB).bed(field_10069).shulkerBox(field_10068).banner(field_10406).wallBanner(field_10279).glazedTerracotta(field_10383).build();
        SINOPIA = ColorfulBlockSet.Builder.create(VAItems.SINOPIA_DYE).wool(SINOPIA_WOOL).carpet(SINOPIA_CARPET).terracotta(SINOPIA_TERRACOTTA).concrete(SINOPIA_CONCRETE).concretePowder(SINOPIA_CONCRETE_POWDER).stainedGlass(SINOPIA_STAINED_GLASS).stainedGlassPane(SINOPIA_STAINED_GLASS_PANE).candle(SINOPIA_CANDLE).candleCake(SINOPIA_CANDLE_CAKE).silkbulb(SINOPIA_SILKBULB).bed(SINOPIA_BED).shulkerBox(SINOPIA_SHULKER_BOX).banner(SINOPIA_BANNER).wallBanner(SINOPIA_WALL_BANNER).glazedTerracotta(SINOPIA_GLAZED_TERRACOTTA).build();
        ORANGE = ColorfulBlockSet.Builder.create(class_1802.field_8492).wool(field_10095).carpet(field_9977).terracotta(field_10184).concrete(field_10210).concretePowder(field_10022).stainedGlass(field_10227).stainedGlassPane(field_10496).candle(field_27101).candleCake(field_27144).silkbulb(ORANGE_SILKBULB).bed(field_10410).shulkerBox(field_10407).banner(field_10045).wallBanner(field_10599).glazedTerracotta(field_10280).build();
        TAN = ColorfulBlockSet.Builder.create(VAItems.TAN_DYE).wool(TAN_WOOL).carpet(TAN_CARPET).terracotta(TAN_TERRACOTTA).concrete(TAN_CONCRETE).concretePowder(TAN_CONCRETE_POWDER).stainedGlass(TAN_STAINED_GLASS).stainedGlassPane(TAN_STAINED_GLASS_PANE).candle(TAN_CANDLE).candleCake(TAN_CANDLE_CAKE).silkbulb(TAN_SILKBULB).bed(TAN_BED).shulkerBox(TAN_SHULKER_BOX).banner(TAN_BANNER).wallBanner(TAN_WALL_BANNER).glazedTerracotta(TAN_GLAZED_TERRACOTTA).build();
        YELLOW = ColorfulBlockSet.Builder.create(class_1802.field_8192).wool(field_10490).carpet(field_10512).terracotta(field_10143).concrete(field_10542).concretePowder(field_10145).stainedGlass(field_10049).stainedGlassPane(field_10578).candle(field_27104).candleCake(field_27147).silkbulb(YELLOW_SILKBULB).bed(field_10356).shulkerBox(field_10600).banner(field_10547).wallBanner(field_10139).glazedTerracotta(field_10096).build();
        CHARTREUSE = ColorfulBlockSet.Builder.create(VAItems.CHARTREUSE_DYE).wool(CHARTREUSE_WOOL).carpet(CHARTREUSE_CARPET).terracotta(CHARTREUSE_TERRACOTTA).concrete(CHARTREUSE_CONCRETE).concretePowder(CHARTREUSE_CONCRETE_POWDER).stainedGlass(CHARTREUSE_STAINED_GLASS).stainedGlassPane(CHARTREUSE_STAINED_GLASS_PANE).candle(CHARTREUSE_CANDLE).candleCake(CHARTREUSE_CANDLE_CAKE).silkbulb(CHARTREUSE_SILKBULB).bed(CHARTREUSE_BED).shulkerBox(CHARTREUSE_SHULKER_BOX).banner(CHARTREUSE_BANNER).wallBanner(CHARTREUSE_WALL_BANNER).glazedTerracotta(CHARTREUSE_GLAZED_TERRACOTTA).build();
        LIME = ColorfulBlockSet.Builder.create(class_1802.field_8131).wool(field_10028).carpet(field_10040).terracotta(field_10014).concrete(field_10421).concretePowder(field_10133).stainedGlass(field_10157).stainedGlassPane(field_10305).candle(field_27105).candleCake(field_27148).silkbulb(LIME_SILKBULB).bed(field_10180).shulkerBox(field_10275).banner(field_10229).wallBanner(field_10318).glazedTerracotta(field_10046).build();
        GREEN = ColorfulBlockSet.Builder.create(class_1802.field_8408).wool(field_10170).carpet(field_10338).terracotta(field_10526).concrete(field_10367).concretePowder(field_10529).stainedGlass(field_10357).stainedGlassPane(field_10419).candle(field_27113).candleCake(field_27156).silkbulb(GREEN_SILKBULB).bed(field_10561).shulkerBox(field_10055).banner(field_10198).wallBanner(field_10594).glazedTerracotta(field_10475).build();
        VIRIDIAN = ColorfulBlockSet.Builder.create(VAItems.VIRIDIAN_DYE).wool(VIRIDIAN_WOOL).carpet(VIRIDIAN_CARPET).terracotta(VIRIDIAN_TERRACOTTA).concrete(VIRIDIAN_CONCRETE).concretePowder(VIRIDIAN_CONCRETE_POWDER).stainedGlass(VIRIDIAN_STAINED_GLASS).stainedGlassPane(VIRIDIAN_STAINED_GLASS_PANE).candle(VIRIDIAN_CANDLE).candleCake(VIRIDIAN_CANDLE_CAKE).silkbulb(VIRIDIAN_SILKBULB).bed(VIRIDIAN_BED).shulkerBox(VIRIDIAN_SHULKER_BOX).banner(VIRIDIAN_BANNER).wallBanner(VIRIDIAN_WALL_BANNER).glazedTerracotta(VIRIDIAN_GLAZED_TERRACOTTA).build();
        CYAN = ColorfulBlockSet.Builder.create(class_1802.field_8632).wool(field_10619).carpet(field_10433).terracotta(field_10235).concrete(field_10308).concretePowder(field_10233).stainedGlass(field_10248).stainedGlassPane(field_10355).candle(field_27109).candleCake(field_27152).silkbulb(CYAN_SILKBULB).bed(field_10109).shulkerBox(field_10532).banner(field_10165).wallBanner(field_10372).glazedTerracotta(field_10078).build();
        LIGHT_BLUE = ColorfulBlockSet.Builder.create(class_1802.field_8273).wool(field_10294).carpet(field_10290).terracotta(field_10325).concrete(field_10242).concretePowder(field_10321).stainedGlass(field_10271).stainedGlassPane(field_10193).candle(field_27103).candleCake(field_27146).silkbulb(LIGHT_BLUE_SILKBULB).bed(field_10621).shulkerBox(field_10203).banner(field_10452).wallBanner(field_10050).glazedTerracotta(field_10345).build();
        BLUE = ColorfulBlockSet.Builder.create(class_1802.field_8345).wool(field_10514).carpet(field_10043).terracotta(field_10409).concrete(field_10011).concretePowder(field_10456).stainedGlass(field_10060).stainedGlassPane(field_9982).candle(field_27111).candleCake(field_27154).silkbulb(BLUE_SILKBULB).bed(field_10527).shulkerBox(field_10605).banner(field_10281).wallBanner(field_10067).glazedTerracotta(field_10550).build();
        INDIGO = ColorfulBlockSet.Builder.create(VAItems.INDIGO_DYE).wool(INDIGO_WOOL).carpet(INDIGO_CARPET).terracotta(INDIGO_TERRACOTTA).concrete(INDIGO_CONCRETE).concretePowder(INDIGO_CONCRETE_POWDER).stainedGlass(INDIGO_STAINED_GLASS).stainedGlassPane(INDIGO_STAINED_GLASS_PANE).candle(INDIGO_CANDLE).candleCake(INDIGO_CANDLE_CAKE).silkbulb(INDIGO_SILKBULB).bed(INDIGO_BED).shulkerBox(INDIGO_SHULKER_BOX).banner(INDIGO_BANNER).wallBanner(INDIGO_WALL_BANNER).glazedTerracotta(INDIGO_GLAZED_TERRACOTTA).build();
        PURPLE = ColorfulBlockSet.Builder.create(class_1802.field_8296).wool(field_10259).carpet(field_10510).terracotta(field_10570).concrete(field_10206).concretePowder(field_10404).stainedGlass(field_10399).stainedGlassPane(field_10152).candle(field_27110).candleCake(field_27153).silkbulb(PURPLE_SILKBULB).bed(field_10019).shulkerBox(field_10268).banner(field_10368).wallBanner(field_10054).glazedTerracotta(field_10426).build();
        PLUM = ColorfulBlockSet.Builder.create(VAItems.PLUM_DYE).wool(PLUM_WOOL).carpet(PLUM_CARPET).terracotta(PLUM_TERRACOTTA).concrete(PLUM_CONCRETE).concretePowder(PLUM_CONCRETE_POWDER).stainedGlass(PLUM_STAINED_GLASS).stainedGlassPane(PLUM_STAINED_GLASS_PANE).candle(PLUM_CANDLE).candleCake(PLUM_CANDLE_CAKE).silkbulb(PLUM_SILKBULB).bed(PLUM_BED).shulkerBox(PLUM_SHULKER_BOX).banner(PLUM_BANNER).wallBanner(PLUM_WALL_BANNER).glazedTerracotta(PLUM_GLAZED_TERRACOTTA).build();
        MAGENTA = ColorfulBlockSet.Builder.create(class_1802.field_8669).wool(field_10215).carpet(field_10482).terracotta(field_10015).concrete(field_10585).concretePowder(field_10300).stainedGlass(field_10574).stainedGlassPane(field_10469).candle(field_27102).candleCake(field_27145).silkbulb(MAGENTA_SILKBULB).bed(field_10230).shulkerBox(field_10063).banner(field_10438).wallBanner(field_10274).glazedTerracotta(field_10538).build();
        PINK = ColorfulBlockSet.Builder.create(class_1802.field_8330).wool(field_10459).carpet(field_10393).terracotta(field_10444).concrete(field_10434).concretePowder(field_10522).stainedGlass(field_10317).stainedGlassPane(field_10565).candle(field_27106).candleCake(field_27149).silkbulb(PINK_SILKBULB).bed(field_10610).shulkerBox(field_10051).banner(field_10612).wallBanner(field_10531).glazedTerracotta(field_10567).build();

        ImmutableBiMap.Builder oxidizationBuilder = ImmutableBiMap.builder().put(VABlocks.CLIMBING_ROPE_ANCHOR, VABlocks.EXPOSED_CLIMBING_ROPE_ANCHOR).put(VABlocks.EXPOSED_CLIMBING_ROPE_ANCHOR, VABlocks.WEATHERED_CLIMBING_ROPE_ANCHOR).put(VABlocks.WEATHERED_CLIMBING_ROPE_ANCHOR, VABlocks.OXIDIZED_CLIMBING_ROPE_ANCHOR);
        CLIMBING_ROPE_OXIDIZATION_INCREASES = Suppliers.memoize( () -> oxidizationBuilder.build());
        CLIMBING_ROPE_OXIDIZATION_DECREASES = Suppliers.memoize( () -> CLIMBING_ROPE_OXIDIZATION_INCREASES.get().inverse() );
        ImmutableBiMap.Builder waxedBuilder = ImmutableBiMap.builder().put(VABlocks.CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_CLIMBING_ROPE_ANCHOR).put(VABlocks.EXPOSED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_EXPOSED_CLIMBING_ROPE_ANCHOR).put(VABlocks.WEATHERED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_WEATHERED_CLIMBING_ROPE_ANCHOR).put(VABlocks.OXIDIZED_CLIMBING_ROPE_ANCHOR, VABlocks.WAXED_OXIDIZED_CLIMBING_ROPE_ANCHOR);
        UNWAXED_TO_WAXED_CLIMBING_ROPES = Suppliers.memoize( () -> waxedBuilder.build());
        WAXED_TO_UNWAXED_CLIMBING_ROPES = Suppliers.memoize( () -> UNWAXED_TO_WAXED_CLIMBING_ROPES.get().inverse() );
    }

    private static class_5794.class_5795 register(class_2248 baseBlock) {
        return class_5793.method_33468(baseBlock);
    }

    public static void init(){}
}
