package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.component.ExplosiveContentComponent;
import net.fabricmc.fabric.api.loot.v3.LootTableEvents;
import net.minecraft.class_104;
import net.minecraft.class_106;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_149;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1959;
import net.minecraft.class_205;
import net.minecraft.class_207;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_212;
import net.minecraft.class_219;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2756;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_6662;
import net.minecraft.class_6908;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9320;
import net.minecraft.class_94;
import net.minecraft.class_9636;
import net.minecraft.loot.condition.*;
import net.minecraft.loot.function.*;
import net.minecraft.registry.*;

import static com.github.suninvr.virtualadditions.registry.VAItems.*;

public class VALootTableModifiers {

    public static void init() {
        LootTableEvents.MODIFY.register( ((key, tableBuilder, source, registries) -> {

            if (!source.isBuiltin()) return;

            if (class_39.field_850.equals(key)) {
                class_55.class_56 bundleBuilder = class_55.method_347()
                        .method_351(class_77.method_411(class_1802.field_27023))
                        .method_351(class_77.method_411(class_1802.field_54302))
                        .method_351(class_77.method_411(class_1802.field_54310))
                        .method_351(class_77.method_411(class_1802.field_54309))
                        .method_351(class_77.method_411(class_1802.field_54317))
                        .method_351(class_77.method_411(VAItems.TAN_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54314))
                        .method_351(class_77.method_411(VAItems.LILAC_BUNDLE))
                        .method_351(class_77.method_411(VAItems.MAROON_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54316))
                        .method_351(class_77.method_411(VAItems.SINOPIA_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54303))
                        .method_351(class_77.method_411(class_1802.field_54306))
                        .method_351(class_77.method_411(VAItems.CHARTREUSE_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54307))
                        .method_351(class_77.method_411(class_1802.field_54315))
                        .method_351(class_77.method_411(VAItems.VIRIDIAN_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54311))
                        .method_351(class_77.method_411(class_1802.field_54305))
                        .method_351(class_77.method_411(class_1802.field_54313))
                        .method_351(class_77.method_411(VAItems.INDIGO_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54312))
                        .method_351(class_77.method_411(VAItems.PLUM_BUNDLE))
                        .method_351(class_77.method_411(class_1802.field_54304))
                        .method_351(class_77.method_411(class_1802.field_54308));
                tableBuilder.method_336(bundleBuilder);
            }

            // Ominous Trial Spawner Throwables
            if (class_39.field_50200.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(class_1802.field_8150).method_438(class_6662.method_38927(VAPotions.STRONG_FRAILTY)));
                    }
                    if (i[0] == 1) {
                        builder.method_351(class_77.method_411(STEEL_BOMB).method_438(class_9320.method_57650(VADataComponentTypes.EXPLOSIVE_CONTENTS, ExplosiveContentComponent.KEEP_BLOCKS)));
                    }
                    i[0]++;
                });
            }

            if (class_39.field_49845.equals(key)) {
                tableBuilder.modifyPools(builder -> {
                    builder
                            .method_351(class_77.method_411(IRON_HALBERD).method_437(2).method_438(new class_106.class_107(class_5662.method_32462(0, 10)).method_60295(registries.method_46762(class_7924.field_41265).method_46735(class_9636.field_51550))))
                            .method_351(class_77.method_411(DIAMOND_HALBERD).method_438(new class_106.class_107(class_5662.method_32462(5, 15)).method_60295(registries.method_46762(class_7924.field_41265).method_46735(class_9636.field_51550))))
                    ;
                });
            }

            // Grass Drop
            if (lootTableKeyMatches(key, class_2246.field_10479, class_2246.field_10112, class_2246.field_10214, class_2246.field_10313)) {
                boolean largeFern = lootTableKeyMatches(key, class_2246.field_10313);
                boolean tallGrass = lootTableKeyMatches(key, class_2246.field_10214);
                class_7225.class_7226<class_1959> impl = registries.method_46762(class_7924.field_41236);
                class_7871<class_1887> enchantmentLookup = registries.method_46762(class_7924.field_41265);
                class_7871<class_1792> itemRegistryEntryLookup = registries.method_46762(class_7924.field_41197);
                if (largeFern || tallGrass) {
                    class_2248 block = largeFern ? class_2246.field_10313 : class_2246.field_10214;
                    class_55.class_56 lowerFruitCropBuilder = createFruitCropSeedsLoot(impl, enchantmentLookup, itemRegistryEntryLookup)
                            .method_356(class_212.method_900(block).method_22584(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12607)))
                            .method_356(class_205.method_30151(class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12609))), new class_2338(0, 1, 0)));
                    class_55.class_56 upperFruitCropBuilder = createFruitCropSeedsLoot(impl, enchantmentLookup, itemRegistryEntryLookup)
                            .method_356(class_212.method_900(block).method_22584(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12609)))
                            .method_356(class_205.method_30151(class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12607))), new class_2338(0, -1, 0)));
                    class_55.class_56 lowerCottonBuilder = createCottonSeedsLoot(enchantmentLookup, itemRegistryEntryLookup)
                            .method_356(class_212.method_900(block).method_22584(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12607)))
                            .method_356(class_205.method_30151(class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12609))), new class_2338(0, 1, 0)));
                    class_55.class_56 upperCottonBuilder = createCottonSeedsLoot(enchantmentLookup, itemRegistryEntryLookup)
                            .method_356(class_212.method_900(block).method_22584(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12609)))
                            .method_356(class_205.method_30151(class_2090.class_2091.method_22484().method_27989(class_4550.class_4710.method_23880().method_27963(class_4559.class_4560.method_22523().method_22525(class_2320.field_10929, class_2756.field_12607))), new class_2338(0, -1, 0)));

                    tableBuilder.method_336(lowerCottonBuilder).method_336(upperCottonBuilder).method_336(lowerFruitCropBuilder).method_336(upperFruitCropBuilder);
                } else {
                    tableBuilder.method_336(createCottonSeedsLoot(enchantmentLookup, itemRegistryEntryLookup)).method_336(createFruitCropSeedsLoot(impl, enchantmentLookup, itemRegistryEntryLookup));
                }
            }

            // Abandoned Mineshaft Chest
            if (class_39.field_472.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 2) {
                        builder
                                .method_351(class_77.method_411(CLIMBING_ROPE).method_437(7).method_438(class_141.method_621(class_5662.method_32462(2, 16))))
                                .method_351(class_77.method_411(EXPOSED_CLIMBING_ROPE).method_437(7).method_438(class_141.method_621(class_5662.method_32462(2, 16))))
                                .method_351(class_77.method_411(WEATHERED_CLIMBING_ROPE).method_437(7).method_438(class_141.method_621(class_5662.method_32462(2, 16))))
                                .method_351(class_77.method_411(OXIDIZED_CLIMBING_ROPE).method_437(7).method_438(class_141.method_621(class_5662.method_32462(2, 16))));
                    }
                    i[0]++;
                });
            }

            // Toolsmith and Weaponsmith Chests
            if (class_39.field_17107.equals(key) || class_39.field_434.equals(key)) {
                tableBuilder.modifyPools( builder -> builder
                        .method_351(class_77.method_411(STEEL_INGOT).method_437(3).method_438(class_141.method_621(class_5662.method_32462(1, 4))))
                );
                class_55.class_56 smithingTemplateBuilder = class_55.method_347()
                        .method_351(class_77.method_411(TOOL_GILD_SMITHING_TEMPLATE).method_438(class_141.method_621(class_5662.method_32462(2, 3))));
                tableBuilder.method_336(smithingTemplateBuilder);
                class_55.class_56 gildMaterialBuilder = class_55.method_347()
                        .method_351(class_77.method_411(class_1802.field_27022).method_438(class_141.method_621(class_5662.method_32462(2, 4))))
                        .method_351(class_77.method_411(class_1802.field_27063).method_438(class_141.method_621(class_5662.method_32462(2, 4))))
                        .method_351(class_77.method_411(class_1802.field_8687).method_438(class_141.method_621(class_5662.method_32462(2, 4))));
                tableBuilder.method_336(gildMaterialBuilder);

            }

            // Savannah and Desert Village House Chests
            if (class_39.field_16753.equals(key) || class_39.field_16752.equals(key)) {
                tableBuilder.modifyPools( builder -> builder.method_351(class_77.method_411(CORN).method_437(5).method_438(class_141.method_621(class_5662.method_32462(1, 4)))));
            }

            // Plains Village House Chests
            if (class_39.field_16748.equals(key)) {
                tableBuilder.modifyPools( builder -> builder.method_351(class_77.method_411(TOMATO).method_437(5).method_438(class_141.method_621(class_5662.method_32462(1, 4)))));
            }

            // Taiga and Snowy Village House Chests
            if (class_39.field_16749.equals(key) || class_39.field_16754.equals(key)) {
                tableBuilder.modifyPools( builder -> builder.method_351(class_77.method_411(CABBAGE).method_437(5).method_438(class_141.method_621(class_5662.method_32462(1, 2)))));
            }

            // Jungle Temple Loot
            if (class_39.field_803.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(STEEL_INGOT).method_437(5).method_438(class_141.method_621(class_5662.method_32462(2, 5))));
                    }
                    i[0]++;
                });
            }

            // End City Loot
            if (class_39.field_274.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(IOLITE).method_437(5).method_438(class_141.method_621(class_5662.method_32462(1, 4))))
                                .method_351(class_77.method_411(STEEL_INGOT).method_437(10).method_438(class_141.method_621(class_5662.method_32462(3, 6))));
                    }
                    i[0]++;
                });
            }

            // Ancient City Loot
            if (class_39.field_38438.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(EMERALD_DIAMOND_TOOL_SET.HOE())
                                .method_437(2)
                                .method_438(class_141.method_621(class_44.method_32448(1)))
                                .method_438(class_149.method_35542(class_5662.method_32462(0.8F, 1), false))
                        );
                    }
                    i[0]++;
                });
            }

            // Ancient City Ice Box Loot
            if (class_39.field_38439.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(TOMATO)
                                .method_438(class_141.method_621(class_5662.method_32462(2.0F, 12.0F)))
                        );
                    }
                    i[0]++;
                });
            }

            // Shipwreck Supply Loot
            if (class_39.field_880.equals(key)) {
                final int[] i = {0};
                tableBuilder.modifyPools(builder -> {
                    if (i[0] == 0) {
                        builder.method_351(class_77.method_411(ROCK_SALT)
                                .method_437(5)
                                .method_438(class_141.method_621(class_5662.method_32462(7, 24))));
                        builder.method_351(class_77.method_411(CHEESE_WEDGE)
                                .method_437(5)
                                .method_438(class_141.method_621(class_5662.method_32462(3, 12))));
                    }
                    i[0]++;
                });
            }

            // Zombie Loot
            //if (lootTableKeyMatches(key, EntityType.ZOMBIE, EntityType.HUSK)) {
            //
            //}
        } ));
    }

    private static class_55.class_56 createFruitCropSeedsLoot(class_7225.class_7226<class_1959> impl, class_7871<class_1887> enchantmentLookup, class_7871<class_1792> itemRegistryEntryLookup) {
        return class_55.method_347()
                .method_351(class_65.method_386(
                                        class_77.method_411(WISDOM_BERRY_SEEDS)
                                                .method_421(class_205.method_884(class_2090.class_2091.method_22484().method_9024(
                                                        impl.method_46735(VABiomeTags.SPAWNS_ENCHANTED_VARIANT_FARM_ANIMALS)
                                                ))),
                                        class_77.method_411(CORN_SEEDS)
                                                .method_421(class_205.method_884(class_2090.class_2091.method_22484().method_9024(
                                                        impl.method_46735(class_6908.field_55616)
                                                ))),
                                        class_77.method_411(CABBAGE_SEEDS)
                                                .method_421(class_205.method_884(class_2090.class_2091.method_22484().method_9024(
                                                        impl.method_46735(class_6908.field_55615)
                                                ))),
                                        class_77.method_411(TOMATO_SEEDS)
                                )
                                .method_421(class_207.method_889(class_223.method_945(class_2073.class_2074.method_8973().method_8977(itemRegistryEntryLookup, class_1802.field_8868))))
                                .method_421(class_219.method_932(0.125F))
                )
                .method_353(class_94.method_461(enchantmentLookup.method_46747(class_1893.field_9130), 2))
                .method_353(class_104.method_478());
    }

    private static class_55.class_56 createCottonSeedsLoot(class_7871<class_1887> enchantmentLookup, class_7871<class_1792> itemRegistryEntryLookup) {
        return class_55.method_347()
                .method_351(class_77.method_411(COTTON_SEEDS)
                        .method_438(class_94.method_461(enchantmentLookup.method_46747(class_1893.field_9130), 2))
                        .method_438(class_104.method_478())
                        .method_421(class_219.method_932(0.125F))
                        .method_421(class_207.method_889(class_223.method_945(class_2073.class_2074.method_8973().method_8977(itemRegistryEntryLookup, class_1802.field_8868))))
                );
    }

    protected static boolean lootTableKeyMatches(class_5321<class_52> key, class_2248... blocks) {
        for (class_2248 block : blocks) {
            if (block.method_26162().isPresent() && block.method_26162().get().equals(key)) return true;
        }
        return false;
    }

    protected static boolean lootTableKeyMatches(class_5321<class_52> key, class_1299<?>... entities) {
        for (class_1299<?> type : entities) {
            if (type.method_16351().isPresent() && type.method_16351().get().equals(key)) return true;
        }
        return false;
    }
}
