package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.particle.ColorfulPowerParticleEffect;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import java.util.function.Function;

public class VAParticleTypes {
    public static final class_2400 ACID_SPLASH_EMITTER;
    public static final class_2400 ACID_SPLASH;
    public static final class_2400 GREENCAP_SPORE;
    public static final class_2400 SCRAPE_STEEL;
    public static final class_2400 INTERFERENCE;
    public static final class_2400 SPECTRAL_POWER;
    public static final class_2400 SOULBLOOM_LEAVES;
    public static final class_2400 SPECTRAL_FLAME;
    public static final class_2400 SMALL_SPECTRAL_FLAME;
    public static final class_2400 SPRING_LOTUS_POLLEN;
    public static final class_2400 SOUL_FIREFLY;
    public static final class_2400 STATIC_SCULK_CHARGE_POP;
    public static final class_2396<ColorfulPowerParticleEffect> COLORFUL_POWER;

    static{
        ACID_SPLASH_EMITTER = register("acid_splash_emitter");
        ACID_SPLASH = register("acid_splash");
        GREENCAP_SPORE = register("greencap_spore");
        SCRAPE_STEEL = register("scrape_steel", true);
        INTERFERENCE = register("interference");
        SOULBLOOM_LEAVES = register("soulbloom_leaves");
        SPECTRAL_FLAME = register("spectral_flame");
        SMALL_SPECTRAL_FLAME = register("small_spectral_flame");
        SPECTRAL_POWER = register("spectral_power");
        SPRING_LOTUS_POLLEN = register("spring_lotus_pollen");
        SOUL_FIREFLY = register("soul_firefly");
        STATIC_SCULK_CHARGE_POP = register("static_sculk_charge_pop");
        COLORFUL_POWER = register("colorful_power", false, type -> ColorfulPowerParticleEffect.CODEC, type -> ColorfulPowerParticleEffect.PACKET_CODEC);
    }

    public static void init() {}

    private static <T extends class_2394> class_2396<T> register(String name, boolean alwaysShow, Function<class_2396<T>, MapCodec<T>> codecGetter, Function<class_2396<T>, class_9139<? super class_9129, T>> packetCodecGetter) {
        return class_2378.method_10230(class_7923.field_41180, VirtualAdditions.idOf(name), new class_2396<T>(alwaysShow) {
            @Override
            public MapCodec<T> method_29138() {
                return codecGetter.apply(this) ;
            }

            @Override
            public class_9139<? super class_9129, T> method_56179() {
                return packetCodecGetter.apply(this);
            }
        });
    }

    private static class_2400 register(String name, boolean alwaysShow) {
        return class_2378.method_10230(class_7923.field_41180, VirtualAdditions.idOf(name), FabricParticleTypes.simple(alwaysShow));
    }

    private static class_2400 register(String name) {
        return class_2378.method_10230(class_7923.field_41180, VirtualAdditions.idOf(name), FabricParticleTypes.simple(false));
    }
}
