package com.github.suninvr.virtualadditions.registry;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1293;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_2378;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

public class VAPotions {
    public static final class_6880<class_1842> FRAILTY;
    public static final class_6880<class_1842> LONG_FRAILTY;
    public static final class_6880<class_1842> STRONG_FRAILTY;
    public static final class_6880<class_1842> LOVE;
    public static final class_6880<class_1842> LONG_LOVE;
    public static final class_6880<class_1842> SILENCE;
    public static final class_6880<class_1842> LOQUACITY;
    public static final class_6880<class_1842> AURA;
    public static final class_6880<class_1842> LONG_AURA;

    public static void init(){
        initBrewingRecipes();
    }

    static {
        FRAILTY = register("frailty", new class_1842( "virtual_additions.frailty", new class_1293(VAStatusEffects.FRAILTY, 800)));
        LONG_FRAILTY = register("long_frailty", new class_1842("virtual_additions.frailty", new class_1293(VAStatusEffects.FRAILTY, 1800)));
        STRONG_FRAILTY = register("strong_frailty", new class_1842("virtual_additions.frailty", new class_1293(VAStatusEffects.FRAILTY, 400, 2)));
        LOVE = register("love", new class_1842( "virtual_additions.love", new class_1293(VAStatusEffects.LOVE, 1800)));
        LONG_LOVE = register("long_love", new class_1842( "virtual_additions.love", new class_1293(VAStatusEffects.LOVE, 4800)));
        SILENCE = register("silence", new class_1842( "virtual_additions.silence", new class_1293(VAStatusEffects.SILENCE, 1)));
        LOQUACITY = register("loquacity", new class_1842( "virtual_additions.loquacity", new class_1293(VAStatusEffects.LOQUACITY, 1)));
        AURA = register("aura", new class_1842("virtual_additions.aura", new class_1293(VAStatusEffects.AURA, 800)));
        LONG_AURA = register("long_aura", new class_1842("virtual_additions.aura", new class_1293(VAStatusEffects.AURA, 1800)));
    }

    private static class_6880<class_1842> register(String id, class_1842 potion) {
        return class_2378.method_47985(class_7923.field_41179, idOf(id), potion);
    }

    protected static void initBrewingRecipes() {
        FabricBrewingRecipeRegistryBuilder.BUILD.register(builder -> {

            VirtualAdditions.skipBrewingRecipeAssert = true;

            builder.method_59702(VAItems.APPLICABLE_POTION);
            builder.method_59703(class_1802.field_8574, VAItems.LUMWASP_MANDIBLE, VAItems.APPLICABLE_POTION);

            builder.method_59703(class_1802.field_8574, VAItems.WISDOM_BERRY, class_1802.field_8287);

            builder.method_59704(VAItems.ROCK_SALT, FRAILTY);
            builder.method_59705(FRAILTY, class_1802.field_8725, LONG_FRAILTY);
            builder.method_59705(FRAILTY, class_1802.field_8601, STRONG_FRAILTY);

            builder.method_59704(class_1802.field_17527, LOVE);
            builder.method_59705(LOVE, class_1802.field_8725, LONG_LOVE);

            builder.method_59704(class_1802.field_38746, SILENCE);
            builder.method_59705(SILENCE, class_1802.field_8711, LOQUACITY);
            builder.method_59705(LOQUACITY, class_1802.field_8711, SILENCE);

            builder.method_59704(VAItems.SPECTRAL_POWDER, AURA);
            builder.method_59705(AURA, class_1802.field_8725, LONG_AURA);

            VirtualAdditions.skipBrewingRecipeAssert = false;
        });
    }
}
