package com.github.suninvr.virtualadditions.screen;

import com.github.suninvr.virtualadditions.block.entity.ColoringStationBlockEntity;
import com.github.suninvr.virtualadditions.block.entity.DyeContents;
import com.github.suninvr.virtualadditions.interfaces.RecipeManagerInterface;
import com.github.suninvr.virtualadditions.network.ColoringStationS2CPayload;
import com.github.suninvr.virtualadditions.recipe.ColoringRecipeDisplay;
import com.github.suninvr.virtualadditions.recipe.ColoringStationRecipe;
import com.github.suninvr.virtualadditions.registry.VAScreenHandler;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3919;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import net.minecraft.screen.*;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class ColoringStationScreenHandler extends class_1703 {
    private final DyeContents dyeContents;
    private DyeContents dyeContentsAdder;
    private final class_1937 world;
    private final class_1661 playerInventory;
    private ColoringRecipeDisplay.Grouping<ColoringStationRecipe> coloringRecipes = ColoringRecipeDisplay.Grouping.empty();
    private List<ColoringRecipeData> recipeData = new ArrayList<>();
    public static List<ColoringRecipeData> recipeDataOnLoad = new ArrayList<>();
    private List<class_8786<ColoringStationRecipe>> recipeEntries = new ArrayList<>();
    private class_1799 inputStack = class_1799.field_8037;
    private final class_3915 selectedRecipe = class_3915.method_17403();
    private final class_3913 propertyDelegate;
    private final class_3914 context;
    long lastTakeTime = 0;
    final class_1735 dyeSlot;
    final class_1735 inputSlot;
    final class_1735 outputSlot;
    Runnable contentsChangedListener = () -> {};
    public final class_1263 input = new class_1277(2){
        @Override
        public void method_5431() {
            super.method_5431();
            ColoringStationScreenHandler.this.method_7609(this);
            ColoringStationScreenHandler.this.contentsChangedListener.run();
        }
    };
    public final class_9695 recipeInput = new class_9695() {
        @Override
        public class_1799 method_59984(int slot) {
            return ColoringStationScreenHandler.this.input.method_5438(1);
        }

        @Override
        public int method_59983() {
            return 0;
        }

        @Override
        public boolean method_59987() {
            return this.method_59984(0).method_7960();
        }
    };
    final class_1731 output = new class_1731();

    public ColoringStationScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304, new class_3919(6));
    }

    public ColoringStationScreenHandler(int syncId, class_1661 playerInventory, final class_3914 context, class_3913 propertyDelegate) {
        super(VAScreenHandler.COLORING_STATION, syncId);
        this.propertyDelegate = propertyDelegate;
        this.method_17360(propertyDelegate);
        this.dyeContents = new DyeContents(propertyDelegate){
            @Override
            public int getR() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(0);
            }
            @Override
            public int getG() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(1);
            }
            @Override
            public int getB() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(2);
            }
            @Override
            public int getY() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(3);
            }
            @Override
            public int getK() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(4);
            }
            @Override
            public int getW() {
                return ColoringStationScreenHandler.this.propertyDelegate.method_17390(5);
            }

            @Override
            public void setR(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(0, r);
            }

            @Override
            public void setG(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(1, r);
            }

            @Override
            public void setB(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(2, r);
            }

            @Override
            public void setY(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(3, r);
            }

            @Override
            public void setK(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(4, r);
            }

            @Override
            public void setW(int r) {
                ColoringStationScreenHandler.this.propertyDelegate.method_17391(5, r);
            }
        };
        this.dyeContentsAdder = new DyeContents();
        this.world = playerInventory.field_7546.method_73183();
        this.playerInventory = playerInventory;
        this.context = context;

        int i;
        this.dyeSlot = this.method_7621(new class_1735(this.input, 0,10, 15));
        this.inputSlot = this.method_7621(new class_1735(this.input, 1,28, 15));
        this.outputSlot = this.method_7621(new class_1735(this.output, 2,143, 33){
            @Override
            public boolean method_7680(class_1799 stack) {
                return false;
            }

            @Override
            public void method_7667(class_1657 player, class_1799 stack) {
                stack.method_7982(player, stack.method_7947());
                ColoringStationScreenHandler.this.output.method_7664(player, List.of(ColoringStationScreenHandler.this.inputStack));
                ColoringStationScreenHandler.this.inputSlot.method_7671(1);
                ColoringStationScreenHandler.this.addDyeContents();
                ColoringStationScreenHandler.this.updateDyeInput();
                ColoringStationScreenHandler.this.populateResult();
                ColoringStationScreenHandler.this.context.method_17393((world, pos) -> {
                    long l = world.method_8510();
                    if (ColoringStationScreenHandler.this.lastTakeTime != l) {
                        world.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                        ColoringStationScreenHandler.this.lastTakeTime = l;
                    }
                    ColoringStationScreenHandler.this.markBlockEntityDirty();
                });
                super.method_7667(player, stack);
            }

        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(playerInventory, i, 8 + i * 18, 142));
        }
        this.updateInput(class_1799.field_8037);
        if (this.recipeData.isEmpty() && !recipeDataOnLoad.isEmpty()) this.setRecipeData(recipeDataOnLoad);
        this.populateResult();
    }

    private void addDyeContents() {
        this.dyeContents.add(this.dyeContentsAdder);
        ColoringStationScreenHandler.this.markBlockEntityDirty();
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.input));
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.method_17407();
    }

    public ColoringRecipeData getRecipeData(int i) {
      return this.recipeData.get(i);
    }

    public int getAvailableRecipeCount() {
        return this.recipeData.size();
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public boolean canCraft() {
        return this.recipeData != null && !this.recipeData.isEmpty();
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 clickedSlot = this.field_7761.get(slot);
        if (clickedSlot.method_7681()) {
            class_1799 itemStack2 = clickedSlot.method_7677();
            class_1792 item = itemStack2.method_7909();
            itemStack = itemStack2.method_7972();
            if (slot == 2) {
                item.method_54465(itemStack2, player);
                if (!this.method_7616(itemStack2, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                clickedSlot.method_7670(itemStack2, itemStack);
            } else if (slot <= 1 ? !this.method_7616(itemStack2, 3, 39, false)
                            : !(itemStack2.method_7909() instanceof class_1769)
                                ? !this.method_7616(itemStack2, 1, 2, false)
                                : itemStack2.method_7909() instanceof class_1769 ? !this.method_7616(itemStack2, 0, 1, false) : (slot >= 3 && slot < 30
                                    ? !this.method_7616(itemStack2, 30, 39, false)
                                    : slot >= 30 && slot < 39 && !this.method_7616(itemStack2, 3, 30, false))) {
                return class_1799.field_8037;
            }
            if (itemStack2.method_7960()) {
                clickedSlot.method_53512(class_1799.field_8037);
            }
            clickedSlot.method_7668();
            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            clickedSlot.method_7667(player, itemStack2);
            this.method_7623();
        }
        return itemStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public boolean method_7604(class_1657 player, int id) {
        if (this.isInBounds(id)) {
            this.selectedRecipe.method_17404(id);
            this.populateResult();
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.recipeData.size();
    }

    @Override
    public void method_7609(class_1263 inventory) {
        class_1799 itemStack = this.inputSlot.method_7677();
        if (!itemStack.equals(this.inputStack)) {
            if (!(itemStack.method_31574(this.inputStack.method_7909()))) {
                this.updateInput(itemStack);
            }
            this.populateResult();
            this.inputStack = itemStack.method_7972();
        }
        this.updateDyeInput();
    }

    private void updateDyeInput() {
        class_1799 dyeStack = this.dyeSlot.method_7677();
        if (this.dyeSlot.method_7681()) {
            this.dyeContents.addDye(dyeStack);
            this.populateResult();
            ColoringStationScreenHandler.this.markBlockEntityDirty();
        }
    }

    private void updateInput(class_1799 stack) {
        this.selectedRecipe.method_17404(-1);
        this.outputSlot.method_7673(class_1799.field_8037);
        if (!this.world.method_8608()) {
            List<ColoringRecipeData> recipeDataList = new ArrayList<>();
            List<class_8786<ColoringStationRecipe>> recipeEntries = new ArrayList<>();
            this.coloringRecipes = ((RecipeManagerInterface) this.world.method_8433()).virtualAdditions$getColoringRecipes().filter(stack);
            this.coloringRecipes.entries().forEach(entry -> {
                if (entry.recipe().recipeEntry().isPresent()) {
                    class_8786<ColoringStationRecipe> recipe = entry.recipe().recipeEntry().get();
                    class_1799 resultStack;
                    if (!(resultStack = recipe.comp_1933().getResultStack(stack)).method_7960()) {
                        recipeDataList.add(new ColoringRecipeData(recipe.comp_1933().getIndex(), resultStack, recipe.comp_1933().getDyeCost()));
                        recipeEntries.add(recipe);
                    }
                }
            });
            this.setRecipeData(recipeDataList);
            this.setRecipeEntries(recipeEntries);
            ColoringStationS2CPayload payload = new ColoringStationS2CPayload(this.recipeData);
            ServerPlayNetworking.send((class_3222)playerInventory.field_7546, payload);
        }
    }

    public void setRecipeData(List<ColoringRecipeData> data) {
        this.recipeData.clear();
        this.recipeData = new ArrayList<>(data);
        this.recipeData.sort(Comparator.comparingInt(o -> o.index));
    }

    private void setRecipeEntries(List<class_8786<ColoringStationRecipe>> entries) {
        this.recipeEntries.clear();
        this.recipeEntries = new ArrayList<>(entries);
        this.recipeEntries.sort(Comparator.comparingInt(o -> o.comp_1933().getIndex()));
    }

    void populateResult() {
        if (this.world.method_8608()) return;
        Optional<class_8786<ColoringStationRecipe>> optional;
        int i = this.selectedRecipe.method_17407();
        if (!(this.recipeEntries == null) && !this.recipeEntries.isEmpty() && this.isInBounds(i)) {
            optional = Optional.of(this.recipeEntries.get(i));
        } else {
            optional = Optional.empty();
        }

        if (optional.isPresent()) {
            ColoringStationRecipe recipe = optional.get().comp_1933();
            class_1799 itemStack = recipe.craftWithDye(this.recipeInput, this.world.method_30349(), this.dyeContents);
            this.dyeContentsAdder = recipe.getDyeCost();
            if (itemStack.method_45435(this.world.method_45162())) {
                this.output.method_7662(optional.get());
                this.outputSlot.method_7673(itemStack);
            } else {
                this.outputSlot.method_7673(class_1799.field_8037);
            }
        }
    }

    private void markBlockEntityDirty() {
        this.context.method_17393((world1, pos) -> {
            if (world1.method_8321(pos) instanceof ColoringStationBlockEntity blockEntity) blockEntity.method_5431();
        });
    }

    public DyeContents getDyeContents() {
        return this.dyeContents;
    }

    public record ColoringRecipeData(int index, class_1799 stack, DyeContents dyeCost) {
        public static final class_9139<class_9129, ColoringRecipeData> CODEC = class_9139.method_56436(
                class_9135.field_49675, ColoringRecipeData::index,
                class_1799.field_49268, ColoringRecipeData::stack,
                DyeContents.PACKET_CODEC, ColoringRecipeData::dyeCost,
                ColoringRecipeData::new
        );

        public boolean isInputValid(class_1799 stack) {
            return !stack.method_31574(this.stack().method_7909()) || stack.method_31573(class_3489.field_48803);
        }

        public boolean isDyeContentSufficient(DyeContents contents) {
            return contents.canAdd(this.dyeCost());
        }
    }
}
