package com.github.suninvr.virtualadditions.screen;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.block.entity.EntanglementDriveBlockEntity;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.github.suninvr.virtualadditions.registry.VAScreenHandler;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3919;
import net.minecraft.class_4844;
import net.minecraft.class_9701;
import net.minecraft.screen.*;
import java.util.Optional;
import java.util.UUID;

@SuppressWarnings("unused")
public class EntanglementDriveScreenHandler extends class_1703 {

    public static final class_2960 ENTANGLEMENT_DRIVE_ACTIVE_SLOT_SYNC_ID = VirtualAdditions.idOf("entanglement_drive_active_slot_sync");
    public static final class_2960 ENTANGLEMENT_DRIVE_SELECTED_SLOT_SYNC_ID = VirtualAdditions.idOf("entanglement_drive_selected_slot_sync");
    public static final class_2960 EMPTY_IOLITE_SLOT = VirtualAdditions.idOf("container/slot/iolite_dark");
    static final class_2960[] EMPTY_ARMOR_SLOT_TEXTURES;
    private static final class_1304[] EQUIPMENT_SLOT_ORDER;
    private final class_1263 inventory;
    private final class_1661 playerInventory;
    private final class_1735 paymentSlot;
    private int selectedSlotIndex;
    private final class_3914 context;
    private final class_3913 propertyDelegate;
    private final class_3915 isSamePlayer;
    private final UUID playerId;
    private static final UUID nullId = UUID.fromString("0-0-0-0-0");

    public EntanglementDriveScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304, new class_3919(5));
    }
    public EntanglementDriveScreenHandler(int syncid, class_1661 inventory, class_3914 context, class_3913 delegate) {
        super(VAScreenHandler.ENTANGLEMENT_DRIVE, syncid);
        this.context = context;
        this.selectedSlotIndex = -1;
        this.propertyDelegate = delegate;
        this.method_17360(propertyDelegate);
        this.isSamePlayer = class_3915.method_17403();
        this.method_17362(this.isSamePlayer);
        this.playerId = inventory.field_7546.method_5667();
        if (!inventory.field_7546.method_7325()) {
            this.isSamePlayer.method_17404(getActivePlayerId().equals(this.playerId) ? 1 : 0);
        } else {
            this.isSamePlayer.method_17404(0);
        }
        this.playerInventory = inventory;
        this.inventory = new class_1277(1) {
            @Override
            public void method_5431() {
                EntanglementDriveScreenHandler.this.method_7609(this);
                super.method_5431();
            }
            @Override
            public boolean method_5437(int slot, class_1799 stack) {
                return stack.method_31574(VAItems.IOLITE);
            }

            @Override
            public int method_5444() {
                return 1;
            }
        };

        int i;
        int j;

        for(i = 0; i < 9; ++i) {
            this.method_7621(new class_1735(inventory, i, 8 + i * 18, 142));
        } // Hotbar Slots ( 0 - 8 )

        for(i = 0; i < 3; ++i) {
            for(j = 0; j < 9; ++j) {
                this.method_7621(new class_1735(inventory, j + (i + 1) * 9, 8 + j * 18, 84 + i * 18));
            }
        } // Inventory Slots ( 9 - 35 )

        for(i = 0; i < 4; ++i) {
            final class_1304 equipmentSlot = EQUIPMENT_SLOT_ORDER[3 - i];
            this.method_7621(new class_1735(inventory, 36 + i, 8, 62 - i * 18) {

                public int method_7675() {
                    return 1;
                }

                public boolean method_7680(class_1799 stack) {
                    return equipmentSlot == EntanglementDriveScreenHandler.this.playerInventory.field_7546.method_32326(stack);
                }

                public boolean method_7674(class_1657 playerEntity) {
                    class_1799 itemStack = this.method_7677();
                    return (itemStack.method_7960() || playerEntity.method_68878() || !class_1890.method_60142(itemStack, class_9701.field_51656)) && super.method_7674(playerEntity);
                }

                public class_2960 method_7679() {
                    return EMPTY_ARMOR_SLOT_TEXTURES[equipmentSlot.method_5927()];
                }
            });
        } // Equipment slots ( 36 - 39 )

        this.method_7621(new class_1735(inventory, 40, 77, 62) {
            public class_2960 method_7679() {
                return class_1723.field_21673;
            }
        }); // Offhand Slot ( 40 )

        this.paymentSlot = this.method_7621(new class_1735(this.inventory, 0, 91, 30) {
            @Override
            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(VAItems.IOLITE);
            }

            public class_2960 method_7679() {
                return EMPTY_IOLITE_SLOT;
            }
        }); // Payment Slot ( 42 )
    }

    public Optional<EntanglementDriveBlockEntity> getEntity() {
        return this.context.method_17395((world, pos) -> world.method_8321(pos) instanceof EntanglementDriveBlockEntity e ? e : null);
    }

    public class_1735 getActiveSlot() {
        return this.field_7761.get(this.getActiveSlotIndex());
    }

    public class_1735 getSelectedSlot() {
        return this.field_7761.get(this.getSelectedSlotIndex());
    }

    public void setSelectedSlotIndex(int index) {
        this.selectedSlotIndex = index;
    }

    public int getSelectedSlotIndex() {
        return this.selectedSlotIndex;
    }

    public void setActiveSlotIndex(int index) {
        this.propertyDelegate.method_17391(0, index);
    }

    public int getActiveSlotIndex() {
        return this.propertyDelegate.method_17390(0);
    }

    public boolean isSelectingSlot() {
        return this.paymentSlot.method_7677().method_31574(VAItems.IOLITE);
    }

    public boolean isSlotSelected() {
        return this.selectedSlotIndex > -1;
    }

    public boolean isActive() {
        return this.propertyDelegate.method_17390(0) > -1;
    }

    public boolean isSamePlayer() {
        return this.isSamePlayer.method_17407() == 1;
    }

    @Override
    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        int i = class_3532.method_15340(slotIndex, 0, 40);
        if (!this.isSelectingSlot() || !this.method_34255().method_7960() || i != slotIndex) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        if (button != 0) return;
        this.setSelectedSlotIndex(slotIndex);
    }

    @Override
    public class_1799 method_7601(class_1657 player, int slot) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slotFrom = this.method_7611(slot);
        if (slotFrom != null && slotFrom.method_7681()) {
            class_1799 itemStack2 = slotFrom.method_7677();
            itemStack = itemStack2.method_7972();

            if (!this.paymentSlot.method_7681() && this.paymentSlot.method_7680(itemStack2) ) {
                if (this.method_7616(itemStack2, 41, 42, false)) { // To payment
                    return class_1799.field_8037;
                }
            }

            if (slot == 42) { // From Payment
                if (!this.method_7616(itemStack2, 4, 40, true)) { // To Hotbar + Inventory
                    return class_1799.field_8037;
                }

                slotFrom.method_7670(itemStack2, itemStack);
            } else if (slot >= 4 && slot < 31) { // From Inventory
                if (!this.method_7616(itemStack2, 31, 40, false)) { // To Hotbar
                    return class_1799.field_8037;
                }
            } else if (slot >= 32 && slot < 40) { // From Hotbar
                if (!this.method_7616(itemStack2, 4, 31, false)) { // To Inventory
                    return class_1799.field_8037;
                }
            } else if (!this.method_7616(itemStack2, 4, 40, false)) { // To Hotbar + Inventory
                return class_1799.field_8037;
            }

            if (itemStack2.method_7960()) {
                slotFrom.method_7673(class_1799.field_8037);
            } else {
                slotFrom.method_7668();
            }

            if (itemStack2.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }

            slotFrom.method_7667(player, itemStack2);
        }

        return itemStack;
    }

    @Override
    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Override
    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    static {
        EMPTY_ARMOR_SLOT_TEXTURES = new class_2960[]{class_1723.field_21672, class_1723.field_21671, class_1723.field_21670, class_1723.field_21669};
        EQUIPMENT_SLOT_ORDER = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    }

    public UUID getActivePlayerId() {
        return class_4844.method_26276(new int[]{this.propertyDelegate.method_17390(1), this.propertyDelegate.method_17390(2), this.propertyDelegate.method_17390(3), this.propertyDelegate.method_17390(4)});
    }

    public void setActivePlayerId(UUID uuid) {
        this.getEntity().ifPresent(entity -> {
            entity.setPlayerId(uuid);
        });
        int[] idArray = class_4844.method_26275(uuid);
        this.propertyDelegate.method_17391(1, idArray[0]);
        this.propertyDelegate.method_17391(2, idArray[1]);
        this.propertyDelegate.method_17391(3, idArray[2]);
        this.propertyDelegate.method_17391(4, idArray[3]);
        this.isSamePlayer.method_17404( uuid.equals(this.playerId) ? 1 : 0 );
    }

    public void decrementPaymentSlot() {
        this.paymentSlot.method_7677().method_7934(1);
    }
}
