package com.github.suninvr.virtualadditions.worldgen.feature;

import com.github.suninvr.virtualadditions.block.LumwaspNestBlock;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.Codec;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3111;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class LumwaspNestFeature extends class_3031<class_3111> {
    private static final class_2680 SILK_BLOCK = VABlocks.SILK_BLOCK.method_9564();
    private static final class_2680 NEST = VABlocks.LUMWASP_NEST.method_9564();
    private static final class_2680 NEST_LARVAE = VABlocks.LUMWASP_NEST.method_9564().method_11657(LumwaspNestBlock.LARVAE, true);
    private static final class_2680 ACID = VABlocks.ACID.method_9564();
    private static final class_2680 ACID_BLOCK = VABlocks.ACID_BLOCK.method_9564();
    private static final class_2680 GLOWING_SILK = VABlocks.GLOWING_SILK.method_9564();
    private static final class_2680 AIR = class_2246.field_10124.method_9564();

    public LumwaspNestFeature(Codec<class_3111> configCodec) {
        super(configCodec);
    }

    @Override
    public boolean method_13151(class_5821<class_3111> context) {

        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        boolean large = random.method_43048(4) == 1;

        if (!isValidSpace(world, origin, false)) return false;
        boolean canPlaceLarge = large && isValidSpace(world, origin, true);

        if (canPlaceLarge) generateLarge(world, origin, random);
        else generateSmall(world, origin, random);

        return true;
    }

    private void generateSmall(class_5281 world, class_2338 origin, class_5819 random) {
        setBlockStateIfReplaceable(world, origin, SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(1, 0, 0), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-1, 0, 0), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(0, 0, 1), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(0, 0, -1), SILK_BLOCK);

        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -1, j - 1), AIR);
            }
        }

        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                setAcidState(world, origin.method_10069(i - 2, -2, j - 2));
            }
        }

        for (int i = 0; i < 3; ++i) {
            int k = i - 1;
            for (int j = 0; j < 3; ++j) {
                int l = switch (j) {
                    case 0, 2 -> 2;
                    case 1 -> 3;
                    default -> 0;
                };
                int m = -1 - j;

                if (m != -3) {
                    setBlockStateIfReplaceable(world, origin.method_10069(k, m, l), SILK_BLOCK);
                    setBlockStateIfReplaceable(world, origin.method_10069(k, m, -l), SILK_BLOCK);
                    setBlockStateIfReplaceable(world, origin.method_10069(l, m, k), SILK_BLOCK);
                    setBlockStateIfReplaceable(world, origin.method_10069(-l, m, k), SILK_BLOCK);
                } else {
                    setRandomNestState(world, origin.method_10069(k, m, l), random);
                    setRandomNestState(world, origin.method_10069(k, m, -l), random);
                    setRandomNestState(world, origin.method_10069(l, m, k), random);
                    setRandomNestState(world, origin.method_10069(-l, m, k), random);
                }
            }
        }
        
        for (int i = 0; i < 2; ++i) {
            int j = i + 1;
            setBlockStateIfReplaceable(world, origin.method_10069(j, -j, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -j, -j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-j, -j, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-j, -j, -j), SILK_BLOCK);
        }

        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setRandomNestState(world, origin.method_10069(i - 1, -3, j - 1), random);
            }
        }
    }
    
    private void generateLarge(class_5281 world, class_2338 origin, class_5819 random) {
        // Layer 0
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setBlockStateIfReplaceable(world, origin.method_10069(i - 1, 0, j - 1), SILK_BLOCK);
            }
        }

        // Layer 1
        for (int i = 0; i < 3; ++i) {
            int j = i - 1;
            setBlockStateIfReplaceable(world, origin.method_10069(2, -1, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-2, -1, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -1, 2), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -1, -2), SILK_BLOCK);
        }

        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -1, j - 1), AIR);
            }
        }

        // Layer 2
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setBlockStateIfReplaceable(world, origin.method_10069(i - 1, -2, j - 1), AIR);
            }
        }
        for (int i = 0; i < 3; ++i) {
            int j = i - 1;
            setBlockStateIfReplaceable(world, origin.method_10069(2, -2, j), AIR);
            setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, j), AIR);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -2, 2), AIR);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -2, -2), AIR);
            setBlockStateIfReplaceable(world, origin.method_10069(3, -2, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-3, -2, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -2, 3), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -2, -3), SILK_BLOCK);
        }

        setBlockStateIfReplaceable(world, origin.method_10069(2, -2, 2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(2, -2, -2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, 2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-2, -2, -2), SILK_BLOCK);

        // Layer 3
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                setBlockStateIfReplaceable(world, origin.method_10069(i - 2, -3, j - 2), AIR);
            }
        }
        for (int i = 0; i < 5; ++i) {
            int j = i - 2;
            setBlockStateIfReplaceable(world, origin.method_10069(3, -3, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-3, -3, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -3, 3), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -3, -3), SILK_BLOCK);
        }

        // Layer 4
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                setAcidState(world, origin.method_10069(i - 2, -4, j - 2));
            }
        }
        for (int i = 0; i < 3; ++i) {
            int j = i - 1;
            setAcidState(world, origin.method_10069(3, -4, j));
            setAcidState(world, origin.method_10069(-3, -4, j));
            setAcidState(world, origin.method_10069(j, -4, 3));
            setAcidState(world, origin.method_10069(j, -4, -3));
            setBlockStateIfReplaceable(world, origin.method_10069(4, -4, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-4, -4, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -4, 4), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -4, -4), SILK_BLOCK);
        }

        setBlockStateIfReplaceable(world, origin.method_10069(3, -4, 2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(3, -4, -2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-3, -4, 2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-3, -4, -2), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(2, -4, 3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(2, -4, -3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-2, -4, 3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-2, -4, -3), SILK_BLOCK);

        // Layer 5
        for (int i = 0; i < 5; ++i) {
            int j = i - 2;
            setBlockStateIfReplaceable(world, origin.method_10069(4, -5, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(-4, -5, j), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -5, 4), SILK_BLOCK);
            setBlockStateIfReplaceable(world, origin.method_10069(j, -5, -4), SILK_BLOCK);
        }

        setBlockStateIfReplaceable(world, origin.method_10069(3, -5, 3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(3, -5, -3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-3, -5, 3), SILK_BLOCK);
        setBlockStateIfReplaceable(world, origin.method_10069(-3, -5, -3), SILK_BLOCK);

        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                setAcidState(world, origin.method_10069(i - 3, -5, j - 3));
            }
        }

        // Layer 6

        setRandomNestState(world, origin.method_10069(2, -6, 2), random);
        setRandomNestState(world, origin.method_10069(2, -6, -2), random);
        setRandomNestState(world, origin.method_10069(-2, -6, 2), random);
        setRandomNestState(world, origin.method_10069(-2, -6, -2), random);
        for (int i = 0; i < 5; ++i) {
            int j = i - 2;
            setRandomNestState(world, origin.method_10069(3, -6, j), random);
            setRandomNestState(world, origin.method_10069(-3, -6, j), random);
            setRandomNestState(world, origin.method_10069(j, -6, 3), random);
            setRandomNestState(world, origin.method_10069(j, -6, -3), random);
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                setAcidState(world, origin.method_10069(i - 2, -6, j - 2));
            }
        }

        // Layer 7
        for (int i = 0; i < 3; ++i) {
            int j = i - 1;
            setRandomNestState(world, origin.method_10069(2, -7, j), random);
            setRandomNestState(world, origin.method_10069(-2, -7, j), random);
            setRandomNestState(world, origin.method_10069(j, -7, 2), random);
            setRandomNestState(world, origin.method_10069(j, -7, -2), random);
        }

        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                setRandomNestState(world, origin.method_10069(i - 1, -7, j - 1), random);
            }
        }

    }

    private void setRandomNestState(class_5281 world, class_2338 pos, class_5819 random) {
        boolean bl = random.method_43048(3) >= 1;
        class_2680 state = bl ? NEST_LARVAE : NEST;
        setBlockStateIfReplaceable(world, pos, state);
        if (bl && random.method_43048(2) == 0) setBlockStateIfReplaceable(world, pos.method_10074(), GLOWING_SILK);
    }

    private boolean isValidSpace(class_5281 worldAccess, class_2338 origin, boolean large) {
        int height = large ? 9 : 6;
        for (int i = 0; i < height; ++i) {
            class_2680 state = worldAccess.method_8320(origin.method_10087(i));
            if ( (i < 2 && canReplace(state)) || state.method_26215() ) continue;
            return false;
        }

        return true;
    }
    
    private boolean canReplace(class_2680 state) {
        return state.method_26164(VABlockTags.LUMWASP_NEST_REPLACEABLE) || state.method_45474();
    }

    protected void setAcidState(class_5281 world, class_2338 pos) {
        boolean bl = world.method_8409().method_43048(3) == 0;
        class_2680 state = bl ? ACID_BLOCK : ACID;
        if (world.method_8320(pos).method_26215()) method_13153(world, pos, state);
    }
    
    protected void setBlockStateIfReplaceable(class_5281 world, class_2338 pos, class_2680 state) {
        if (canReplace(world.method_8320(pos))) method_13153(world, pos, state);
    }
}
