package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.enums.CrystalShape;
import com.github.suninvr.virtualadditions.registry.VABlockTags;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class CrystalBlock extends class_2248 implements class_3737 {
    public static final MapCodec<CrystalBlock> CODEC = method_54094(CrystalBlock::new);
    public static final class_2754<CrystalShape> SHAPE = class_2754.method_11850("shape", CrystalShape.class);
    public static final class_2754<class_2350> POINTING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final class_265 BODY_Y_SHAPE;
    public static final class_265 TIP_DOWN_SHAPE;
    public static final class_265 TIP_UP_SHAPE;
    public static final class_265 BODY_X_SHAPE;
    public static final class_265 TIP_EAST_SHAPE;
    public static final class_265 TIP_WEST_SHAPE;
    public static final class_265 BODY_Z_SHAPE;
    public static final class_265 TIP_NORTH_SHAPE;
    public static final class_265 TIP_SOUTH_SHAPE;

    public CrystalBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(SHAPE, CrystalShape.TIP)
                .method_11657(POINTING, class_2350.field_11036)
                .method_11657(WATERLOGGED, false)
        );
    }

    @Override
    protected MapCodec<? extends class_2248> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(SHAPE).method_11667(POINTING).method_11667(WATERLOGGED);
    }

    public void onLandedUpon(class_1937 world, class_2680 state, class_2338 pos, class_1297 entity, float fallDistance) {
        if (state.method_11654(POINTING) == class_2350.field_11036 && state.method_11654(SHAPE) == CrystalShape.TIP) {
            entity.method_5747(fallDistance + 2.0F, 2.0F, world.method_48963().method_48837());

        } else {
            super.method_9554(world, state, pos, entity, fallDistance);
        }

    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions = ctx.method_7718();
        for (class_2350 direction : directions) {
            class_2680 state = this.method_9564().method_11657(POINTING, direction.method_10153()).method_11657(WATERLOGGED, ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910);
            if (method_9558(state, ctx.method_8045(), ctx.method_8037())) return state;
        }
        return null;

    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = state.method_11654(POINTING);
        return this.canPlaceOn(world, new class_2338(pos.method_10093(direction.method_10153())), direction);
    }

    public  boolean canPlaceOn(class_4538 world, class_2338 pos, class_2350 direction) {
        return class_2248.method_20044(world, pos, direction) || (world.method_8320(pos).method_26164(VABlockTags.CRYSTALS) && world.method_8320(pos).method_11654(POINTING) == direction);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_22352(pos, true);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (state.method_11654(WATERLOGGED)) world.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        class_2350 pointing = state.method_11654(POINTING);
        if (!canPlaceOn(world, new class_2338(pos.method_10093(pointing.method_10153())), pointing)) {
            world.method_64310(pos, this, 1);
        }
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2350 pointing = state.method_11654(POINTING);
        if (direction == pointing) {
            class_2680 fromState = world.method_8320(new class_2338(pos.method_10093(direction)));
            if (fromState.method_26164(VABlockTags.CRYSTALS) && fromState.method_11654(POINTING) == direction) {
                return state.method_11657(SHAPE, CrystalShape.BODY);
            } else {
                return state.method_11657(SHAPE, CrystalShape.TIP);
            }
        }
        return state;
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        boolean isBody = state.method_11654(SHAPE) == CrystalShape.BODY;
        class_243 vec3d = state.method_26226(pos);
        return switch (state.method_11654(POINTING)) {
            case field_11036 -> isBody ? BODY_Y_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350) : TIP_UP_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            case field_11033 -> isBody ? BODY_Y_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350) : TIP_DOWN_SHAPE.method_1096(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            case field_11043 -> isBody ? BODY_Z_SHAPE : TIP_NORTH_SHAPE;
            case field_11035 -> isBody ? BODY_Z_SHAPE : TIP_SOUTH_SHAPE;
            case field_11034 -> isBody ? BODY_X_SHAPE : TIP_EAST_SHAPE;
            case field_11039 -> isBody ? BODY_X_SHAPE : TIP_WEST_SHAPE;
        };
    }

    static {
        BODY_Y_SHAPE = class_2248.method_9541(4.0, 0.0, 4.0, 12.0, 16.0, 12.0);
        TIP_DOWN_SHAPE = class_2248.method_9541(4.0, 7.0, 4.0, 12.0, 16.0, 12.0);
        TIP_UP_SHAPE = class_2248.method_9541(4.0, 0.0, 4.0, 12.0, 9.0, 12.0);

        BODY_X_SHAPE = class_2248.method_9541(0.0, 4.0, 4.0, 16.0, 12.0, 12.0);
        TIP_EAST_SHAPE = class_2248.method_9541(0.0, 4.0, 4.0, 9.0, 12.0, 12.0);
        TIP_WEST_SHAPE = class_2248.method_9541(7.0, 4.0, 4.0, 16.0, 12.0, 12.0);

        BODY_Z_SHAPE = class_2248.method_9541(4.0, 4.0, 0.0, 12.0, 12.0, 16.0);
        TIP_NORTH_SHAPE = class_2248.method_9541(4.0, 4.0, 7.0, 12.0, 12.0, 16.0);
        TIP_SOUTH_SHAPE = class_2248.method_9541(4.0, 4.0, 0.0, 12.0, 12.0, 9.0);
    }
}
