package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.entity.DestructiveSculkBlockEntity;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2431;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3468;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class DestructiveSculkBlock extends class_2237 {
    public static final MapCodec<DestructiveSculkBlock> field_46280 = method_54094(DestructiveSculkBlock::new);
    public static final class_2746 SPREADING = class_2746.method_11825("spreading");
    public static final class_2746 ORIGIN = class_2746.method_11825("origin");
    public DestructiveSculkBlock(class_2251 settings) {
        super(settings);
        this.method_9590(field_10647.method_11664().method_11657(SPREADING, true).method_11657(ORIGIN, false));
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(SPREADING).method_11667(ORIGIN);
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new DestructiveSculkBlockEntity(pos, state);
    }

    public static void setData(class_1937 world, class_2338 pos, class_2680 replacedState, UUID playerId, class_1799 tool, int potency) {
        if(world.method_8321(pos) instanceof DestructiveSculkBlockEntity destructiveSculkBlockEntity) {
            destructiveSculkBlockEntity.setPlayerId(playerId);
            destructiveSculkBlockEntity.setTool(tool);
            destructiveSculkBlockEntity.setPotency(potency);
            destructiveSculkBlockEntity.setReplacedState(replacedState);
        }
    }

    public static void setOriginData(class_1937 world, class_2338 pos, class_2680 replacedState, UUID playerId, class_1799 tool, int potency) {
        if(world.method_8321(pos) instanceof DestructiveSculkBlockEntity destructiveSculkBlockEntity) {
            destructiveSculkBlockEntity.setPlayerId(playerId);
            destructiveSculkBlockEntity.setTool(tool);
            destructiveSculkBlockEntity.setPotency(potency);
            destructiveSculkBlockEntity.setReplacedState(replacedState);
            destructiveSculkBlockEntity.setOrigin();
        }
    }

    public static void placeState(class_1937 world, class_2338 pos, class_2680 replacedState, UUID playerId, class_1799 tool, int potency) {
        boolean spreading = potency > 0;
        world.method_8501(pos, VABlocks.DESTRUCTIVE_SCULK.method_9564().method_11657(DestructiveSculkBlock.ORIGIN, true).method_11657(SPREADING, spreading));
        world.method_64310(pos, VABlocks.DESTRUCTIVE_SCULK, spreading ? 2 : 10);
        DestructiveSculkBlock.setOriginData(world, pos, replacedState, playerId, tool, potency);
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!state.method_11654(SPREADING)) {
            if (world.method_8321(pos) instanceof DestructiveSculkBlockEntity destructiveSculkBlockEntity) {
                class_1657 player = world.method_18470(destructiveSculkBlockEntity.getPlayerId());
                if (player != null) player.method_7259(class_3468.field_15427.method_14956(destructiveSculkBlockEntity.getReplacedState().method_26204()));
                destructiveSculkBlockEntity.destroyAll();
            }
        }
    }

    @Override
    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        DestructiveSculkBlockEntity blockEntity = builder.method_51873(class_181.field_1228) instanceof DestructiveSculkBlockEntity destructiveSculkBlockEntity ? destructiveSculkBlockEntity : null;
        if (blockEntity != null && blockEntity.method_10997() instanceof class_3218 serverWorld) {
            return blockEntity.getDroppedStacks(serverWorld);
        }
        return Collections.emptyList();
    }

    @Override
    public void method_9565(class_2680 state, class_3218 world, class_2338 pos, class_1799 tool, boolean dropExperience) {
        super.method_9565(state, world, pos, tool, dropExperience);
        DestructiveSculkBlockEntity blockEntity = getBlockEntity(world, pos);
        if (blockEntity != null) {
            class_2248 block = blockEntity.getReplacedState().method_26204();
            if (block instanceof class_2431 experienceDroppingBlock) {
                method_41420(world, pos, blockEntity.getTool(), experienceDroppingBlock.field_27195);
            }
        }
    }

    protected static DestructiveSculkBlockEntity getBlockEntity(class_1937 world, class_2338 pos) {
        return world.method_8321(pos) instanceof DestructiveSculkBlockEntity destructiveSculkBlockEntity ? destructiveSculkBlockEntity : null;
    }

    @Nullable
    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        if (!state.method_11654(ORIGIN)) return null;
        return method_31618(type, VABlockEntityType.DESTRUCTIVE_SCULK, (DestructiveSculkBlockEntity::tick));
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
}
