package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VASoundEvents;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class FrayedSilkBlock extends class_2261 {
    public static final MapCodec<FrayedSilkBlock> CODEC = method_54094(FrayedSilkBlock::new);
    protected static final class_265 SHAPE = class_2248.method_9541(2.0, 0.0, 2.0, 14.0, 13.0, 14.0);
    public static final class_2754<class_2350> VERTICAL_DIRECTION = class_2741.field_28062;
    public FrayedSilkBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(VERTICAL_DIRECTION, class_2350.field_11036)
        );
    }

    @Override
    protected MapCodec<? extends class_2261> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(VERTICAL_DIRECTION);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_2350[] directions = ctx.method_7718();
        for (class_2350 direction : directions) {
            class_2680 state = this.method_9564().method_11657(VERTICAL_DIRECTION, direction == class_2350.field_11033 ? class_2350.field_11036 : class_2350.field_11033);
            if (method_9558(state, ctx.method_8045(), ctx.method_8037())) return state;
        }
        return null;

    }

    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
        return floor.method_26206(world, pos, class_2350.field_11036);
    }

    protected boolean canPlantOnBottom(class_2680 ceiling, class_1922 world, class_2338 pos) {
        return ceiling.method_26206(world, pos, class_2350.field_11033);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = state.method_11654(VERTICAL_DIRECTION);
        class_2338 placeOnPos = pos.method_10079(direction, -1);
        return direction == class_2350.field_11036 ? this.method_9695(world.method_8320(placeOnPos), world, placeOnPos) : this.canPlantOnBottom(world.method_8320(placeOnPos), world, placeOnPos);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(500) <= 1 && world.method_8320(pos.method_10093(state.method_11654(VERTICAL_DIRECTION).method_10153())).method_27852(VABlocks.SILK_BLOCK)) {
            world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), VASoundEvents.BLOCK_FRAYED_SILK_IDLE, class_3419.field_15245, 1.0F, 0.7F, true);
        }
    }
}
