package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.block.enums.HangingBlockShape;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class HangingBlock extends class_2248 implements class_3737 {
    public static final MapCodec<HangingBlock> CODEC = method_54094(HangingBlock::new);
    private static final class_2746 WATERLOGGED;
    public static final class_2754<HangingBlockShape> SHAPE;
    protected static final class_265 BOX;

    public HangingBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664()
                .method_11657(WATERLOGGED, false)
                .method_11657(SHAPE, HangingBlockShape.SINGLE)
        );
    }

    @Override
    protected MapCodec<? extends class_2248> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(WATERLOGGED, SHAPE);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return BOX;
    }

    @Override
    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        world.method_22352(pos, true);
    }

    @Override
    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction == class_2350.field_11036){
            if (!this.method_9558(state, world, pos)) {
                tickView.method_64310(pos, this, 1);
                return state;
            }
        }
        state = updateState(state, world, pos);
        return state;
    }

    private class_2680 updateState(class_2680 state, class_4538 world, class_2338 pos) {
        class_2680 downState = world.method_8320(pos.method_10074());
        if (world.method_8320(pos.method_10084()).method_27852(this)) {
            if (downState.method_27852(this)) state = state.method_11657(SHAPE, HangingBlockShape.STRAIGHT);
            else state = state.method_11657(SHAPE, HangingBlockShape.END);
        }  else {
            if (downState.method_27852(this)) state = state.method_11657(SHAPE, HangingBlockShape.BASE);
            else state = state.method_11657(SHAPE, HangingBlockShape.SINGLE);}
        return state;
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (state.method_11654(WATERLOGGED)) world.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState = super.method_9605(ctx);
        if (blockState != null) {
            class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
            return updateState(blockState.method_11657(WATERLOGGED, fluidState.method_15772() == class_3612.field_15910), ctx.method_8045(), ctx.method_8037());
        } else {
            return null;
        }
    }

    static {
        WATERLOGGED = class_2741.field_12508;
        SHAPE = class_2754.method_11850("shape", HangingBlockShape.class);
        BOX = class_2248.method_9541(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);
    }

    @Override
    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 up = pos.method_10084();
        class_2680 upState = world.method_8320(up);
        return upState.method_27852(this) || upState.method_26206(world, up, class_2350.field_11033);
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }
}
