package com.github.suninvr.virtualadditions.block;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAFluids;
import com.github.suninvr.virtualadditions.registry.VAItemTags;
import com.github.suninvr.virtualadditions.registry.VASoundEvents;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_8923;

@SuppressWarnings("deprecation")
public class LumwaspNestBlock extends class_8923 {
    public static final MapCodec<LumwaspNestBlock> CODEC = method_54094(LumwaspNestBlock::new);
    public static final class_2746 LARVAE = class_2746.method_11825("larvae");
    public LumwaspNestBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664().method_11657(LARVAE, false));
    }

    @Override
    protected MapCodec<? extends class_8923> method_53969() {
        return field_46366;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(LARVAE);
    }

    @Override
    public boolean method_9542(class_2680 state) {
        return state.method_11654(LARVAE);
    }

    @Override
    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_8316(pos.method_10084()).method_39360(VAFluids.ACID) && !world.method_8320(pos.method_10084()).method_27852(VABlocks.ACID_BLOCK)) {
            world.method_8501(pos, state.method_11657(LARVAE, false));
        }
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (random.method_43048(250) == 0 && state.method_11654(LARVAE)) {
            world.method_8486(pos.method_10263(), pos.method_10264(), pos.method_10260(), VASoundEvents.BLOCK_LUMWASP_NEST_IDLE, class_3419.field_15245, 1.0F, 1.2F, true);
        }
    }

    @Override
    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
            if (world.method_8608()) return;
            if (world.method_8316(pos.method_10084()).method_39360(VAFluids.ACID) && world.method_8320(pos.method_10074()).method_26215() && entity instanceof class_1542 itemEntity) {
            class_1799 stack = itemEntity.method_6983();
            int i = 0;
            if (stack.method_31573(VAItemTags.LUMWASP_LARVAE_FOOD)) i += stack.method_7947();
            else return;

            boolean larvae = state.method_11654(LARVAE);
            while (i > 0) {
                stack.method_7934(1);
                if (larvae) {
                    world.method_8501(pos.method_10074(), VABlocks.GLOWING_SILK.method_9564());
                    return;
                } else {
                    world.method_8501(pos, state.method_11657(LARVAE, true));
                }
                i--;
            }
        }
    }
}
