package com.github.suninvr.virtualadditions.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings("deprecation")
public class RedstoneBridgeBlock extends class_2248 implements class_3737 {
    public static final MapCodec<RedstoneBridgeBlock> CODEC = method_54094(RedstoneBridgeBlock::new);
    public static final class_2758 POWER = class_2741.field_12511;
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 SHAPE_X;
    private static final class_265 SHAPE_Y;
    private static final class_265 SHAPE_Z;
    public boolean sendsRedstonePower = true;
    private boolean sendsLessStrongRedstonePower = false;

    public RedstoneBridgeBlock(class_2251 settings) {
        super(settings);
        this.method_9590(method_9595().method_11664().method_11657(FACING, class_2350.field_11033).method_11657(POWER, 0).method_11657(WATERLOGGED, false));
    }

    @Override
    protected MapCodec<? extends class_2248> method_53969() {
        return field_46280;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(POWER, FACING, WATERLOGGED);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return switch (state.method_11654(FACING).method_10166()) {
            case field_11048 -> SHAPE_X;
            case field_11052 -> SHAPE_Y;
            case field_11051 -> SHAPE_Z;
        };
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2350 dir = state.method_11654(FACING);
        if (dir.method_10166() != class_2350.class_2351.field_11052) {
            dir = switch (rotation) {
                case field_11467 -> dir;
                case field_11463 -> dir.method_10170();
                case field_11464 -> dir.method_10153();
                case field_11465 -> dir.method_10160();
            };
        }
        return state.method_11657(FACING, dir);
    }

    @Override
    public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        if (state.method_11654(WATERLOGGED)) world.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        int power = getPower(world, pos, state);
        if (power == state.method_11654(POWER)) return;
        world.method_8501(pos, state.method_11657(POWER, power));
        this.updateAffectedNeighbors(world, pos, state);
    }

    @Override
    public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.sendsRedstonePower && state.method_11654(FACING).equals(direction.method_10153()) ? state.method_11654(POWER) : 0;
    }

    @Override
    public int method_9603(class_2680 state, class_1922 world, class_2338 pos, class_2350 direction) {
        return this.sendsLessStrongRedstonePower ? Math.max(0, method_9524(state, world, pos, direction) - 1) : method_9524(state, world, pos, direction);
    }

    @Override
    public boolean method_9506(class_2680 state) {
        return true;
    }

    protected int getPower(class_1936 world, class_2338 pos, class_2680 state) {
        class_2350 direction = state.method_11654(FACING).method_10153();
        class_2338 blockPos = pos.method_10093(direction);

        this.setWireFlags(false);
        int i = world.method_49808(blockPos, direction);
        this.setWireFlags(true);

        this.sendsLessStrongRedstonePower = true;
        int j = Math.max(0, world.method_49808(blockPos, direction) - 1);
        this.sendsLessStrongRedstonePower = false;

        return Math.max(i, j);
    }

    protected void setWireFlags(boolean bl) {
        this.sendsRedstonePower = bl;
        ((class_2457) class_2246.field_10091).field_11438 = bl;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        updateAffectedNeighbors(world, pos, state);
    }

    @Override
    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState != state) updateAffectedNeighbors(world, pos, state);
    }

    @Override
    protected void method_66388(class_2680 blockState, class_3218 serverWorld, class_2338 blockPos, boolean bl) {
        updateAffectedNeighbors(serverWorld, blockPos, blockState);
    }

    private void updateAffectedNeighbors(class_1937 world, class_2338 pos, class_2680 state) {
        world.method_8508(pos.method_10093(state.method_11654(FACING)), this, state.method_11654(FACING).method_10153(), class_9904.method_61843(0));
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(WATERLOGGED) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Nullable
    @Override
    public class_2680 method_9605(class_1750 ctx) {
        boolean bl = ctx.method_8045().method_8316(ctx.method_8037()).method_39360(class_3612.field_15910);
        class_2680 state = method_9564().method_11657(FACING, ctx.method_8038());
        return state.method_11657(POWER, getPower(ctx.method_8045(), ctx.method_8037(), state)).method_11657(WATERLOGGED, bl);
    }

    static {
        SHAPE_X = class_2248.method_9541(0, 4, 4, 16, 12, 12);
        SHAPE_Y = class_2248.method_9541(4, 0, 4, 12, 16, 12);
        SHAPE_Z = class_2248.method_9541(4, 4, 0, 12, 12, 16);
    }
}
