package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.block.DestructiveSculkBlock;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4844;
import net.minecraft.class_8567;

public class DestructiveSculkBlockEntity extends class_2586 {
    private class_2680 replacedState;
    private boolean isOrigin;
    private UUID playerId;
    private static final UUID nullId = UUID.fromString("0-0-0-0-0");
    private class_1799 tool;
    private int potency;
    private final ArrayList<class_2338> affectedPos;
    private int activePosIndex;
    private boolean firstTick;

    private static final class_2350[] HORIZONTAL_DIRECTIONS = {class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public DestructiveSculkBlockEntity(class_2338 pos, class_2680 state) {
        super(VABlockEntityType.DESTRUCTIVE_SCULK, pos, state);
        this.replacedState = class_2246.field_10124.method_9564();
        this.playerId = nullId;
        this.tool = class_1799.field_8037;
        this.potency = 0;
        this.affectedPos = new ArrayList<>();
        this.activePosIndex = -1;
        this.firstTick = true;
        this.isOrigin = false;
    }

    public class_2680 getReplacedState() {
        return replacedState;
    }

    public UUID getPlayerId() {
        return playerId;
    }

    public class_1799 getTool() {
        return tool;
    }

    public int getPotency() {
        return potency;
    }

    public boolean isOrigin() {
        return this.isOrigin;
    }

    private boolean stateMatches(class_2338 pos) {
        return this.field_11863 != null && this.field_11863.method_8320(pos).method_27852(this.replacedState.method_26204());
    }

    public class_2338 getFirstMatch() {
        for (class_2350 direction : class_2350.values()) {
            class_2338 pos1 = this.field_11867.method_10093(direction);
            if (this.stateMatches(pos1)) return pos1;

        }

        for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
            class_2338 pos1 = this.field_11867.method_10093(direction).method_10093(class_2350.field_11036);
            class_2338 pos2 = this.field_11867.method_10093(direction).method_10093(direction.method_10170());
            class_2338 pos3 = this.field_11867.method_10093(direction).method_10093(class_2350.field_11033);
            if (this.stateMatches(pos1)) return pos1;
            if (this.stateMatches(pos2)) return pos2;
            if (this.stateMatches(pos3)) return pos3;

        }

        return null;
    }

    public List<class_2338> getAdjacentMatches() {
        ArrayList<class_2338> posList = new ArrayList<>();
        class_2350.method_42013().forEach(direction -> {
            class_2338 pos1 = this.field_11867.method_10093(direction);
            if (this.stateMatches(pos1)) posList.add(pos1);
        });
        return posList;
    }

    public List<class_2338> getEdgeAdjacentMatches() {
        ArrayList<class_2338> posList = new ArrayList<>();
        class_2350.class_2353.field_11062.method_29716().forEach(direction -> {
            class_2338 pos1 = this.field_11867.method_10093(direction).method_10093(class_2350.field_11036);
            class_2338 pos2 = this.field_11867.method_10093(direction).method_10093(direction.method_10170());
            class_2338 pos3 = this.field_11867.method_10093(direction).method_10093(class_2350.field_11033);
            if (this.stateMatches(pos1)) posList.add(pos1);
            if (this.stateMatches(pos2)) posList.add(pos2);
            if (this.stateMatches(pos3)) posList.add(pos3);
        });
        return posList;
    }

    public ArrayList<class_2338> getAffectedPos() {
        return affectedPos;
    }

    public int getActivePosIndex() {
        return activePosIndex;
    }

    @Nullable
    public class_2338 getActivePos() {
        return this.activePosIndex >= 0 ? this.activePosIndex < this.affectedPos.size() ? this.affectedPos.get(this.activePosIndex) : null : this.method_11016();
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        this.destroyAll();
        super.method_66473(pos, oldState);
    }

    public void setReplacedState(class_2680 state) {
        if (this.field_11863 instanceof class_3218 serverWorld) {
            this.replacedState = state;
            this.method_5431();
        }
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
        this.method_5431();
    }

    public void setTool(class_1799 tool) {
        this.tool = tool;
        this.method_5431();
    }

    public void setPotency(int potency) {
        this.potency = potency;
        this.method_5431();
    }

    public void addAffectedPos(class_2338 pos) {
        this.affectedPos.add(pos);
        this.method_5431();
    }

    public void setActivePosIndex(int index) {
        this.activePosIndex = index;
        this.method_5431();
    }

    public void setOrigin() {
        this.isOrigin = true;
        this.method_5431();
    }

    public class_8567.class_8568 modifyLootContext(class_8567.class_8568 builder) {
        if (this.method_10997() instanceof class_3218 serverWorld) {
            builder.method_51874(class_181.field_24424, new class_243(this.method_11016().method_10263(), this.method_11016().method_10264(), this.method_11016().method_10260()));
            class_1657 player = serverWorld.method_18470(this.getPlayerId());
            if (player != null) builder.method_51874(class_181.field_1226, player);
            builder.method_51874(class_181.field_1229, this.tool);
            builder.method_51874(class_181.field_1228, this);
        }
        return builder;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, DestructiveSculkBlockEntity blockEntity) {
        if (world.method_8608()) return;
        if (!blockEntity.isOrigin) return;
        if (blockEntity.firstTick) {
            blockEntity.firstTick = false;
            return;
        }
        boolean bl = false;
        while (!bl) {
            class_2338 activePos = blockEntity.getActivePos();
            if (activePos == null) {
                world.method_64310(pos, VABlocks.DESTRUCTIVE_SCULK, 6);
                return;
            }
            class_2586 activeEntity = world.method_8321(activePos);

            bl = activeEntity instanceof DestructiveSculkBlockEntity spreadFrom && spreadFrom.trySpread(blockEntity);
            if (!bl) {
                blockEntity.setActivePosIndex(blockEntity.getActivePosIndex() + 1);
            }
        }
    }

    public boolean trySpread(DestructiveSculkBlockEntity originEntity) {
        if (this.field_11863 == null) return false;
        if (this.field_11863.method_8608()) return false;
        if (originEntity.getPotency() <= 0) return false;
        class_2338 blockPos = this.getFirstMatch();

        boolean bl = false;
        if (blockPos != null) {
            class_2680 stateToReplace = this.field_11863.method_8320(blockPos);
            this.field_11863.method_8501(blockPos, VABlocks.DESTRUCTIVE_SCULK.method_9564());
            DestructiveSculkBlock.setData(this.field_11863, blockPos, stateToReplace, this.getPlayerId(), this.getTool(), 0);
            originEntity.addAffectedPos(blockPos);
            originEntity.setPotency(originEntity.getPotency() - 1);
            this.field_11863.method_8396(null, blockPos, class_3417.field_37357, class_3419.field_15245, 0.5F, 1.0F);
            if (this.field_11863 instanceof class_3218 serverWorld) {
                serverWorld.method_14199(class_2398.field_38004, false, false, blockPos.method_10263() + 0.5, blockPos.method_10264() + 0.5, blockPos.method_10260() + 0.5, 20, 0.4, 0.4, 0.4, 0.02);
            }
            bl = true;
        }
        if (blockPos == null || originEntity.getPotency() < 1) {
            this.field_11863.method_8501(this.field_11867, this.field_11863.method_8320(this.field_11867).method_11657(DestructiveSculkBlock.SPREADING, false));
        }
        return bl;
    }

    public void destroyAll() {
        if (this.field_11863 == null || this.field_11863.method_8608()) return;
        if (this.isOrigin()) {
            this.getAffectedPos().forEach( (blockPos) -> {
                if (this.field_11863.method_8320(blockPos).method_27852(VABlocks.DESTRUCTIVE_SCULK)) this.field_11863.method_8501(blockPos, this.field_11863.method_8320(blockPos).method_11657(DestructiveSculkBlock.SPREADING, false));
                int i = this.getAffectedPos().indexOf(blockPos) / 10;
                this.field_11863.method_64310(blockPos, VABlocks.DESTRUCTIVE_SCULK, field_11863.method_8409().method_39332(1, 4) + i);
            });
        }
        this.field_11863.method_8651(this.field_11867, true, this.field_11863.method_18470(this.playerId));
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.potency = view.method_71424("potency", 0);
        view.method_71426("player_id", class_4844.field_40825).ifPresentOrElse(this::setPlayerId, () -> this.setPlayerId(nullId));
        view.method_71426("state", class_2680.field_24734).ifPresent(state -> this.replacedState = state);
        view.method_71426("tool", class_1799.field_24671).ifPresent(itemStack -> this.tool = itemStack);
        this.isOrigin = view.method_71433("origin", this.isOrigin);
        this.activePosIndex = view.method_71424("active_pos_index", -1);
        this.affectedPos.clear();
        Optional<class_11368.class_11369<class_2338>> affectedPos = view.method_71435("affected_pos", class_2338.field_25064);
        affectedPos.ifPresent(blockPos -> blockPos.forEach(this.affectedPos::add));
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("potency", this.potency);
        view.method_71468("player_id", class_4844.field_40825, this.playerId);
        view.method_71468("state", class_2680.field_24734, this.replacedState);
        view.method_71468("tool", class_1799.field_24671, this.tool);
        view.method_71472("origin", this.isOrigin);
        if (!this.affectedPos.isEmpty()) {
            view.method_71465("active_pos_index", this.activePosIndex);
            class_11372.class_11373<class_2338> affectedPos = view.method_71467("affected_pos", class_2338.field_25064);
            this.affectedPos.forEach(affectedPos::method_71484);
        }
    }

    public List<class_1799> getDroppedStacks(class_3218 serverWorld) {
        return this.replacedState.method_26189(
                this.modifyLootContext(new class_8567.class_8568(serverWorld))
        );
    }
}
