package com.github.suninvr.virtualadditions.block.entity;

import com.github.suninvr.virtualadditions.block.EntanglementDriveBlock;
import com.github.suninvr.virtualadditions.registry.VABlockEntityType;
import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VAStatusEffects;
import com.github.suninvr.virtualadditions.screen.EntanglementDriveScreenHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_4844;

@SuppressWarnings({"unused", "DataFlowIssue"})
public class EntanglementDriveBlockEntity extends class_2586 implements class_3908, class_1278 {
    private static final class_2561 TITLE = class_2561.method_43471("container.virtual_additions.entanglement_drive");
    private int slotIndex;
    private UUID playerId;
    private int[] playerIdInts;
    private class_1799 cachedStack;
    private final class_3913 properties = new class_3913() {
        @Override
        public int method_17390(int index) {
            return switch (index) {
                case 0 -> EntanglementDriveBlockEntity.this.slotIndex;
                case 1 -> EntanglementDriveBlockEntity.this.playerIdInts[0];
                case 2 -> EntanglementDriveBlockEntity.this.playerIdInts[1];
                case 3 -> EntanglementDriveBlockEntity.this.playerIdInts[2];
                case 4 -> EntanglementDriveBlockEntity.this.playerIdInts[3];
                default -> throw new IllegalStateException("Unexpected value: " + index);
            };
        }

        @Override
        public void method_17391(int index, int value) {
            switch (index) {
                case 0 -> EntanglementDriveBlockEntity.this.slotIndex = value;
                case 1 -> EntanglementDriveBlockEntity.this.playerIdInts[0] = value;
                case 2 -> EntanglementDriveBlockEntity.this.playerIdInts[1] = value;
                case 3 -> EntanglementDriveBlockEntity.this.playerIdInts[2] = value;
                case 4 -> EntanglementDriveBlockEntity.this.playerIdInts[3] = value;
                default -> throw new IllegalStateException("Unexpected value: " + index);
            }
            EntanglementDriveBlockEntity.this.method_5431();
        }

        @Override
        public int method_17389() {
            return 5;
        }
    };
    private static final class_1263 dummyInventory = new DummyInventory();
    private static final String nullIdString = "0-0-0-0-0";
    private static final UUID nullId = UUID.fromString(nullIdString);

    public EntanglementDriveBlockEntity(class_2338 pos, class_2680 state) {
        super(VABlockEntityType.ENTANGLEMENT_DRIVE, pos, state);
        this.slotIndex = -1;
        this.setPlayerId(nullId);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        this.slotIndex = view.method_71424("slot_index",-1);
        UUID playerId = view.method_71426("user_id", class_4844.field_40825).orElse(nullId);
        this.setPlayerId(playerId);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("slot_index", this.slotIndex);
        view.method_71468("user_id", class_4844.field_40825, this.playerId);
    }

    @NotNull
    public Optional<class_1657> getPlayer() {
        return Optional.ofNullable(this.method_10997().method_8503().method_3760().method_14602(this.playerId));
    }

    public void setPlayerId(UUID playerId) {
        this.playerId = playerId;
        this.playerIdInts = class_4844.method_26275(playerId);
    }

    @Nullable
    private class_1661 getPlayerInventory() {
        if (this.getPlayer().isEmpty()) return null;
        return this.getPlayer().get().method_31548();
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public void setPlayerSlot(@Nullable class_1657 player, int slotIndex, int slotId) {
        if (player != null) {
            if (this.field_11863 != null || this.field_11863.method_8608()) return;
            this.setPlayerId(player.method_5667());
            this.slotIndex = slotIndex;
            this.method_5431();
        }
    }

    public static <E extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, EntanglementDriveBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        world.method_8455(pos, VABlocks.ENTANGLEMENT_DRIVE);
    }

    public class_1278 getInventory() {
        return this;
    }

    @Nullable
    @Override
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new EntanglementDriveScreenHandler(syncId, inv, class_3914.method_17392(this.field_11863, this.field_11867), this.properties);
    }

    @Override
    public class_2561 method_5476() {
        return TITLE;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[]{0};
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return dir == class_2350.field_11036 && this.canModifyPlayerInventory();
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033 && this.canModifyPlayerInventory();
    }

    @Override
    public int method_5439() {
        return 1;
    }

    @Override
    public boolean method_5442() {
        if (!this.canAccessPlayerInventory()) return dummyInventory.method_5442();
        return this.getPlayerInventory().method_5438(this.getSlotIndex()) == class_1799.field_8037;
    }

    public class_1799 getStack() {
        return this.method_5438(0);
    }

    @Override
    public class_1799 method_5438(int slot) {
        if (!this.canAccessPlayerInventory()) return dummyInventory.method_5438(slot);
        return this.getPlayerInventory().method_5438(this.getSlotIndex());
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        if (!this.canModifyPlayerInventory()) return dummyInventory.method_5434(slot, amount);
        class_1799 stack = this.getPlayerInventory().method_5434(this.getSlotIndex(), amount);
        this.method_5431();
        return stack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        if (!this.canModifyPlayerInventory()) return class_1799.field_8037;
        class_1799 stack = this.getPlayerInventory().method_5441(this.getSlotIndex());
        this.method_5431();
        return stack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        if (!this.canModifyPlayerInventory()) return;
        this.getPlayerInventory().method_5447(this.getSlotIndex(), stack);
        this.method_5431();
    }

    @Override
    public boolean method_5443(class_1657 player) {
        if (!this.canAccessPlayerInventory()) return dummyInventory.method_5443(player);
        return this.getPlayerInventory().method_5443(player);
    }

    @Override
    public void method_5448() {
        if (!this.canModifyPlayerInventory()) return;
        this.getPlayerInventory().method_5441(this.getSlotIndex());
        this.method_5431();
    }

    private boolean canModifyPlayerInventory() {
        if (!canAccessPlayerInventory()) return false;
        class_1657 player = this.getPlayer().get();
        class_1293 effect = player.method_6112(VAStatusEffects.IOLITE_INTERFERENCE);
        boolean bl = effect == null || effect.method_5578() < 1;
        return !player.method_29504() && !player.method_7325() && bl;
    }

    @SuppressWarnings("BooleanMethodIsAlwaysInverted")
    private boolean canAccessPlayerInventory() {
        if (this.getPlayer().isEmpty()) return false;
        if (this.slotIndex < 0) return false;
        class_2680 state = this.method_10997() != null ? this.method_10997().method_8320(this.method_11016()) : class_2246.field_10124.method_9564();
        return this.getPlayerInventory() != null && state.method_27852(VABlocks.ENTANGLEMENT_DRIVE) && !state.method_11654(EntanglementDriveBlock.POWERED);
    }

    static class DummyInventory extends class_1277 implements class_1278 {
        public DummyInventory() {
            super(0);
        }

        public int[] method_5494(class_2350 side) {
            return new int[0];
        }

        public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
            return false;
        }

        public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
            return false;
        }
    }
}
