package com.github.suninvr.virtualadditions.client;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.block.RedstoneBridgeBlock;
import com.github.suninvr.virtualadditions.client.render.block.MiniPortalBlockEntityRenderer;
import com.github.suninvr.virtualadditions.client.render.entity.*;
import com.github.suninvr.virtualadditions.client.render.fog.PlayerProjectionPhasingFogModifier;
import com.github.suninvr.virtualadditions.registry.*;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.client.render.fluid.v1.SimpleFluidRenderHandler;
import net.fabricmc.fabric.api.client.rendering.v1.*;
import net.minecraft.class_11515;
import net.minecraft.class_1163;
import net.minecraft.class_1926;
import net.minecraft.class_1933;
import net.minecraft.class_2457;
import net.minecraft.class_2960;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5616;
import net.minecraft.class_758;
import net.minecraft.class_7761;
import net.minecraft.class_823;
import net.minecraft.class_825;
import net.minecraft.class_834;
import net.minecraft.class_837;
import net.minecraft.class_881;
import net.minecraft.class_953;
import net.minecraft.client.render.block.entity.*;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

public class VARenderers {
    public static class_5601 LUMWASP_LAYER = new class_5601(class_2960.method_60655("virtual_additions", "lumwasp"), "main");
    public static class_5601 SPECTRE_LAYER = new class_5601(class_2960.method_60655("virtual_additions", "spectre"), "main");
    public static class_5601 PLAYER_PROJECTION_LAYER = new class_5601(class_2960.method_60655("virtual_additions", "player_projection"), "main");
    public static class_5601 SOULBLOOM_BOAT = new class_5601(class_2960.method_60655("virtual_additions", "boat/soulbloom"), "main");
    public static class_5601 SOULBLOOM_CHEST_BOAT = new class_5601(class_2960.method_60655("virtual_additions", "chest_boat/soulbloom"), "main");
    public static final class_4730 CHARTREUSE_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_chartreuse"));
    public static final class_4730 MAROON_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_maroon"));
    public static final class_4730 INDIGO_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_indigo"));
    public static final class_4730 PLUM_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_plum"));
    public static final class_4730 VIRIDIAN_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_viridian"));
    public static final class_4730 TAN_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_tan"));
    public static final class_4730 SINOPIA_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_sinopia"));
    public static final class_4730 LILAC_SHULKER_BOX = new class_4730(class_4722.field_21704, VirtualAdditions.idOf("entity/shulker/shulker_lilac"));
    public static final class_4730 CHARTREUSE_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/chartreuse"));
    public static final class_4730 MAROON_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/maroon"));
    public static final class_4730 INDIGO_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/indigo"));
    public static final class_4730 PLUM_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/plum"));
    public static final class_4730 VIRIDIAN_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/viridian"));
    public static final class_4730 TAN_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/tan"));
    public static final class_4730 SINOPIA_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/sinopia"));
    public static final class_4730 LILAC_BED_TEXTURE = new class_4730(class_4722.field_21705, VirtualAdditions.idOf("entity/bed/lilac"));
    public static final RenderStateDataKey<Boolean> IS_HOLDING_HALBERD = RenderStateDataKey.create(() -> "virtual_additions:is_using_halberd");
    public static final RenderStateDataKey<Float> HALBERD_READINESS = RenderStateDataKey.create(() -> "virtual_additions:halberd_readiness");
    public static void init() {
        initBlockRenderLayers();
        initEntityRenderers();
        initBlockEntityRenderers();
        initFluidRenderers();
        initColorProviders();
        initFogModifiers();
    }

    private static void initBlockRenderLayers() {
        BlockRenderLayerMap.putFluids(class_11515.field_60926,
                VAFluids.ACID,
                VAFluids.FLOWING_ACID
        );

        BlockRenderLayerMap.putBlocks(class_11515.field_60926,
                VABlocks.WEBBED_SILK,
                VABlocks.ACID_BLOCK,
                VABlocks.CHARTREUSE_STAINED_GLASS,
                VABlocks.CHARTREUSE_STAINED_GLASS_PANE,
                VABlocks.MAROON_STAINED_GLASS,
                VABlocks.MAROON_STAINED_GLASS_PANE,
                VABlocks.INDIGO_STAINED_GLASS,
                VABlocks.INDIGO_STAINED_GLASS_PANE,
                VABlocks.PLUM_STAINED_GLASS,
                VABlocks.PLUM_STAINED_GLASS_PANE,
                VABlocks.VIRIDIAN_STAINED_GLASS,
                VABlocks.VIRIDIAN_STAINED_GLASS_PANE,
                VABlocks.TAN_STAINED_GLASS,
                VABlocks.TAN_STAINED_GLASS_PANE,
                VABlocks.SINOPIA_STAINED_GLASS,
                VABlocks.SINOPIA_STAINED_GLASS_PANE,
                VABlocks.LILAC_STAINED_GLASS,
                VABlocks.LILAC_STAINED_GLASS_PANE
        );

        BlockRenderLayerMap.putBlocks(class_11515.field_60925,
                VABlocks.CLIMBING_ROPE_ANCHOR,
                VABlocks.EXPOSED_CLIMBING_ROPE_ANCHOR,
                VABlocks.WEATHERED_CLIMBING_ROPE_ANCHOR,
                VABlocks.OXIDIZED_CLIMBING_ROPE_ANCHOR,
                VABlocks.WAXED_CLIMBING_ROPE_ANCHOR,
                VABlocks.WAXED_EXPOSED_CLIMBING_ROPE_ANCHOR,
                VABlocks.WAXED_WEATHERED_CLIMBING_ROPE_ANCHOR,
                VABlocks.WAXED_OXIDIZED_CLIMBING_ROPE_ANCHOR,
                VABlocks.CLIMBING_ROPE,
                VABlocks.SOULBLOOM_DOOR,
                VABlocks.SOULBLOOM_TRAPDOOR,
                VABlocks.SOULBLOOM_SAPLING,
                VABlocks.POTTED_SOULBLOOM_SAPLING,
                VABlocks.NECROTIC_ROOTS,
                VABlocks.POTTED_NECROTIC_ROOTS,
                VABlocks.BONE_LITTER,
                VABlocks.BONE_PILE,
                VABlocks.WITHERED_DOOR,
                VABlocks.WITHERED_TRAPDOOR,
                VABlocks.WITHERED_SAPLING,
                VABlocks.POTTED_WITHERED_SAPLING,
                VABlocks.SPECTRAL_FIRE,
                VABlocks.SPECTRAL_LANTERN,
                VABlocks.BLUE_PETALS,
                VABlocks.BALLOON_BULB,
                VABlocks.BALLOON_BULB_PLANT,
                VABlocks.BALLOON_BULB_BUD,
                VABlocks.ROCK_SALT_CRYSTAL,
                VABlocks.COTTON,
                VABlocks.CORN_CROP,
                VABlocks.TOMATO,
                VABlocks.CABBAGE,
                VABlocks.GLOWING_SILK,
                VABlocks.FRAYED_SILK,
                VABlocks.TALL_GREENCAP_MUSHROOMS,
                VABlocks.GREENCAP_MUSHROOM,
                VABlocks.POTTED_GREENCAP_MUSHROOM,
                VABlocks.SMALL_SPRING_LOTUS,
                VABlocks.POTTED_SMALL_SPRING_LOTUS,
                VABlocks.SPRING_LOTUS,
                VABlocks.SOUL_SPROUT,
                VABlocks.POTTED_SOUL_SPROUT,
                VABlocks.WISDOM_BERRY
        );

        BlockRenderLayerMap.putBlocks(class_11515.field_60924,
                VABlocks.SOULBLOOM_LEAVES,
                VABlocks.SOULBLOOM_HEDGE,
                VABlocks.WITHERED_LEAVES,
                VABlocks.WITHERED_HEDGE,
                VABlocks.OAK_HEDGE,
                VABlocks.SPRUCE_HEDGE,
                VABlocks.BIRCH_HEDGE,
                VABlocks.JUNGLE_HEDGE,
                VABlocks.ACACIA_HEDGE,
                VABlocks.DARK_OAK_HEDGE,
                VABlocks.PALE_OAK_HEDGE,
                VABlocks.MANGROVE_HEDGE,
                VABlocks.CHERRY_HEDGE,
                VABlocks.AZALEA_HEDGE,
                VABlocks.FLOWERING_AZALEA_HEDGE,
                VABlocks.STEEL_DOOR,
                VABlocks.EXPOSED_STEEL_DOOR,
                VABlocks.WEATHERED_STEEL_DOOR,
                VABlocks.OXIDIZED_STEEL_DOOR,
                VABlocks.WAXED_STEEL_DOOR,
                VABlocks.WAXED_EXPOSED_STEEL_DOOR,
                VABlocks.WAXED_WEATHERED_STEEL_DOOR,
                VABlocks.WAXED_OXIDIZED_STEEL_DOOR,
                VABlocks.STEEL_TRAPDOOR,
                VABlocks.EXPOSED_STEEL_TRAPDOOR,
                VABlocks.WEATHERED_STEEL_TRAPDOOR,
                VABlocks.OXIDIZED_STEEL_TRAPDOOR,
                VABlocks.WAXED_STEEL_TRAPDOOR,
                VABlocks.WAXED_EXPOSED_STEEL_TRAPDOOR,
                VABlocks.WAXED_WEATHERED_STEEL_TRAPDOOR,
                VABlocks.WAXED_OXIDIZED_STEEL_TRAPDOOR,
                VABlocks.STEEL_TRAPDOOR,
                VABlocks.REDSTONE_BRIDGE,
                VABlocks.STEEL_GRATE,
                VABlocks.EXPOSED_STEEL_GRATE,
                VABlocks.WEATHERED_STEEL_GRATE,
                VABlocks.OXIDIZED_STEEL_GRATE,
                VABlocks.WAXED_STEEL_GRATE,
                VABlocks.WAXED_EXPOSED_STEEL_GRATE,
                VABlocks.WAXED_WEATHERED_STEEL_GRATE,
                VABlocks.WAXED_OXIDIZED_STEEL_GRATE
        );
    }

    private static void initEntityRenderers() {
        EntityModelLayerRegistry.registerModelLayer(LUMWASP_LAYER, LumwaspEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SPECTRE_LAYER, SpectreEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(PLAYER_PROJECTION_LAYER, PlayerProjectionEntityModel::getTexturedModelData);
        EntityModelLayerRegistry.registerModelLayer(SOULBLOOM_BOAT, class_554::method_31985);
        EntityModelLayerRegistry.registerModelLayer(SOULBLOOM_CHEST_BOAT, class_554::method_62066);
        EntityRendererRegistry.register(VAEntityType.CLIMBING_ROPE, ClimbingRopeEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.STEEL_BOMB, class_953::new);
        EntityRendererRegistry.register(VAEntityType.TOMATO, class_953::new);
        EntityRendererRegistry.register(VAEntityType.ACID_SPIT, AcidSpitEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.SPECTRAL_BOLT, SpectralBoltEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.LUMWASP, LumwaspEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.SPECTRE, SpectreEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.SALINE, SalineEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.PLAYER_PROJECTION, PlayerProjectionEntityRenderer::new);
        EntityRendererRegistry.register(VAEntityType.LIGHTNING_BOTTLE, class_953::new);
        EntityRendererRegistry.register(VAEntityType.SOULBLOOM_BOAT, context -> new class_881(context, SOULBLOOM_BOAT));
        EntityRendererRegistry.register(VAEntityType.SOULBLOOM_CHEST_BOAT, context -> new class_881(context, SOULBLOOM_CHEST_BOAT));
    }

    private static void initBlockEntityRenderers() {

        class_5616.method_32144( VABlockEntityType.MINI_PORTAL, MiniPortalBlockEntityRenderer::new );

        class_5616.method_32144( VABlockEntityType.CUSTOM_SIGN, class_837::new );
        class_5616.method_32144( VABlockEntityType.CUSTOM_HANGING_SIGN, class_7761::new );
        class_5616.method_32144( VABlockEntityType.CUSTOM_BED, class_825::new );
        class_5616.method_32144( VABlockEntityType.CUSTOM_SHULKER_BOX, class_834::new );
        class_5616.method_32144( VABlockEntityType.CUSTOM_BANNER, class_823::new );

        class_4722.field_21712.put(VABlocks.SOULBLOOM_WOODTYPE, new class_4730(class_4722.field_21708, idOf("entity/signs/soulbloom")));
        class_4722.field_40515.put(VABlocks.SOULBLOOM_WOODTYPE, new class_4730(class_4722.field_21708, idOf("entity/signs/hanging/soulbloom")));
        class_4722.field_21712.put(VABlocks.WITHERED_WOODTYPE, new class_4730(class_4722.field_21708, idOf("entity/signs/withered")));
        class_4722.field_40515.put(VABlocks.WITHERED_WOODTYPE, new class_4730(class_4722.field_21708, idOf("entity/signs/hanging/withered")));

    }

    private static void  initFluidRenderers() {
        FluidRenderHandlerRegistry.INSTANCE.register(VAFluids.ACID, VAFluids.FLOWING_ACID, new SimpleFluidRenderHandler(
                class_2960.method_60654("minecraft:block/water_still"),
                class_2960.method_60654("minecraft:block/water_flow"),
                0x00e076
        ));
    }

    private static void initColorProviders() {
        ColorProviderRegistry.BLOCK.register( ((state, world, pos, tintIndex) -> world != null ? class_1163.method_4966(world, pos) : class_1926.field_55217),
                VABlocks.OAK_HEDGE,
                VABlocks.JUNGLE_HEDGE,
                VABlocks.ACACIA_HEDGE,
                VABlocks.DARK_OAK_HEDGE,
                VABlocks.MANGROVE_HEDGE
        );
        ColorProviderRegistry.BLOCK.register( (state, world, pos, tintIndex) -> class_1926.field_55215, VABlocks.SPRUCE_HEDGE);
        ColorProviderRegistry.BLOCK.register( (state, world, pos, tintIndex) -> class_1926.field_55216, VABlocks.BIRCH_HEDGE);
        ColorProviderRegistry.BLOCK.register( (state, world, pos, tintIndex) -> 0x00e076, VABlocks.ACID);
        ColorProviderRegistry.BLOCK.register( (state, world, pos, tintIndex) -> tintIndex <= 0 ? -1 : class_2457.method_10487(state.method_11654(RedstoneBridgeBlock.POWER)), VABlocks.REDSTONE_BRIDGE);

        ColorProviderRegistry.BLOCK.register((state, world, pos, tintIndex) -> {
            if (tintIndex != 0) {
                return world != null && pos != null ? class_1163.method_4962(world, pos) : class_1933.method_49724();
            } else {
                return -1;
            }
        }, VABlocks.BLUE_PETALS);
    }

    private static void initFogModifiers() {
        class_758.field_60586.addFirst(new PlayerProjectionPhasingFogModifier());
    }
}
