package com.github.suninvr.virtualadditions.client.particle;

import com.github.suninvr.virtualadditions.particle.ColorfulPowerParticleEffect;
import net.minecraft.class_2400;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_8982;
import org.jetbrains.annotations.Nullable;

public class PowerParticleFactory implements class_707<class_2400> {
    class_4002 spriteProvider;

    public PowerParticleFactory(class_4002 spriteProvider) {
        this.spriteProvider = spriteProvider;
    }

    @Override
    public @Nullable class_703 createParticle(class_2400 parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
        return new class_8982(world, x, y, z, 0, 0, 0, 1.5f, this.spriteProvider);
    }

    public static class Color implements class_707<ColorfulPowerParticleEffect> {
        class_4002 spriteProvider;

        public Color(class_4002 spriteProvider) {
            this.spriteProvider = spriteProvider;
        }

        @Override
        public @Nullable class_703 createParticle(ColorfulPowerParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, class_5819 random) {
            return new ColorfulPowerParticle(world, x, y, z, 0, 0, 0, 1.5f, parameters.getColor(), this.spriteProvider);
        }
    }
}
