package com.github.suninvr.virtualadditions.client.render.entity;

import com.github.suninvr.virtualadditions.entity.LumwaspEntity;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.client.model.*;
import java.util.Optional;

// Made with Blockbench 4.5.2
// Exported for Minecraft version 1.17+ for Yarn
// Paste this class into your mod and generate all required imports
@SuppressWarnings({"FieldCanBeLocal", "unused"})
public class LumwaspEntityModel<T extends LumwaspEntity> extends class_583<LumwaspEntityRenderState> {
    private final class_630 body;
    private final class_630 head;
    private final class_630 thorax;
    private final class_630 abdomen;
    private final class_630 left_wing;
    private final class_630 right_wing;
    private final class_630 left_mandible;
    private final class_630 right_mandible;
    private final class_630 front_left_leg;
    private final class_630 middle_left_leg;
    private final class_630 back_left_leg;
    private final class_630 front_right_leg;
    private final class_630 middle_right_leg;
    private final class_630 back_right_leg;

    public LumwaspEntityModel(class_630 root) {
        super(root);
        this.body = root.method_32086("body");
        this.head = body.method_32086("head");
        this.thorax = body.method_32086("thorax_r1");
        this.abdomen = body.method_32086("abdomen_r1");
        this.left_wing = body.method_32086("wing_l_r1");
        this.right_wing = body.method_32086("wing_r_r1");
        this.left_mandible = head.method_32086("mandible_l_r1");
        this.right_mandible = head.method_32086("mandible_r_r1");
        this.front_left_leg = body.method_32086("leg_lf_r1");
        this.middle_left_leg = body.method_32086("leg_lm_r1");
        this.back_left_leg = body.method_32086("leg_lb_r1");
        this.front_right_leg = body.method_32086("leg_rf_r1");
        this.middle_right_leg = body.method_32086("leg_rm_r1");
        this.back_right_leg = body.method_32086("leg_rb_r1");
    }
    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();
        class_5610 body = modelPartData.method_32117("body", class_5606.method_32108(), class_5603.method_32090(0.0F, 16.0F, -4.0F));

        class_5610 leg_rb_r1 = body.method_32117("leg_rb_r1", class_5606.method_32108().method_32101(28, 26).method_32098(-13.0F, -1.0F, -1.0F, 14.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(-5.0F, 2.0F, 5.0F, -0.3842F, 1.0012F, -0.4476F));

        class_5610 leg_rm_r1 = body.method_32117("leg_rm_r1", class_5606.method_32108().method_32101(36, 4).method_32098(-9.0F, -1.0F, -1.0F, 10.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(-5.0F, 2.0F, 2.0F, -0.2145F, 0.5293F, -0.4074F));

        class_5610 leg_rf_r1 = body.method_32117("leg_rf_r1", class_5606.method_32108().method_32101(36, 8).method_32098(-9.0F, -1.0F, -1.0F, 10.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(-5.0F, 2.0F, -1.0F, 0.1582F, -0.4084F, -0.3819F));

        class_5610 leg_lb_r1 = body.method_32117("leg_lb_r1", class_5606.method_32108().method_32101(36, 0).method_32098(-1.0F, -1.0F, -1.0F, 14.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(3.0F, 2.0F, 5.0F, -0.3842F, -1.0012F, 0.4476F));

        class_5610 leg_lm_r1 = body.method_32117("leg_lm_r1", class_5606.method_32108().method_32101(0, 38).method_32098(-1.0F, -1.0F, -1.0F, 10.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(3.0F, 2.0F, 2.0F, -0.2145F, -0.5293F, 0.4074F));

        class_5610 leg_lf_r1 = body.method_32117("leg_lf_r1", class_5606.method_32108().method_32101(0, 42).method_32098(-1.0F, -1.0F, -1.0F, 10.0F, 2.0F, 2.0F, new class_5605(0.0F)), class_5603.method_32091(3.0F, 2.0F, -1.0F, 0.1582F, 0.4084F, 0.3819F));

        class_5610 wing_r_r1 = body.method_32117("wing_r_r1", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, 0.0F, -1.0F, 4.0F, 0.0F, 20.0F, new class_5605(0.0F)), class_5603.method_32091(-5.0F, -2.0F, -1.0F, 0.0873F, 0.1745F, -1.3963F));

        class_5610 wing_l_r1 = body.method_32117("wing_l_r1", class_5606.method_32108().method_32101(8, 0).method_32098(0.0F, 0.0F, -1.0F, 4.0F, 0.0F, 20.0F, new class_5605(0.0F)), class_5603.method_32091(3.0F, -2.0F, -1.0F, 0.0873F, -0.1745F, 1.3963F));

        class_5610 abdomen_r1 = body.method_32117("abdomen_r1", class_5606.method_32108().method_32101(28, 12).method_32098(-5.0F, -7.0F, -5.0F, 8.0F, 6.0F, 8.0F, new class_5605(0.0F)), class_5603.method_32091(0.0F, 3.0F, 3.0F, 0.2618F, 0.0F, 0.0F));

        class_5610 thorax_r1 = body.method_32117("thorax_r1", class_5606.method_32108().method_32101(0, 20).method_32098(-4.0F, -5.0F, -1.0F, 8.0F, 6.0F, 12.0F, new class_5605(0.0F)), class_5603.method_32091(-1.0F, 1.0F, 6.0F, -0.2618F, 0.0F, 0.0F));

        class_5610 head = body.method_32117("head", class_5606.method_32108().method_32101(34, 32).method_32098(-5.0F, -3.0F, -5.0F, 8.0F, 5.0F, 6.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 0.0F, -4.0F));

        class_5610 mandible_r_r1 = head.method_32117("mandible_r_r1", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, 0.0F, 0.0F, 4.0F, 4.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32091(-1.0F, 1.0F, -5.0F, 0.2317F, 0.3405F, 0.0786F));

        class_5610 mandible_l_r1 = head.method_32117("mandible_l_r1", class_5606.method_32108().method_32101(0, 0).method_32098(-4.0F, 0.0F, 0.0F, 4.0F, 4.0F, 0.0F, new class_5605(0.0F)), class_5603.method_32091(-1.0F, 1.0F, -5.0F, 2.9099F, 0.3405F, 3.063F));

        class_5610 antenna_r_r1 = head.method_32117("antenna_r_r1", class_5606.method_32108().method_32101(34, 34).method_32098(0.0F, -3.0F, -10.0F, 0.0F, 3.0F, 10.0F, new class_5605(0.0F)), class_5603.method_32091(-3.0F, -3.0F, -2.0F, 0.0F, 0.3491F, 0.0F));

        class_5610 antenna_l_r1 = head.method_32117("antenna_l_r1", class_5606.method_32108().method_32101(34, 34).method_32098(0.0F, -3.0F, -10.0F, 0.0F, 3.0F, 10.0F, new class_5605(0.0F)), class_5603.method_32091(1.0F, -3.0F, -2.0F, 0.0F, -0.3491F, 0.0F));
        return class_5607.method_32110(modelData, 128, 128);
    }

    @Override
    public void setAngles(LumwaspEntityRenderState state) {
        float animationProgress = state.field_53328;
        float headYaw = state.field_53447;
        float headPitch = state.field_53448;
        boolean inAir = state.inAir;
        float limbAngle = state.field_53450 * 0.6662F;
        float limbDistance = state.field_53451;

        float u = (float) (Math.sin(animationProgress / 19) / 24);
        float v = (float) (Math.sin(animationProgress / 16) / 12);
        float w = (float) (Math.sin(animationProgress / 22) / 24);
        float x = (float) (Math.sin(animationProgress / 28) / 20);
        this.head.field_3675 = headYaw * 0.017453292F;
        this.head.field_3654 = headPitch  * 0.017453292F;
        this.thorax.field_3675 = u;
        if (inAir) {
            this.left_wing.field_3654 = (float) (1.0873F + Math.sin(animationProgress * 1.5) * 0.3);
            this.left_wing.field_3675 = -0.1745F;
            this.left_wing.field_3674 = 0.8963F;
            this.right_wing.field_3654 = (float) (1.0873F + Math.sin(animationProgress * 1.5) * 0.3);
            this.right_wing.field_3675 = 0.1745F;
            this.right_wing.field_3674 = -0.8963F;
            this.thorax.field_3654 = v;
            this.front_left_leg.field_3675 = -0.6084F + w;
            this.front_left_leg.field_3674 = 1.2819F + x;
            this.front_right_leg.field_3675 = 0.6084F + w;
            this.front_right_leg.field_3674 = -1.2819F + x;
            this.middle_left_leg.field_3675 = -0.8584F + w;
            this.middle_left_leg.field_3674 = 0.6819F + x;
            this.middle_right_leg.field_3675 = 0.8584F + w;
            this.middle_right_leg.field_3674 = -0.6819F + x;
            this.back_left_leg.field_3675 = -1.0012F + w;
            this.back_left_leg.field_3674 = 0.6819F + x;
            this.back_right_leg.field_3675 = 1.0012F + w;
            this.back_right_leg.field_3674 = -0.6819F + x;
        } else {
            this.left_wing.field_3654 = 0.0873F;
            this.left_wing.field_3675 = -0.1745F;
            this.left_wing.field_3674 = 1.3963F;
            this.right_wing.field_3654 = 0.0873F;
            this.right_wing.field_3675 = 0.1745F;
            this.right_wing.field_3674 = -1.3963F;
            this.thorax.field_3654 = v;

            this.front_left_leg.field_3675 = 0.4084F;
            this.front_right_leg.field_3675 = -0.4084F;
            this.middle_left_leg.field_3675 = -0.5293F;
            this.middle_right_leg.field_3675 = 0.5293F;
            this.back_left_leg.field_3675 = -1.0012F;
            this.back_right_leg.field_3675 = 1.0012F;
            this.front_left_leg.field_3674 = 0.3819F;
            this.front_right_leg.field_3674 = -0.3819F;
            this.middle_left_leg.field_3674 = 0.4074F;
            this.middle_right_leg.field_3674 = -0.4074F;
            this.back_left_leg.field_3674 = 0.4476F;
            this.back_right_leg.field_3674 = -0.4476F;

            float i = -(class_3532.method_15362(limbAngle * 0.6662F * 2.0F + 0.0F) * 0.4F) * limbDistance;
            float j = -(class_3532.method_15362(limbAngle * 0.6662F * 2.0F + 3.1415927F) * 0.4F) * limbDistance;
            float l = -(class_3532.method_15362(limbAngle * 0.6662F * 2.0F + 4.712389F) * 0.4F) * limbDistance;
            float m = Math.abs(class_3532.method_15374(limbAngle * 0.6662F + 0.0F) * 0.4F) * limbDistance;
            float n = Math.abs(class_3532.method_15374(limbAngle * 0.6662F + 3.1415927F) * 0.4F) * limbDistance;
            float p = Math.abs(class_3532.method_15374(limbAngle * 0.6662F + 4.712389F) * 0.4F) * limbDistance;

            this.front_left_leg.field_3675 -= p;
            this.front_right_leg.field_3675 += p;
            this.middle_left_leg.field_3675 -= j;
            this.middle_right_leg.field_3675 += j;
            this.back_left_leg.field_3675 -= i;
            this.back_right_leg.field_3675 += i;
            this.front_left_leg.field_3674 -= l;
            this.front_right_leg.field_3674 += l;
            this.middle_left_leg.field_3674 -= n;
            this.middle_right_leg.field_3674 += n;
            this.back_left_leg.field_3674 -= m;
            this.back_right_leg.field_3674 += m;
        }
    }
}

