package com.github.suninvr.virtualadditions.client.render.entity;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.client.VARenderLayers;
import com.github.suninvr.virtualadditions.client.VARenderers;
import com.github.suninvr.virtualadditions.entity.PlayerProjectionEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11901;
import net.minecraft.class_12075;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_922;
import org.jetbrains.annotations.Nullable;

@SuppressWarnings({"unchecked", "rawtypes"})
public class PlayerProjectionEntityRenderer<T extends PlayerProjectionEntity> extends class_922<PlayerProjectionEntity, PlayerProjectionEntityRenderState, PlayerProjectionEntityModel> {
    private static final class_2960 GLOW_TEXTURE_ID = VirtualAdditions.idOf("textures/entity/player_projection/glow.png");

    public PlayerProjectionEntityRenderer(class_5617.class_5618 context) {
        super(context, new PlayerProjectionEntityModel(context.method_32167(VARenderers.PLAYER_PROJECTION_LAYER)), 0.25F);
    }

    @Override
    public void render(PlayerProjectionEntityRenderState livingEntityRenderState, class_4587 matrixStack, class_11659 orderedRenderCommandQueue, class_12075 cameraRenderState) {
        super.method_4054(livingEntityRenderState, matrixStack, orderedRenderCommandQueue, cameraRenderState);
        class_1921 glowRenderLayer = this.getGlowRenderLayer();
        if (glowRenderLayer != null) {
            orderedRenderCommandQueue.method_73483(matrixStack, glowRenderLayer, (matricesEntry, vertexConsumer) -> {
                matricesEntry.method_67796(0, 0.25f, 0);
                matricesEntry.method_67798(cameraRenderState.field_63081);
                matricesEntry.method_67800(2.0F, 2.0F, 2.0F);
                produceGlowVertex(vertexConsumer, matricesEntry, 255, 0, 0, 0, 1);
                produceGlowVertex(vertexConsumer, matricesEntry, 255, 1, 0, 1, 1);
                produceGlowVertex(vertexConsumer, matricesEntry, 255, 1, 1, 1, 0);
                produceGlowVertex(vertexConsumer, matricesEntry, 255, 0, 1, 0, 0);
            });
        }
    }

    private static void produceGlowVertex(class_4588 vertexConsumer, class_4587.class_4665 matrix, int light, float x, int z, int textureU, int textureV) {
        vertexConsumer.method_56824(matrix, x - 0.5F, (float)z - 0.5F, 0.0F).method_39415(-1).method_22913((float)textureU, (float)textureV).method_22922(class_4608.field_21444).method_60803(light).method_60831(matrix, 0.0F, 1.0F, 0.0F);
    }

    @Override
    public void updateRenderState(PlayerProjectionEntity livingEntity, PlayerProjectionEntityRenderState livingEntityRenderState, float f) {
        super.method_62355(livingEntity, livingEntityRenderState, f);
        if (livingEntity.getPlayer() instanceof class_11901 playerLike) {
            livingEntityRenderState.skinTextures = playerLike.method_52814();
            class_310 minecraftClient = class_310.method_1551();
            livingEntityRenderState.field_53461 = livingEntity.getPlayer().method_5767() && livingEntity.getPlayer().method_5756(minecraftClient.field_1724);
            livingEntityRenderState.hatVisible = livingEntity.getPlayer().method_74091(class_1664.field_7563);
        }
    }

    @Override
    protected @Nullable class_2561 getDisplayName(PlayerProjectionEntity entity) {
        return super.method_62426(entity);
    }

    @Override
    protected boolean hasLabel(PlayerProjectionEntity entity, double d) {
        return super.method_4055(entity, d) && (entity.method_5733() || entity.method_16914() && entity == this.field_4676.field_4678);
    }

    @Override
    public class_2960 getTexture(PlayerProjectionEntityRenderState state) {
        return state.skinTextures.comp_1626().comp_3627();
    }

    @Override
    protected @Nullable class_1921 getRenderLayer(PlayerProjectionEntityRenderState state, boolean showBody, boolean translucent, boolean showOutline) {
        class_2960 identifier = this.getTexture(state);
        return class_1921.method_24294(identifier, true);
    }

    protected @Nullable class_1921 getGlowRenderLayer() {
        return VARenderLayers.getMiniPortal(GLOW_TEXTURE_ID, true);
    }

    @Override
    protected int getBlockLight(PlayerProjectionEntity entity, class_2338 pos) {
        return 15;
    }

    @Override
    public PlayerProjectionEntityRenderState method_55269() {
        return new PlayerProjectionEntityRenderState();
    }
}
