package com.github.suninvr.virtualadditions.client.screen;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.network.EntanglementDriveC2SPayload;
import com.github.suninvr.virtualadditions.screen.EntanglementDriveScreenHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_10799;
import net.minecraft.class_11907;
import net.minecraft.class_11910;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import java.util.UUID;

public class EntanglementDriveScreen extends class_465<EntanglementDriveScreenHandler> {
    public static final class_2960 BACKGROUND_TEXTURE = VirtualAdditions.idOf("textures/gui/container/entanglement_drive.png");
    private static final class_2561 SLOT_HINT = class_2561.method_43471("container.virtual_additions.entanglement_drive.select_slot_hint");
    private static final class_2561 PAYMENT_SLOT_HINT = class_2561.method_43471("container.virtual_additions.entanglement_drive.payment_slot_hint");
    private float mouseX, mouseY;
    private final UUID playerId;

    public EntanglementDriveScreen(EntanglementDriveScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.playerId = inventory.field_7546.method_5667();
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        ConfirmButtonWidget confirm = new ConfirmButtonWidget(this.field_2776 + 141, this.field_2800 + 29);
        this.method_37063(confirm);
        this.field_25267 = 80;
    }

    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        //RenderSystem.setShaderTexture(0, BACKGROUND_TEXTURE);
        int i = this.field_2776;
        int j = this.field_2800;
        context.method_25290(class_10799.field_56883, field_2801, i, j, 0, 0, this.field_2792, this.field_2779, 256, 256);
        if (this.field_2797.isSelectingSlot() && this.field_2797.isSlotSelected()) {
            class_1735 slot = this.field_2797.getSelectedSlot();
            context.method_25290(class_10799.field_56883, field_2801, i + slot.field_7873 - 1, j + slot.field_7872 - 1, 196, 0, 18, 18, 256, 256);
        }
        if (this.field_2797.isActive() && this.field_2797.isSamePlayer()) {
            class_1735 slot = this.field_2797.getActiveSlot();
            context.method_25290(class_10799.field_56883, field_2801, i + slot.field_7873 - 1, j + slot.field_7872 - 1, 178, 0, 18, 18, 256, 256);
        }
        if (this.field_22787 != null && this.field_22787.field_1724 != null) {
            class_490.method_2486(context, i + 26, j + 8, i + 75, j + 78, 30, 0.0625F, this.mouseX, this.mouseY, this.field_22787.field_1724);
        }
    }

    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 4210752, false);
    }

    @Override
    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        super.method_2383(slot, slotId, button, actionType);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
        this.mouseX = (float)mouseX;
        this.mouseY = (float)mouseY;
    }

    @Override
    protected void method_2380(class_332 context, int x, int y) {
        int i = 0;
        boolean bl = this.field_2787 != null;
        if (bl) i = this.field_2787.field_7874;

        if ( bl && i == 41 && !this.field_2797.isSelectingSlot() ) {
            context.method_51438(this.field_22793, PAYMENT_SLOT_HINT, x, y);
        } else if ( bl && i != 41 && this.field_2797.method_34255().method_7960() && this.field_2797.isSelectingSlot() ) {
            context.method_51438(this.field_22793, SLOT_HINT, x, y);
        } else {
            super.method_2380(context, x, y);
        }
    }

    private class ConfirmButtonWidget extends class_4264 {
        private static final class_7919 CONFIRM_BUTTON_TOOLTIP = class_7919.method_47407(class_2561.method_43471("container.virtual_additions.entanglement_drive.confirm_button"));


        protected ConfirmButtonWidget(int x, int y) {
            super(x, y, 18, 18, class_2561.method_43473());
        }

        @Override
        public void method_25306(class_11907 input) {
            ClientPlayNetworking.send(new EntanglementDriveC2SPayload(EntanglementDriveScreen.this.field_2797.getSelectedSlotIndex(), EntanglementDriveScreen.this.playerId));
            EntanglementDriveScreen.this.field_2797.decrementPaymentSlot();
        }

        public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            //RenderSystem.setShaderTexture(0, BACKGROUND_TEXTURE);

            if (this.isDisabled()) this.method_47400(null);
            else this.method_47400(CONFIRM_BUTTON_TOOLTIP);

            int j = 178;
            if (this.isDisabled()) {
                j += this.field_22758 * 2;
            } else if (this.method_25367()) {
                j += this.field_22758;
            }

            context.method_25290(class_10799.field_56883, field_2801, this.method_46426(), this.method_46427(), j, 18, this.field_22758, this.field_22759, 256, 256);
        }

        @Override
        protected boolean method_25351(class_11910 input) {
            return super.method_25351(input) && !this.isDisabled() ;
        }

        public boolean isDisabled() {
            return !(EntanglementDriveScreen.this.field_2797.isSelectingSlot() && EntanglementDriveScreen.this.field_2797.isSlotSelected());
        }

        @Override
        protected void method_47399(class_6382 builder) {

        }
    }
}
