package com.github.suninvr.virtualadditions.client.toast;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5481;

public class RemoteNotifierToast implements class_368 {
    private static final class_2960 TEXTURE = VirtualAdditions.idOf("toast/remote_notifier");
    public static final int DEFAULT_DURATION_MS = 5000;
    private final class_2561 text;
    private final class_1799 stack;
    private int height;
    private class_368.class_369 visibility = class_368.class_369.field_2209;

    public RemoteNotifierToast(class_1799 displayStack, class_2561 text) {
        this.stack = displayStack;
        this.text = text;
        this.height = 32;
    }

    @Override
    public class_369 method_61988() {
        return this.visibility;
    }

    @Override
    public void method_61989(class_374 manager, long time) {
        this.visibility = (double)time >= 5000.0 * manager.method_48221() ? class_368.class_369.field_2209 : class_368.class_369.field_2210;
    }

    @Override
    public void method_1986(class_332 context, class_327 textRenderer, long startTime) {
        context.method_52706(class_10799.field_56883, TEXTURE, 0, 0, this.method_29049(), this.method_29050());
        if (this.text != null) {
            List<class_5481> lines = textRenderer.method_1728(text, this.stack.method_7960() ? 146 : 125);
            int textX = this.stack.method_7960() ? 8 : 30;
            if (!this.stack.method_7960()) {
                context.method_51445(this.stack, 8, 8);
            }
            if (lines.size() > 2) {
                this.height = 32 + (12 * (lines.size() - 2));
            }
            int offset = 0;
            for (class_5481 line : lines) {
                context.method_51430(textRenderer, line, textX, lines.size() > 1 ? 6 + offset : 12, 0xFFFF33, true);
                offset += 12;
            }
        }

    }

    @Override
    public int method_29050() {
        return this.height;
    }
}
