package com.github.suninvr.virtualadditions.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.class_5699;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9331;

public record ExplosiveContentComponent(Optional<Integer> explosionStrength, Optional<Integer> fuseLength, Optional<Boolean> destroysBlocks) {
    public static final ExplosiveContentComponent DEFAULT = new ExplosiveContentComponent(Optional.of(2), Optional.of(200), Optional.of(true));
    public static final ExplosiveContentComponent KEEP_BLOCKS = new ExplosiveContentComponent(Optional.of(2), Optional.of(200), Optional.of(false));
    public static final Codec<ExplosiveContentComponent> CODEC;
    public static final class_9139<class_9129, ExplosiveContentComponent> PACKET_CODEC;

    public int getExplosionStrength(){
        return this.explosionStrength.orElse(2);
    }

    public int getFuseLength(){
        return this.fuseLength.orElse(200);
    }

    public boolean shouldDestroyBlocks(){
        return this.destroysBlocks.orElse(true);
    }

    public static class_9331.class_9332<ExplosiveContentComponent> setCodecs(class_9331.class_9332<ExplosiveContentComponent> builder) {
        return builder.method_57881(CODEC).method_57882(PACKET_CODEC);
    }

    static {
        CODEC = RecordCodecBuilder.create(instance -> {
            return instance.group(
                    class_5699.field_33441.optionalFieldOf("explosion_strength").forGetter(ExplosiveContentComponent::explosionStrength),
                    class_5699.field_33441.optionalFieldOf("fuse_length").forGetter(ExplosiveContentComponent::fuseLength),
                    Codec.BOOL.optionalFieldOf("destroys_blocks").forGetter(c -> c.destroysBlocks)
            ).apply(instance, ExplosiveContentComponent::new);
        });
        PACKET_CODEC = class_9139.method_56436(
                class_9135.field_49675.method_56433(class_9135::method_56382), ExplosiveContentComponent::explosionStrength,
                class_9135.field_49675.method_56433(class_9135::method_56382), ExplosiveContentComponent::fuseLength,
                class_9135.field_48547.method_56433(class_9135::method_56382), c -> c.destroysBlocks,
                ExplosiveContentComponent::new
        );
    }
}
