package com.github.suninvr.virtualadditions.datagen;

import com.github.suninvr.virtualadditions.registry.VAEntityType;
import com.github.suninvr.virtualadditions.registry.VAItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricEntityLootTableProvider;
import net.minecraft.class_125;
import net.minecraft.class_1299;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2048;
import net.minecraft.class_2073;
import net.minecraft.class_215;
import net.minecraft.class_221;
import net.minecraft.class_225;
import net.minecraft.class_3735;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8548;
import net.minecraft.class_8551;
import net.minecraft.loot.condition.*;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;

public class VAEntityLootTableProvider {

    public static FabricDataGenerator.Pack.RegistryDependentFactory<?> base() {
        return BaseProvider::new;
    }
    public static FabricDataGenerator.Pack.RegistryDependentFactory<?> preview() {
        return PreviewProvider::new;
    }
    public static FabricDataGenerator.Pack.RegistryDependentFactory<?> enhancements() {
        return EnhancementsProvider::new;
    }

    protected static class BaseProvider extends Provider {

        protected BaseProvider(FabricDataOutput output, @NotNull CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        @Override
        public void method_10400() {
            class_52.class_53 lumwaspBuilder = class_52.method_324()
                    .method_336(class_55.method_347().method_351(class_77.method_411(VAItems.LUMWASP_MANDIBLE)
                            .method_438(class_141.method_621(class_5662.method_32462(-1.0F, 1.0F)))
                            .method_438(class_125.method_547(this.field_51846, class_5662.method_32462(0.0F, 1.0F)))
                    ))
                    .method_336(class_55.method_347().method_351(class_77.method_411(VAItems.SILK_THREAD)
                            .method_438(class_141.method_621(class_5662.method_32462(-1.0F, 2.0F)))
                            .method_438(class_125.method_547(this.field_51846, class_5662.method_32462(0.0F, 1.0F)))
                    ))
                    .method_336(class_55.method_347().method_351(class_77.method_411(VAItems.EXOSKELETON_ARMOR_TRIM_SMITHING_TEMPLATE)
                            .method_421(class_225.method_953(this.field_51846, 0.005F, 0.003F))
                    ));
            this.method_46029(VAEntityType.LUMWASP, lumwaspBuilder);

            class_52.class_53 salineBuilder = class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_351(class_77.method_411(class_1802.field_8511)
                                .method_438(class_141.method_621(class_5662.method_32462(0.0F, 2.0F)))
                                .method_438(class_125.method_547(this.field_51846, class_5662.method_32462(0.0F, 1.0F))))
                            .method_351(class_77.method_411(VAItems.ROCK_SALT)
                                .method_438(class_141.method_621(class_5662.method_32462(0.0F, 2.0F)))
                                .method_438(class_125.method_547(this.field_51846, class_5662.method_32462(0.0F, 1.0F))))
                    )
                    .method_336(class_55.method_347()
                            .method_351(class_77.method_411(VAItems.STEEL_INGOT)
                                .method_421(class_221.method_939())
                                .method_421(class_225.method_953(this.field_51846, 0.025F, 0.01F))
                            )
                    );
            this.method_46029(VAEntityType.SALINE, salineBuilder);

            class_52.class_53 spectreBuilder = class_52.method_324()
                    .method_336(class_55.method_347()
                            .method_351(class_77.method_411(VAItems.SPECTRAL_POWDER)
                                .method_438(class_141.method_621(class_5662.method_32462(-1.0F, 1.0F)))
                                .method_438(class_125.method_547(this.field_51846, class_5662.method_32462(0.0F, 1.0F))))
                    );
            this.method_46029(VAEntityType.SPECTRE, spectreBuilder);
        }
    }

    protected static class PreviewProvider extends Provider {

        protected PreviewProvider(FabricDataOutput output, @NotNull CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        @Override
        public void method_10400() {

        }
    }

    protected static class EnhancementsProvider extends Provider {

        protected EnhancementsProvider(FabricDataOutput output, @NotNull CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        @Override
        public void method_10400() {
            class_7871<class_1792> registryEntryLookup = field_51846.method_46762(class_7924.field_41197);

            class_52.class_53 witherSkeletonBuilder = class_52.method_324()
                    .method_336(class_55.method_347().method_351(commonDrop(class_1802.field_8713, -1, 1)))
                    .method_336(class_55.method_347().method_351(commonDrop(class_1802.field_8606, 0, 1)))
                    .method_336(class_55.method_347().method_351(class_77.method_411(class_1802.field_8791)
                            .method_421(class_221.method_939())
                            .method_421(class_8551.method_51727(
                                    class_225.method_953(field_51846, 0.025F, 0.01F),
                                    class_8548.method_51723(
                                            class_225.method_953(field_51846, 0.4F, 0.2F),
                                            class_215.method_917(class_47.class_50.field_935, class_2048.class_2049.method_8916().method_53141(class_3735.class_5278.method_27965().method_27966(class_2073.class_2074.method_8973().method_8977(registryEntryLookup, class_1802.field_22027))))
                                    )
                            ))

                    ));

            this.method_46029(class_1299.field_6076, witherSkeletonBuilder);
        }
    }

    protected static abstract class Provider extends FabricEntityLootTableProvider {
        protected Provider(FabricDataOutput output, @NotNull CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup);
        }

        protected class_77.Builder commonDrop(class_1792 item, int baseMin, int baseMax, int enchantedMin, int enchantedMax) {
            return class_77.method_411(item)
                    .method_438(class_141.method_621(class_5662.method_32462(baseMin, baseMax)))
                    .method_438(class_125.method_547(field_51846, class_5662.method_32462(enchantedMin, enchantedMax)));
        }

        protected class_77.Builder commonDrop(class_1792 item, int baseMin, int baseMax) {
            return commonDrop(item, baseMin, baseMax, 0, 1);
        }
    }

}
