package com.github.suninvr.virtualadditions.datagen;

import com.github.suninvr.virtualadditions.block.SpotlightBlock;
import com.github.suninvr.virtualadditions.client.render.item.CrossbowProjectileTypeProperty;
import com.github.suninvr.virtualadditions.datagen.registry.VAModels;
import com.github.suninvr.virtualadditions.item.interfaces.GildedToolItem;
import com.github.suninvr.virtualadditions.registry.*;
import com.github.suninvr.virtualadditions.registry.collection.ColorfulBlockSet;
import net.fabricmc.fabric.api.client.datagen.v1.provider.FabricModelProvider;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_10191;
import net.minecraft.class_10394;
import net.minecraft.class_10396;
import net.minecraft.class_10398;
import net.minecraft.class_10401;
import net.minecraft.class_10410;
import net.minecraft.class_10439;
import net.minecraft.class_10451;
import net.minecraft.class_10464;
import net.minecraft.class_10468;
import net.minecraft.class_10477;
import net.minecraft.class_10488;
import net.minecraft.class_10490;
import net.minecraft.class_10496;
import net.minecraft.class_10714;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1926;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2741;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4922;
import net.minecraft.class_4925;
import net.minecraft.class_4926;
import net.minecraft.class_4941;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_8054;
import net.minecraft.class_8055;
import net.minecraft.class_807;
import net.minecraft.class_811;
import net.minecraft.class_9334;
import net.minecraft.client.data.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;
import static net.minecraft.class_4915.*;

public class VAModelProvider {

    public static FabricDataGenerator.Pack.Factory<?> base() {
        return BaseProvider::new;
    }

    public static FabricDataGenerator.Pack.Factory<?> enhancements() {
        return EnhancementsProvider::new;
    }

    static class BaseProvider extends Provider {
        public BaseProvider(FabricDataOutput output) {
            super(output);
        }

        @Override
        public void generateBlockStateModels(class_4910 generator) {

            generator.method_25650(VABlocks.PORPHYRY).method_33522(VACollections.PORPHYRY);
            generator.method_25650(VABlocks.SOULBLOOM_PLANKS).method_33522(VACollections.SOULBLOOM);
            generator.method_25650(VABlocks.WITHERED_PLANKS).method_33522(VACollections.WITHERED);
            generator.method_25650(VABlocks.POLISHED_PORPHYRY).method_33522(VACollections.POLISHED_PORPHYRY);
            generator.method_25650(VABlocks.PORPHYRY_BRICKS).method_33522(VACollections.PORPHYRY_BRICKS);
            generator.method_25650(VABlocks.CUT_STEEL).method_33522(VACollections.CUT_STEEL).method_54827(VABlocks.CUT_STEEL, VABlocks.WAXED_CUT_STEEL).method_54827(VABlocks.CHISELED_STEEL, VABlocks.WAXED_CHISELED_STEEL).method_33522(VACollections.WAXED_CUT_STEEL);
            generator.method_25650(VABlocks.EXPOSED_CUT_STEEL).method_33522(VACollections.EXPOSED_CUT_STEEL).method_54827(VABlocks.EXPOSED_CUT_STEEL, VABlocks.WAXED_EXPOSED_CUT_STEEL).method_54827(VABlocks.EXPOSED_CHISELED_STEEL, VABlocks.WAXED_EXPOSED_CHISELED_STEEL).method_33522(VACollections.WAXED_EXPOSED_CUT_STEEL);
            generator.method_25650(VABlocks.WEATHERED_CUT_STEEL).method_33522(VACollections.WEATHERED_CUT_STEEL).method_54827(VABlocks.WEATHERED_CUT_STEEL, VABlocks.WAXED_WEATHERED_CUT_STEEL).method_54827(VABlocks.WEATHERED_CHISELED_STEEL, VABlocks.WAXED_WEATHERED_CHISELED_STEEL).method_33522(VACollections.WAXED_WEATHERED_CUT_STEEL);
            generator.method_25650(VABlocks.OXIDIZED_CUT_STEEL).method_33522(VACollections.OXIDIZED_CUT_STEEL).method_54827(VABlocks.OXIDIZED_CUT_STEEL, VABlocks.WAXED_OXIDIZED_CUT_STEEL).method_54827(VABlocks.OXIDIZED_CHISELED_STEEL, VABlocks.WAXED_OXIDIZED_CHISELED_STEEL).method_33522(VACollections.WAXED_OXIDIZED_CUT_STEEL);
            generator.method_25650(VABlocks.ROCK_SALT_BRICKS).method_33522(VACollections.ROCK_SALT_BRICKS);
            generator.method_25650(VABlocks.COBBLED_HORNFELS).method_33522(VACollections.COBBLED_HORNFELS);
            generator.method_25650(VABlocks.COBBLED_BLUESCHIST).method_33522(VACollections.COBBLED_BLUESCHIST);
            generator.method_25650(VABlocks.BLUESCHIST_BRICKS).method_33522(VACollections.BLUESCHIST_BRICKS);
            generator.method_25650(VABlocks.POLISHED_BLUESCHIST).method_33522(VACollections.POLISHED_BLUESCHIST);
            generator.method_25650(VABlocks.COBBLED_SYENITE).method_33522(VACollections.COBBLED_SYENITE);
            generator.method_25650(VABlocks.SYENITE_BRICKS).method_33522(VACollections.SYENITE_BRICKS);
            generator.method_25650(VABlocks.POLISHED_SYENITE).method_33522(VACollections.POLISHED_SYENITE);

            registerSimpleBlockItems(generator,
                    VABlocks.HORNFELS,
                    VABlocks.POLISHED_HORNFELS,
                    VABlocks.POLISHED_HORNFELS_STAIRS,
                    VABlocks.POLISHED_HORNFELS_SLAB,
                    VABlocks.HORNFELS_TILES,
                    VABlocks.CRACKED_HORNFELS_TILES,
                    VABlocks.HORNFELS_TILE_STAIRS,
                    VABlocks.HORNFELS_TILE_SLAB,
                    VABlocks.CHISELED_HORNFELS_TILES,
                    VABlocks.SYENITE,
                    VABlocks.CAGELIGHT,
                    VABlocks.LUMWASP_NEST,
                    VABlocks.ACID_BLOCK,
                    VABlocks.ENTANGLEMENT_DRIVE
                    );
            
            registerSimpleCubeAll(generator,
                    VABlocks.CHISELED_HORNFELS,
                    VABlocks.BLUESCHIST,
                    VABlocks.RAW_STEEL_BLOCK,
                    VABlocks.SILK_BLOCK,
                    VABlocks.WEBBED_SILK,
                    VABlocks.IOLITE_ORE,
                    VABlocks.IOLITE_BLOCK,
                    VABlocks.SILKBULB,
                    VABlocks.WHITE_SILKBULB,
                    VABlocks.LIGHT_GRAY_SILKBULB,
                    VABlocks.GRAY_SILKBULB,
                    VABlocks.BLACK_SILKBULB,
                    VABlocks.BROWN_SILKBULB,
                    VABlocks.RED_SILKBULB,
                    VABlocks.ORANGE_SILKBULB,
                    VABlocks.YELLOW_SILKBULB,
                    VABlocks.LIME_SILKBULB,
                    VABlocks.GREEN_SILKBULB,
                    VABlocks.CYAN_SILKBULB,
                    VABlocks.LIGHT_BLUE_SILKBULB,
                    VABlocks.BLUE_SILKBULB,
                    VABlocks.PURPLE_SILKBULB,
                    VABlocks.MAGENTA_SILKBULB,
                    VABlocks.PINK_SILKBULB,
                    VABlocks.ROCK_SALT_ORE,
                    VABlocks.DEEPSLATE_ROCK_SALT_ORE,
                    VABlocks.SOULBLOOM_LEAVES,
                    VABlocks.WITHERED_LEAVES,
                    VABlocks.SPECTRAL_SAND,
                    VABlocks.STEEL_BLOCK,
                    VABlocks.EXPOSED_STEEL_BLOCK,
                    VABlocks.WEATHERED_STEEL_BLOCK,
                    VABlocks.OXIDIZED_STEEL_BLOCK,
                    VABlocks.STEEL_GRATE,
                    VABlocks.EXPOSED_STEEL_GRATE,
                    VABlocks.WEATHERED_STEEL_GRATE,
                    VABlocks.OXIDIZED_STEEL_GRATE
                    );

            generator.method_25676(VABlocks.SOULBLOOM_LOG).method_25730(VABlocks.SOULBLOOM_LOG).method_25728(VABlocks.SOULBLOOM_WOOD);
            generator.method_25676(VABlocks.STRIPPED_SOULBLOOM_LOG).method_25730(VABlocks.STRIPPED_SOULBLOOM_LOG).method_25728(VABlocks.STRIPPED_SOULBLOOM_WOOD);
            generator.method_46190(VABlocks.STRIPPED_SOULBLOOM_LOG, VABlocks.SOULBLOOM_HANGING_SIGN, VABlocks.SOULBLOOM_WALL_HANGING_SIGN);
            generator.method_72719(VABlocks.SOULBLOOM_SHELF, VABlocks.STRIPPED_SOULBLOOM_LOG);

            generator.method_25698(VABlocks.NECROTIC_NYLIUM);
            generator.method_25676(VABlocks.WITHERED_LOG).method_25730(VABlocks.WITHERED_LOG).method_25728(VABlocks.WITHERED_WOOD);
            generator.method_25676(VABlocks.STRIPPED_WITHERED_LOG).method_25730(VABlocks.STRIPPED_WITHERED_LOG).method_25728(VABlocks.STRIPPED_WITHERED_WOOD);
            generator.method_46190(VABlocks.STRIPPED_WITHERED_LOG, VABlocks.WITHERED_HANGING_SIGN, VABlocks.WITHERED_WALL_HANGING_SIGN);
            generator.method_72719(VABlocks.WITHERED_SHELF, VABlocks.STRIPPED_WITHERED_LOG);

            registerSpectralFire(generator);
            generator.method_25677(VABlocks.SPECTRAL_TORCH, VABlocks.SPECTRAL_WALL_TORCH);
            generator.method_25706(VABlocks.SPECTRAL_LANTERN);

            generator.method_49378(VABlocks.BLUE_PETALS);

            generator.method_25537(VAItems.CABBAGE_SEEDS);
            generator.method_25537(VAItems.CORN_SEEDS);
            generator.method_25537(VAItems.COTTON_SEEDS);
            generator.method_25537(VAItems.BALLOON_FRUIT);

            generator.method_25537(VAItems.CLIMBING_ROPE);
            generator.method_25537(VAItems.EXPOSED_CLIMBING_ROPE);
            generator.method_25537(VAItems.WEATHERED_CLIMBING_ROPE);
            generator.method_25537(VAItems.OXIDIZED_CLIMBING_ROPE);
            generator.method_25623(VABlocks.WAXED_CLIMBING_ROPE_ANCHOR, class_7923.field_41178.method_10221(VAItems.CLIMBING_ROPE).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_EXPOSED_CLIMBING_ROPE_ANCHOR, class_7923.field_41178.method_10221(VAItems.EXPOSED_CLIMBING_ROPE).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_WEATHERED_CLIMBING_ROPE_ANCHOR, class_7923.field_41178.method_10221(VAItems.WEATHERED_CLIMBING_ROPE).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_OXIDIZED_CLIMBING_ROPE_ANCHOR, class_7923.field_41178.method_10221(VAItems.OXIDIZED_CLIMBING_ROPE).method_45138("item/"));
            generator.method_25537(VAItems.STEEL_DOOR);
            generator.method_25537(VAItems.EXPOSED_STEEL_DOOR);
            generator.method_25537(VAItems.WEATHERED_STEEL_DOOR);
            generator.method_25537(VAItems.OXIDIZED_STEEL_DOOR);
            generator.method_25623(VABlocks.WAXED_STEEL_DOOR, class_7923.field_41178.method_10221(VAItems.STEEL_DOOR).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_EXPOSED_STEEL_DOOR, class_7923.field_41178.method_10221(VAItems.EXPOSED_STEEL_DOOR).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_WEATHERED_STEEL_DOOR, class_7923.field_41178.method_10221(VAItems.WEATHERED_STEEL_DOOR).method_45138("item/"));
            generator.method_25623(VABlocks.WAXED_OXIDIZED_STEEL_DOOR, class_7923.field_41178.method_10221(VAItems.OXIDIZED_STEEL_DOOR).method_45138("item/"));

            generator.method_25623(VABlocks.STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.EXPOSED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.EXPOSED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.WEATHERED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.WEATHERED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.OXIDIZED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.OXIDIZED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.WAXED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.WAXED_EXPOSED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.EXPOSED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.WAXED_WEATHERED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.WEATHERED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));
            generator.method_25623(VABlocks.WAXED_OXIDIZED_STEEL_TRAPDOOR, class_7923.field_41175.method_10221(VABlocks.OXIDIZED_STEEL_TRAPDOOR).method_45138("block/").method_48331("_bottom"));

            generator.method_25623(VABlocks.REDSTONE_BRIDGE, class_7923.field_41175.method_10221(VABlocks.REDSTONE_BRIDGE).method_45138("block/").method_48331("_inventory"));

            generator.method_25556(VABlocks.ROCK_SALT_CRYSTAL, "_tip");

            generator.method_25623(VABlocks.SPRING_LOTUS, class_7923.field_41175.method_10221(VABlocks.SPRING_LOTUS).method_45138("block/").method_48331("_3"));

            generator.method_25600(VABlocks.FRAYED_SILK);
            generator.method_25600(VABlocks.GREENCAP_MUSHROOM);
            generator.method_25556(VABlocks.TALL_GREENCAP_MUSHROOMS, "_top");
            generator.method_25600(VABlocks.GLOWING_SILK);

            generator.method_65399(VAItems.SOULBLOOM_SAPLING, class_4910.class_4913.field_22840.method_65297(generator, VABlocks.SOULBLOOM_SAPLING));
            generator.method_65399(VAItems.WITHERED_SAPLING, class_4910.class_4913.field_22840.method_65297(generator, VABlocks.WITHERED_SAPLING));

            generator.method_65399(VAItems.NECROTIC_ROOTS, class_4910.class_4913.field_22840.method_65297(generator, VABlocks.NECROTIC_ROOTS));

            generator.method_65399(VAItems.SMALL_SPRING_LOTUS, class_4910.class_4913.field_22840.method_65297(generator, VABlocks.SMALL_SPRING_LOTUS));
            generator.method_65399(VAItems.SOUL_SPROUT, class_4910.class_4913.field_55176.method_65297(generator, VABlocks.SOUL_SPROUT));

            generator.method_25619(VABlocks.ROCK_SALT_BLOCK);
            generator.method_25622(VABlocks.CHISELED_ROCK_SALT_BRICKS, class_4946.field_23038);

            generator.method_25547(VABlocks.TOMATO, class_2302.field_10835, 0, 1, 2, 3, 4, 5, 6, 7);
            generator.method_25547(VABlocks.WISDOM_BERRY, class_2302.field_10835, 0, 1, 1, 1, 2, 2, 2, 3);

            generator.method_66529(VABlocks.BONE_LITTER);
            generator.method_25548(VABlocks.BONE_PILE, class_4910.class_4913.field_22840);

            registerColorfulBlockSetModels( generator,VACollections.CHARTREUSE);
            registerColorfulBlockSetModels( generator,VACollections.MAROON);
            registerColorfulBlockSetModels( generator,VACollections.INDIGO);
            registerColorfulBlockSetModels( generator,VACollections.PLUM);
            registerColorfulBlockSetModels( generator,VACollections.VIRIDIAN);
            registerColorfulBlockSetModels( generator,VACollections.TAN);
            registerColorfulBlockSetModels( generator,VACollections.SINOPIA);
            registerColorfulBlockSetModels( generator,VACollections.LILAC);

            registerInventoryBlockItem(generator, VABlocks.OAK_HEDGE, new class_10396(class_1926.field_55217));
            registerInventoryBlockItem(generator, VABlocks.SPRUCE_HEDGE, new class_10396(class_1926.field_55215));
            registerInventoryBlockItem(generator, VABlocks.BIRCH_HEDGE, new class_10396(class_1926.field_55216));
            registerInventoryBlockItem(generator, VABlocks.JUNGLE_HEDGE, new class_10396(class_1926.field_55217));
            registerInventoryBlockItem(generator, VABlocks.ACACIA_HEDGE, new class_10396(class_1926.field_55217));
            registerInventoryBlockItem(generator, VABlocks.DARK_OAK_HEDGE, new class_10396(class_1926.field_55217));
            registerInventoryBlockItem(generator, VABlocks.PALE_OAK_HEDGE);
            registerInventoryBlockItem(generator, VABlocks.MANGROVE_HEDGE, new class_10396(class_1926.field_55218));
            registerInventoryBlockItem(generator, VABlocks.CHERRY_HEDGE);
            registerInventoryBlockItem(generator, VABlocks.SOULBLOOM_HEDGE);
            registerInventoryBlockItem(generator, VABlocks.WITHERED_HEDGE);
            registerInventoryBlockItem(generator, VABlocks.AZALEA_HEDGE);
            registerInventoryBlockItem(generator, VABlocks.FLOWERING_AZALEA_HEDGE);

            registerColoringStation(generator);
            registerSpotlight(generator);

            generator.method_25545(VABlocks.SOULBLOOM_SAPLING, VABlocks.POTTED_SOULBLOOM_SAPLING, class_4910.class_4913.field_22840);
            generator.method_25545(VABlocks.WITHERED_SAPLING, VABlocks.POTTED_WITHERED_SAPLING, class_4910.class_4913.field_22840);
            generator.method_25545(VABlocks.GREENCAP_MUSHROOM, VABlocks.POTTED_GREENCAP_MUSHROOM, class_4910.class_4913.field_22840);
            generator.method_25545(VABlocks.NECROTIC_ROOTS, VABlocks.POTTED_NECROTIC_ROOTS, class_4910.class_4913.field_22840);
            generator.method_25545(VABlocks.SMALL_SPRING_LOTUS, VABlocks.POTTED_SMALL_SPRING_LOTUS, class_4910.class_4913.field_22840);
            generator.method_25545(VABlocks.SOUL_SPROUT, VABlocks.POTTED_SOUL_SPROUT, class_4910.class_4913.field_55176);

            generator.method_25672(VABlocks.STEEL_GRATE, VABlocks.WAXED_STEEL_GRATE);
            generator.method_25672(VABlocks.EXPOSED_STEEL_GRATE, VABlocks.WAXED_EXPOSED_STEEL_GRATE);
            generator.method_25672(VABlocks.WEATHERED_STEEL_GRATE, VABlocks.WAXED_WEATHERED_STEEL_GRATE);
            generator.method_25672(VABlocks.OXIDIZED_STEEL_GRATE, VABlocks.WAXED_OXIDIZED_STEEL_GRATE);
            generator.method_25672(VABlocks.STEEL_BLOCK, VABlocks.WAXED_STEEL_BLOCK);
            generator.method_25672(VABlocks.EXPOSED_STEEL_BLOCK, VABlocks.WAXED_EXPOSED_STEEL_BLOCK);
            generator.method_25672(VABlocks.WEATHERED_STEEL_BLOCK, VABlocks.WAXED_WEATHERED_STEEL_BLOCK);
            generator.method_25672(VABlocks.OXIDIZED_STEEL_BLOCK, VABlocks.WAXED_OXIDIZED_STEEL_BLOCK);

            generator.method_25672(VABlocks.STEEL_BLOCK, VABlocks.REMOTE_NOTIFIER);

            generator.method_65403(VABlocks.MINI_PORTAL, VABlocks.IOLITE_BLOCK);
        }

        @Override
        public void generateItemModels(class_4915 generator) {
            generateGildedToolItemModels(generator, VAItems.AMETHYST_TOOL_SETS);
            generateGildedToolItemModels(generator, VAItems.COPPER_TOOL_SETS);
            generateGildedToolItemModels(generator, VAItems.EMERALD_TOOL_SETS);
            generateGildedToolItemModels(generator, VAItems.IOLITE_TOOL_SETS);
            generateGildedToolItemModels(generator, VAItems.QUARTZ_TOOL_SETS);
            generateGildedToolItemModels(generator, VAItems.SCULK_TOOL_SETS);

            registerSimpleItems(generator,
                    VAItems.CHARTREUSE_DYE,
                    VAItems.MAROON_DYE,
                    VAItems.INDIGO_DYE,
                    VAItems.PLUM_DYE,
                    VAItems.VIRIDIAN_DYE,
                    VAItems.TAN_DYE,
                    VAItems.SINOPIA_DYE,
                    VAItems.LILAC_DYE,
                    VAItems.ROCK_SALT,
                    VAItems.RAW_STEEL,
                    VAItems.STEEL_INGOT,
                    VAItems.STEEL_NUGGET,
                    VAItems.TOOL_GILD_SMITHING_TEMPLATE,
                    VAItems.STEEL_BOMB,
                    VAItems.IOLITE,
                    VAItems.DRAINED_PORTAL_CORE,
                    VAItems.TOMATO,
                    VAItems.TOMATO_SOUP,
                    VAItems.CABBAGE,
                    VAItems.CORN,
                    VAItems.ROASTED_CORN,
                    VAItems.SALAD,
                    VAItems.WISDOM_BERRY,
                    VAItems.COTTON,
                    VAItems.FRIED_EGG,
                    VAItems.CHEESE_WEDGE,
                    VAItems.BEEF_JERKY,
                    VAItems.PORK_JERKY,
                    VAItems.CHICKEN_JERKY,
                    VAItems.MUTTON_JERKY,
                    VAItems.SWEET_BERRY_PIE,
                    VAItems.ACID_BUCKET,
                    VAItems.SILK_THREAD,
                    VAItems.LUMWASP_MANDIBLE,
                    VAItems.LIGHTNING_BOTTLE,
                    VAItems.SALINE_SPAWN_EGG,
                    VAItems.LUMWASP_SPAWN_EGG,
                    VAItems.SPECTRE_SPAWN_EGG,
                    VAItems.STEEL_HORSE_ARMOR,
                    VAItems.SOULBLOOM_BOAT,
                    VAItems.SOULBLOOM_CHEST_BOAT,
                    VAItems.SPECTRAL_POWDER,
                    VAItems.CHARTREUSE_HARNESS,
                    VAItems.MAROON_HARNESS,
                    VAItems.INDIGO_HARNESS,
                    VAItems.PLUM_HARNESS,
                    VAItems.VIRIDIAN_HARNESS,
                    VAItems.TAN_HARNESS,
                    VAItems.SINOPIA_HARNESS,
                    VAItems.LILAC_HARNESS,
                    VAItems.PURPLE_EGG,
                    VAItems.EXOSKELETON_ARMOR_TRIM_SMITHING_TEMPLATE,
                    VAItems.ROBE_ARMOR_TRIM_SMITHING_TEMPLATE
            );

            registerItems(generator, class_4943.field_22939,
                    VAItems.STEEL_SWORD,
                    VAItems.STEEL_SHOVEL,
                    VAItems.STEEL_PICKAXE,
                    VAItems.STEEL_AXE,
                    VAItems.STEEL_HOE
            );

            registerHalberd(generator, VAItems.WOODEN_HALBERD);
            registerHalberd(generator, VAItems.STONE_HALBERD);
            registerHalberd(generator, VAItems.COPPER_HALBERD);
            registerHalberd(generator, VAItems.IRON_HALBERD);
            registerHalberd(generator, VAItems.GOLDEN_HALBERD);
            registerHalberd(generator, VAItems.STEEL_HALBERD);
            registerHalberd(generator, VAItems.DIAMOND_HALBERD);
            registerHalberd(generator, VAItems.NETHERITE_HALBERD);

            registerPortalCore(generator, VAItems.PORTAL_CORE);

            generator.method_65429(VAItems.STEEL_HELMET, VAArmorMaterial.STEEL.comp_3168(), field_56347, false);
            generator.method_65429(VAItems.STEEL_CHESTPLATE, VAArmorMaterial.STEEL.comp_3168(), field_56348, false);
            generator.method_65429(VAItems.STEEL_LEGGINGS, VAArmorMaterial.STEEL.comp_3168(), field_56349, false);
            generator.method_65429(VAItems.STEEL_BOOTS, VAArmorMaterial.STEEL.comp_3168(), field_56350, false);

            generator.method_65445(VAItems.CHARTREUSE_BUNDLE);
            generator.method_65445(VAItems.MAROON_BUNDLE);
            generator.method_65445(VAItems.INDIGO_BUNDLE);
            generator.method_65445(VAItems.PLUM_BUNDLE);
            generator.method_65445(VAItems.VIRIDIAN_BUNDLE);
            generator.method_65445(VAItems.TAN_BUNDLE);
            generator.method_65445(VAItems.SINOPIA_BUNDLE);
            generator.method_65445(VAItems.LILAC_BUNDLE);

            registerTintableWithDefaultTexture(generator, VAItems.ENGRAVING_CHISEL);
            registerTintableWithDefaultTexture(generator, VAItems.ICE_CREAM);

            registerApplicablePotion(generator, VAItems.APPLICABLE_POTION);

            generator.method_65453(VAItems.SPECTRAL_SPYGLASS);
        }
    }

    static class EnhancementsProvider extends Provider {
        public EnhancementsProvider(FabricDataOutput output) {
            super(output);
        }

        @Override
        public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
            haltModelGeneration = true;
        }

        @Override
        public void generateItemModels(class_4915 itemModelGenerator) {
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    VAItems.STEEL_HELMET,
                    VAItems.STEEL_CHESTPLATE,
                    VAItems.STEEL_LEGGINGS,
                    VAItems.STEEL_BOOTS,
                    VAArmorMaterial.STEEL.comp_3168(), false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_8743,
                    class_1802.field_8523,
                    class_1802.field_8396,
                    class_1802.field_8660,
                    class_10191.field_54136, false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_8862,
                    class_1802.field_8678,
                    class_1802.field_8416,
                    class_1802.field_8753,
                    class_10191.field_54137, false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_8805,
                    class_1802.field_8058,
                    class_1802.field_8348,
                    class_1802.field_8285,
                    class_10191.field_54138, false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_22027,
                    class_1802.field_22028,
                    class_1802.field_22029,
                    class_1802.field_22030,
                    class_10191.field_54140, false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_8283,
                    class_1802.field_8873,
                    class_1802.field_8218,
                    class_1802.field_8313,
                    class_10191.field_54135, false);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_8267,
                    class_1802.field_8577,
                    class_1802.field_8570,
                    class_1802.field_8370,
                    class_10191.field_54134, true);
            registerArmorSetWithExtendedTrimMaterials(itemModelGenerator,
                    class_1802.field_61343,
                    class_1802.field_61344,
                    class_1802.field_61345,
                    class_1802.field_61346,
                    class_10191.field_61365, false);

            registerCrossbow(itemModelGenerator, class_1802.field_8399);
        }
    }

    @SuppressWarnings("SameParameterValue")
    private abstract static class Provider extends FabricModelProvider {
        private static final List<class_4915.class_8072> TRIM_MATERIALS_EXTENDED =
                List.of(
                        new class_4915.class_8072(class_10714.field_56325, class_8055.field_42004),
                        new class_4915.class_8072(class_10714.field_56326, class_8055.field_42005),
                        new class_4915.class_8072(class_10714.field_56327, class_8055.field_42006),
                        new class_4915.class_8072(class_10714.field_56328, class_8055.field_42007),
                        new class_4915.class_8072(class_10714.field_56329, class_8055.field_42008),
                        new class_4915.class_8072(class_10714.field_56330, class_8055.field_42009),
                        new class_4915.class_8072(class_10714.field_56331, class_8055.field_42010),
                        new class_4915.class_8072(class_10714.field_56332, class_8055.field_42011),
                        new class_4915.class_8072(class_10714.field_56333, class_8055.field_42012),
                        new class_4915.class_8072(class_10714.field_56334, class_8055.field_42013),
                        new class_4915.class_8072(class_10714.field_56335, class_8055.field_55049),
                        new class_4915.class_8072(VAArmorTrimAssets.STEEL, VAArmorTrimMaterials.STEEL),
                        new class_4915.class_8072(VAArmorTrimAssets.ROCK_SALT, VAArmorTrimMaterials.ROCK_SALT),
                        new class_4915.class_8072(VAArmorTrimAssets.IOLITE, VAArmorTrimMaterials.IOLITE)
                );

        public Provider(FabricDataOutput output) {
            super(output);
        }

        protected void registerColoringStation(class_4910 blockStateModelGenerator) {
            class_4944 textureMap = new class_4944()
                    .method_25868(class_4945.field_23012, class_4944.method_25866(VABlocks.COLORING_STATION, "_front"))
                    .method_25868(class_4945.field_23024, class_4944.method_25866(VABlocks.COLORING_STATION, "_bottom"))
                    .method_25868(class_4945.field_23023, class_4944.method_25866(VABlocks.COLORING_STATION, "_top"))
                    .method_25868(class_4945.field_23019, class_4944.method_25866(VABlocks.COLORING_STATION, "_front"))
                    .method_25868(class_4945.field_23020, class_4944.method_25866(VABlocks.COLORING_STATION, "_front"))
                    .method_25868(class_4945.field_23021, class_4944.method_25866(VABlocks.COLORING_STATION, "_side"))
                    .method_25868(class_4945.field_23022, class_4944.method_25866(VABlocks.COLORING_STATION, "_side"));
            blockStateModelGenerator.field_22830.accept(class_4910.method_25644(VABlocks.COLORING_STATION, class_4910.method_67835(class_4943.field_22942.method_25846(VABlocks.COLORING_STATION, textureMap, blockStateModelGenerator.field_22831))));
        }

        protected void registerColorfulBlockSetModels(class_4910 g, ColorfulBlockSet s) {
            s.ifWool(wool -> {
                if (s.carpet() != null) g.method_25642(wool, s.carpet());
                else g.method_25641(s.wool());
                s.ifBed(bed -> g.method_65415(bed, wool, s.dye().method_7802()));
            });
            if (s.terracotta() != null) g.method_25641(s.terracotta());
            if (s.concrete() != null) g.method_25641(s.concrete());
            if (s.concretePowder() != null) g.method_25576(class_4946.field_23036,s.concretePowder());
            if (s.stainedGlass() != null) {
                if (s.stainedGlassPane() != null) g.method_25651(s.stainedGlass(), s.stainedGlassPane());
                else g.method_25641(s.stainedGlass());
            }
            if (s.silkbulb() != null) {
                g.method_25641(s.silkbulb());
            };
            if (s.candle() != null && s.candleCake() != null) g.method_32228(s.candle(), s.candleCake());
            s.ifShulkerBox(shulkerbox -> g.method_25710(shulkerbox, s.dye().method_7802()));
            s.ifGlazedTerracotta(block -> g.method_25614(class_4946.field_23045, block));
            s.ifBanner(banner -> s.ifWallBanner(wallBanner -> g.method_65405(banner, wallBanner, s.dye().method_7802())));
        }

        protected void generateGildedToolItemModels(class_4915 itemModelGenerator, RegistryHelper.ItemRegistryHelper.ToolSet... toolSets) {
            for (RegistryHelper.ItemRegistryHelper.ToolSet set : toolSets) {
                uploadGildedToolModels(itemModelGenerator, set);
            }
        }

        public static void uploadGildedToolModels(class_4915 itemModelGenerator, RegistryHelper.ItemRegistryHelper.ToolSet set) {
            uploadGildedToolModel(itemModelGenerator, set.SWORD(), "_sword");
            uploadGildedToolModel(itemModelGenerator, set.SHOVEL(), "_shovel");
            uploadGildedToolModel(itemModelGenerator, set.PICKAXE(), "_pickaxe");
            uploadGildedToolModel(itemModelGenerator, set.AXE(), "_axe");
            uploadGildedToolModel(itemModelGenerator, set.HOE(), "_hoe");
            uploadGildedHalberdModels(itemModelGenerator, set.HALBERD());
        }

        public static void uploadGildedToolModel(class_4915 itemModelGenerator, class_1792 item, String suffix) {
            if (item instanceof GildedToolItem gildedToolItem) {
            class_1792 baseItem = gildedToolItem.getBaseItem();
            class_2960 base = class_4941.method_25840(baseItem);
            class_2960 gild = gildedToolItem.getGildType().getId().method_48331(suffix).method_45138("item/gilded_tools/");
            class_2960 id = class_4941.method_25840(item);
            VAModels.HANDHELD_TWO_LAYERS.method_25852(id, class_4944.method_48529(base, gild), itemModelGenerator.field_55246);
            itemModelGenerator.field_55245.method_65460(item, class_10410.method_65481(id));
            }
        }

        public static void uploadGildedHalberdModels(class_4915 itemModelGenerator, class_1792 item) {
            if (item instanceof GildedToolItem gildedToolItem) {
                class_2960 gild = gildedToolItem.getGildType().getId().method_48331("_halberd").method_45138("item/gilded_tools/");
                registerLayeredHalberd(itemModelGenerator, item, gildedToolItem.getBaseItem(), gild);
            }
        }

        protected void registerSpotlight(class_4910 generator) {
            class_807 spotlight = class_4910.method_67835(class_4941.method_25842(VABlocks.SPOTLIGHT));
            class_807 spotlightActive = class_4910.method_67835(class_4941.method_25843(VABlocks.SPOTLIGHT, "_active"));
            generator.field_22830
                    .accept(
                            class_4925.method_67852(VABlocks.SPOTLIGHT)
                                    .method_67859(
                                            class_4926.method_67864(SpotlightBlock.POWERED)
                                                    .method_25794(false, spotlight)
                                                    .method_25794(true, spotlightActive)
                                    )
                                    .method_25775(class_4926.method_67869(class_2741.field_23333).method_25795(class_4910::method_26433))
                    );
        }

        public final void registerApplicablePotion(class_4915 generator, class_1792 item) {
            class_2960 identifier = generator.method_65431(item, idOf("item/applicable_potion_overlay"), class_4941.method_25840(item));
            generator.method_65430(item, identifier);
        }

        public final void registerTintableWithDefaultTexture(class_4915 generator, class_1792 item) {
            class_2960 undyedItemIdentifier = generator.method_65434(item, class_4943.field_22938);
            class_2960 itemIdentifier = class_7923.field_41178.method_10221(item).method_45138("item/");
            class_2960 dyedItemIdentifier = class_4943.field_42232.method_25852(class_4941.method_25841(item, "_dyed"), class_4944.method_48529(itemIdentifier.method_48331("_layer"), itemIdentifier.method_48331("_base")), generator.field_55246);
            generator.field_55245.method_65460(item, class_10410.method_65487(new class_10464(class_9334.field_49644, true), class_10410.method_65483(dyedItemIdentifier, new class_10398(0xFFFFFF)), class_10410.method_65481(undyedItemIdentifier)));
        }

        public static void registerParentedTintedItemModel(class_4910 generator, class_2248 block, class_2960 parentModelId, class_10401... sources) {
            generator.field_55238.method_65460(block.method_8389(), class_10410.method_65483(parentModelId, sources));
        }

        public static void registerArmorSetWithExtendedTrimMaterials(class_4915 generator, class_1792 helmet, class_1792 chestplate, class_1792 leggings, class_1792 boots, class_5321<class_10394> equipmentKey, boolean dyeable) {
            registerArmorWithExtendedTrimMaterials(generator, helmet, equipmentKey, field_56347, dyeable);
            registerArmorWithExtendedTrimMaterials(generator, chestplate, equipmentKey, field_56348, dyeable);
            registerArmorWithExtendedTrimMaterials(generator, leggings, equipmentKey, field_56349, dyeable);
            registerArmorWithExtendedTrimMaterials(generator, boots, equipmentKey, field_56350, dyeable);
        }

        public static void registerArmorWithExtendedTrimMaterials(class_4915 generator, class_1792 item, class_5321<class_10394> equipmentKey, class_2960 trimIdPrefix, boolean dyeable) {
            class_2960 identifier = class_4941.method_25840(item);
            class_2960 identifier2 = class_4944.method_25876(item);
            class_2960 identifier3 = class_4944.method_25863(item, "_overlay");
            List<class_10451.class_10452<class_5321<class_8054>>> list = new ArrayList<>(TRIM_MATERIALS_EXTENDED.size());

            class_4915.class_8072 trimMaterial;
            class_10439.class_10441 unbaked;
            for(Iterator<class_4915.class_8072> iterator = TRIM_MATERIALS_EXTENDED.iterator(); iterator.hasNext(); list.add(class_10410.method_65497(trimMaterial.comp_3367, unbaked))) {
                trimMaterial = iterator.next();
                class_2960 identifier4 = identifier.method_48331("_" + trimMaterial.comp_3607().comp_3603().comp_3605() + "_trim");
                String var10001 = trimMaterial.comp_3607().method_67227(equipmentKey).comp_3605();
                class_2960 identifier5 = trimIdPrefix.method_48331("_" + var10001);
                if (dyeable) {
                    generator.method_48742(identifier4, identifier2, identifier3, identifier5);
                    unbaked = class_10410.method_65483(identifier4, new class_10398(-6265536));
                } else {
                    generator.method_48517(identifier4, identifier2, identifier5);
                    unbaked = class_10410.method_65481(identifier4);
                }
            }

            class_10439.class_10441 unbaked2;
            if (dyeable) {
                class_4943.field_42232.method_25852(identifier, class_4944.method_48529(identifier2, identifier3), generator.field_55246);
                unbaked2 = class_10410.method_65483(identifier, new class_10398(-6265536));
            } else {
                class_4943.field_22938.method_25852(identifier, class_4944.method_25895(identifier2), generator.field_55246);
                unbaked2 = class_10410.method_65481(identifier);
            }

            generator.field_55245.method_65460(item, class_10410.method_65493(new class_10496(), unbaked2, list));
        }

        public final void registerCrossbow(class_4915 generator, class_1792 item) {
            class_10439.class_10441 unbaked = class_10410.method_65481(class_4941.method_25840(item));
            class_10439.class_10441 unbaked2 = class_10410.method_65481(generator.method_65438(item, "_pulling_0", class_4943.field_55256));
            class_10439.class_10441 unbaked3 = class_10410.method_65481(generator.method_65438(item, "_pulling_1", class_4943.field_55256));
            class_10439.class_10441 unbaked4 = class_10410.method_65481(generator.method_65438(item, "_pulling_2", class_4943.field_55256));
            class_10439.class_10441 unbaked5 = class_10410.method_65481(generator.method_65438(item, "_arrow", class_4943.field_55256));
            class_10439.class_10441 unbaked6 = class_10410.method_65481(generator.method_65438(item, "_firework", class_4943.field_55256));
            class_10439.class_10441 unbaked7 = class_10410.method_65481(generator.method_65438(item, "_climbing_rope", class_4943.field_55256));
            class_10439.class_10441 unbaked8 = class_10410.method_65481(generator.method_65438(item, "_exposed_climbing_rope", class_4943.field_55256));
            class_10439.class_10441 unbaked9 = class_10410.method_65481(generator.method_65438(item, "_weathered_climbing_rope", class_4943.field_55256));
            class_10439.class_10441 unbaked10 = class_10410.method_65481(generator.method_65438(item, "_oxidized_climbing_rope", class_4943.field_55256));
            generator.field_55245.method_65460(item, class_10410.method_65487(
                    class_10410.method_65479(), class_10410.method_65491(new class_10477(), unbaked2, class_10410.method_65486(unbaked3, 0.58F), class_10410.method_65486(unbaked4, 1.0F)),
                    class_10410.method_65494(new class_10488(), unbaked,
                            class_10410.method_65497(class_1764.class_10393.field_55207, class_10410.method_65491(new CrossbowProjectileTypeProperty(), unbaked5,
                                    class_10410.method_65486(unbaked7, 0.25F),
                                    class_10410.method_65486(unbaked8, 0.5F),
                                    class_10410.method_65486(unbaked9, 0.75F),
                                    class_10410.method_65486(unbaked10, 1.0F)
                                    )),
                            class_10410.method_65497(class_1764.class_10393.field_55208, unbaked6))));
        }

        public final void registerPortalCore(class_4915 generator, class_1792 item) {
            class_10439.class_10441 base = class_10410.method_65481(class_4941.method_25840(item));
            class_4943.field_22938.method_25852(class_4941.method_25840(item), class_4944.method_25895(class_4944.method_25876(item)), generator.field_55246);
            class_10439.class_10441 active = class_10410.method_65481(generator.method_65438(item, "_active", class_4943.field_22938));
            generator.field_55245.method_65460(item, class_10410.method_65487(
                    class_10410.method_65499(VADataComponentTypes.PORTAL_CORE_LOCATION), active, base
            ));
        }

        public static void registerHalberd(class_4915 generator, class_1792 item) {
            class_10439.class_10441 base = class_10410.method_65481(class_4941.method_25840(item));
            class_10439.class_10441 inHand = class_10410.method_65481(class_4941.method_25841(item, "_in_hand"));
            class_10439.class_10441 inUse = class_10410.method_65481(class_4941.method_25841(item, "_in_use"));
            class_4943.field_22939.method_25852(class_4941.method_25840(item), class_4944.method_25895(class_4944.method_25876(item)), generator.field_55246);
            VAModels.HALBERD_IN_HAND.method_25852(class_4941.method_25841(item, "_in_hand"), class_4944.method_25895(class_4944.method_25863(item, "_in_hand")), generator.field_55246);
            VAModels.HALBERD_IN_USE.method_25852(class_4941.method_25841(item, "_in_use"), class_4944.method_25895(class_4944.method_25863(item, "_in_hand")), generator.field_55246);
            generator.field_55245.method_65460(item, createModelWithInHandAndInUseVariant(base, inHand, inUse));
        }

        public static void registerLayeredHalberd(class_4915 generator, class_1792 item, class_1792 baseItem, class_2960 layer) {
            class_10439.class_10441 base = class_10410.method_65481(class_4941.method_25840(item));
            class_10439.class_10441 inHand = class_10410.method_65481(class_4941.method_25841(item, "_in_hand"));
            class_10439.class_10441 inUse = class_10410.method_65481(class_4941.method_25841(item, "_in_use"));
            VAModels.HANDHELD_TWO_LAYERS.method_25852(class_4941.method_25840(item), class_4944.method_48529(class_4944.method_25876(baseItem), layer), generator.field_55246);
            VAModels.HALBERD_IN_HAND_TWO_LAYERS.method_25852(class_4941.method_25841(item, "_in_hand"), class_4944.method_48529(class_4944.method_25863(baseItem, "_in_hand"), layer.method_48331("_in_hand")), generator.field_55246);
            VAModels.HALBERD_IN_USE_TWO_LAYERS.method_25852(class_4941.method_25841(item, "_in_use"), class_4944.method_48529(class_4944.method_25863(baseItem, "_in_hand"), layer.method_48331("_in_hand")), generator.field_55246);
            generator.field_55245.method_65460(item, createModelWithInHandAndInUseVariant(base, inHand, inUse));
        }

        protected void registerSpectralFire(class_4910 generator) {
            class_807 weightedVariant = generator.method_25700(VABlocks.SPECTRAL_FIRE);
            class_807 weightedVariant2 = generator.method_25702(VABlocks.SPECTRAL_FIRE);
            generator.field_22830
                    .accept(
                            class_4922.method_25758(VABlocks.SPECTRAL_FIRE)
                                    .method_25764(weightedVariant)
                                    .method_25764(weightedVariant2)
                                    .method_25764(weightedVariant2.method_67929(class_4910.field_56785))
                                    .method_25764(weightedVariant2.method_67929(class_4910.field_56786))
                                    .method_25764(weightedVariant2.method_67929(class_4910.field_56787))
                    );
        }

        protected static void registerSimpleBlockItem(class_4910 generator, class_2248 block) {
            generator.method_25623(block, class_7923.field_41175.method_10221(block).method_45138("block/"));
        }

        protected static void registerInventoryBlockItem(class_4910 generator, class_2248 block) {
            generator.method_25623(block, class_7923.field_41175.method_10221(block).method_45138("block/").method_48331("_inventory"));
        }

        protected static void registerInventoryBlockItem(class_4910 generator, class_2248 block, class_10401... sources) {
            registerParentedTintedItemModel(generator, block, class_7923.field_41175.method_10221(block).method_45138("block/").method_48331("_inventory"), sources);
        }
        
        protected static void registerSimpleBlockItems(class_4910 generator, class_2248... blocks) {
            for (class_2248 block : blocks) {
                registerSimpleBlockItem(generator, block);
            }
        }
        
        protected static void registerSimpleCubeAll(class_4910 generator, class_2248... blocks) {
            for (class_2248 block : blocks) {
                generator.method_25641(block);
            }
        }

        protected static void registerSimpleItems(class_4915 generator, class_1792... items) {
            for (class_1792 item : items) {
                generator.method_65442(item, class_4943.field_22938);
            }
        }

        protected static void registerItems(class_4915 generator, class_4942 model, class_1792... items) {
            for (class_1792 item : items) {
                generator.method_65442(item, model);
            }
        }
    }

    public static class_10439.class_10441 createModelWithInHandAndInUseVariant(class_10439.class_10441 model, class_10439.class_10441 inHandModel, class_10439.class_10441 inUseModel) {
        return class_10410.method_65494(
                new class_10490(),
                class_10410.method_65487(new class_10468(), inUseModel, inHandModel),
                class_10410.method_65498(List.of(class_811.field_4317, class_811.field_4318, class_811.field_4319, class_811.field_61988), model)
        );
    }


    private static boolean haltModelGeneration = false;

    public static boolean isModelGenerationHalted() {
        return haltModelGeneration;
    }

    public static void unhaltModelGeneration() {
        haltModelGeneration = false;
    }
}
