package com.github.suninvr.virtualadditions.datagen;

import com.github.suninvr.virtualadditions.registry.VABlocks;
import com.github.suninvr.virtualadditions.registry.VADyeColors;
import com.github.suninvr.virtualadditions.registry.VAItems;
import com.github.suninvr.virtualadditions.registry.VALootTables;
import com.google.common.collect.Maps;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_106;
import net.minecraft.class_10758;
import net.minecraft.class_109;
import net.minecraft.class_10914;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_149;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2048;
import net.minecraft.class_215;
import net.minecraft.class_219;
import net.minecraft.class_2405;
import net.minecraft.class_39;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_65;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7789;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import net.minecraft.class_9329;
import net.minecraft.class_9334;
import net.minecraft.class_9791;
import net.minecraft.loot.function.*;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

import static com.github.suninvr.virtualadditions.VirtualAdditions.idOf;

public class VASimpleLootTableProvider {

    public static FabricDataGenerator.Pack.RegistryDependentFactory<class_2405> enhancementsShearing() {return EnhancementsShearingProvider::new;}
    public static FabricDataGenerator.Pack.RegistryDependentFactory<class_2405> enhancementsEntities() {return EnhancementsEntitiesProvider::new;}
    public static FabricDataGenerator.Pack.RegistryDependentFactory<class_2405> enhancementsGift() {return EnhancementsGiftProvider::new;}
    public static FabricDataGenerator.Pack.RegistryDependentFactory<class_2405> base() {return BaseProvider::new;}

    public static class BaseProvider extends Provider {
        public BaseProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1179);
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
            lootTableBiConsumer.accept(VALootTables.CEMETERY_GRAVES, class_52.method_324()
                    .method_336(class_55.method_347().method_356(class_219.method_932(0.6F))
                            .method_351(item(class_1802.field_8743).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8523).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8396).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8660).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8371).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8699).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8403).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8475).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(class_1802.field_8609).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(7))
                            .method_351(item(VAItems.STEEL_HELMET).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_CHESTPLATE).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_LEGGINGS).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_BOOTS).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_SWORD).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_SHOVEL).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_PICKAXE).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_AXE).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                            .method_351(item(VAItems.STEEL_HOE).method_438(damage(0.15F, 0.8F)).method_438(enchant(3, 0.4F)).method_437(3))
                    )
                    .method_336(class_55.method_347().method_352(uniform(2.0F, 5.0F))
                            .method_351(item(class_1802.field_8606, 3, 10).method_437(12))
                            .method_351(item(class_1802.field_8511, 3, 10).method_437(8))
                            .method_351(item(class_1802.field_8687, 2, 8).method_437(3))
                            .method_351(item(class_1802.field_8745, 1, 5).method_437(3))
                    )
            );

            lootTableBiConsumer.accept(VALootTables.CEMETERY, class_52.method_324(
                    ).method_336(class_55.method_347().method_356(chance(0.25F))
                            .method_351(item(class_1802.field_8477, 1, 3))
                            .method_351(item(VAItems.ROBE_ARMOR_TRIM_SMITHING_TEMPLATE))
                    ).method_336(class_55.method_347().method_352(uniform(2.0F, 4.0F))
                            .method_351(item(VAItems.SPECTRAL_POWDER, 2, 8).method_437(10))
                            .method_351(item(VAItems.SPECTRAL_TORCH, 2, 8).method_437(8))
                            .method_351(item(VAItems.SPECTRAL_SAND, 2, 8).method_437(5))
                            .method_351(item(VAItems.STEEL_INGOT, 2, 4).method_437(2))
                    ).method_336(class_55.method_347().method_352(uniform(2.0F, 5.0f))
                            .method_351(item(class_1802.field_8745, 1, 5))
                            .method_351(item(class_1802.field_8606, 1, 5))
                            .method_351(item(VAItems.BONE_LITTER, 2, 10))
                    )
            );
        }
    }

    public static class EnhancementsShearingProvider extends Provider {
        public EnhancementsShearingProvider(FabricDataOutput fabricDataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(fabricDataOutput, registryLookup, class_173.field_49446);
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
            lootTableBiConsumer.accept(
                class_39.field_54010,
                class_52.method_324()
                        .method_336(class_7789.method_46031(class_39.field_52693))
            );

            WOOL_FROM_DYE_COLOR
                    .forEach(
                            (color, wool) -> lootTableBiConsumer.accept(
                                    class_39.field_52693.get(color),
                                    class_52.method_324().method_336(class_55.method_347().method_352(class_5662.method_32462(1.0F, 3.0F)).method_351(class_77.method_411(wool)))
                            )
                    );
        }
    }

    public static class EnhancementsEntitiesProvider extends Provider {
        CompletableFuture<class_7225.class_7874> registryLookup;

        public EnhancementsEntitiesProvider(FabricDataOutput fabricDataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(fabricDataOutput, registryLookup, class_173.field_1173);
            this.registryLookup = registryLookup;
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
            WOOL_FROM_DYE_COLOR
                    .forEach(
                            (color, wool) -> lootTableBiConsumer.accept(
                                    class_39.field_52692.get(color),
                                    class_52.method_324().method_336(class_55.method_347().method_351(class_77.method_411(wool)))
                            )
                    );


        }
    }

    public static class EnhancementsGiftProvider extends Provider {
        CompletableFuture<class_7225.class_7874> registryLookup;

        public EnhancementsGiftProvider(FabricDataOutput fabricDataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(fabricDataOutput, registryLookup, class_173.field_16235);
            this.registryLookup = registryLookup;
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
            lootTableBiConsumer.accept(class_39.field_54248,
                    class_52.method_324().method_336(class_55.method_347().method_351(
                            class_65.method_386(
                                    class_77.method_411(class_1802.field_8803).method_421(class_215.method_917(class_47.class_50.field_935, class_2048.class_2049.method_8916().method_66675(class_10914.class_10915.method_68683().method_68684(class_9329.method_66877(class_9334.field_56595, new class_9791<>(class_10758.field_56547))).method_68686()))),
                                    class_77.method_411(class_1802.field_56558).method_421(class_215.method_917(class_47.class_50.field_935, class_2048.class_2049.method_8916().method_66675(class_10914.class_10915.method_68683().method_68684(class_9329.method_66877(class_9334.field_56595, new class_9791<>(class_10758.field_56548))).method_68686()))),
                                    class_77.method_411(class_1802.field_56557).method_421(class_215.method_917(class_47.class_50.field_935, class_2048.class_2049.method_8916().method_66675(class_10914.class_10915.method_68683().method_68684(class_9329.method_66877(class_9334.field_56595, new class_9791<>(class_10758.field_56549))).method_68686()))),
                                    class_77.method_411(VAItems.PURPLE_EGG).method_421(class_215.method_917(class_47.class_50.field_935, class_2048.class_2049.method_8916().method_66675(class_10914.class_10915.method_68683().method_68684(class_9329.method_66877(class_9334.field_56595, new class_9791<>(class_5321.method_29179(class_7924.field_56596, idOf("enchanted"))))).method_68686())))
                            )
                    ))
                    );


        }
    }

    protected static abstract class Provider extends SimpleFabricLootTableProvider {
        protected final class_7225.class_7874 registryLookup;

        public Provider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup, class_176 contextType) {
            super(output, registryLookup, contextType);
            class_7225.class_7874[] lookup = {null};
            registryLookup.thenAccept(wrapperLookup -> lookup[0] = wrapperLookup);
            this.registryLookup = lookup[0];
        }

        protected static class_85.class_86<?> item(class_1792 item) {
            return class_77.method_411(item);
        }

        protected static class_85.class_86<?> item(class_1792 item, class_5658 count) {
            return class_77.method_411(item).method_438(class_141.method_621(count));
        }

        protected static class_85.class_86<?> item(class_1792 item, int min, int max) {
            return class_77.method_411(item).method_438(class_141.method_621(uniform(min, max)));
        }

        protected static class_85.class_86<?> item(class_1792 item, int count) {
            return class_77.method_411(item).method_438(class_141.method_621(constant(count)));
        }

        protected static class_5658 uniform(float min, float max) {
            return class_5662.method_32462(min, max);
        }

        protected static class_5658 constant(float count) {
            return class_44.method_32448(count);
        }

        protected static class_117.class_118 damage(float min, float max) {
            return class_149.method_633(uniform(min, max));
        }

        protected class_117.class_118 enchant() {
            return class_109.method_489(this.registryLookup);
        }

        protected class_117.class_118 enchant(class_5658 levels) {
            return class_106.method_481(this.registryLookup, levels);
        }

        protected class_117.class_118 enchant(int levels) {
            return class_106.method_481(this.registryLookup, constant(levels));
        }

        protected class_117.class_118 enchant(int levels, float probability) {
            return class_106.method_481(this.registryLookup, constant(levels))
                    .method_524(class_219.method_932(probability));
        }

        protected class_5341.class_210 chance(float probability) {
            return class_219.method_932(probability);
        }

        protected static Map<class_1767, class_1935> WOOL_FROM_DYE_COLOR = Maps.newEnumMap(
                Map.ofEntries(
                        Map.entry(VADyeColors.CHARTREUSE, VABlocks.CHARTREUSE_WOOL),
                        Map.entry(VADyeColors.MAROON, VABlocks.MAROON_WOOL),
                        Map.entry(VADyeColors.INDIGO, VABlocks.INDIGO_WOOL),
                        Map.entry(VADyeColors.PLUM, VABlocks.PLUM_WOOL),
                        Map.entry(VADyeColors.VIRIDIAN, VABlocks.VIRIDIAN_WOOL),
                        Map.entry(VADyeColors.TAN, VABlocks.TAN_WOOL),
                        Map.entry(VADyeColors.SINOPIA, VABlocks.SINOPIA_WOOL),
                        Map.entry(VADyeColors.LILAC, VABlocks.LILAC_WOOL)
                )
        );
    }


}
