package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.block.ClimbingRopeAnchorBlock;
import com.github.suninvr.virtualadditions.registry.*;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1665;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2760;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5955;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ClimbingRopeEntity extends class_1665 {
    private static final class_2940<Integer> OXIDATION_LEVEL = class_2945.method_12791(ClimbingRopeEntity.class, class_2943.field_13327);

    public ClimbingRopeEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public ClimbingRopeEntity(double x, double y, double z, class_1937 world, class_1799 stack, @Nullable class_1799 shotFrom) {
        super(VAEntityType.CLIMBING_ROPE, x, y, z, world, stack, shotFrom);

        if (stack.method_31574(VAItems.OXIDIZED_CLIMBING_ROPE) || stack.method_31574(VAItems.WAXED_OXIDIZED_CLIMBING_ROPE)) this.setOxidation(class_5955.class_5811.field_28707);
        else if (stack.method_31574(VAItems.WEATHERED_CLIMBING_ROPE) || stack.method_31574(VAItems.WAXED_WEATHERED_CLIMBING_ROPE)) this.setOxidation(class_5955.class_5811.field_28706);
        else if (stack.method_31574(VAItems.EXPOSED_CLIMBING_ROPE) || stack.method_31574(VAItems.WAXED_EXPOSED_CLIMBING_ROPE)) this.setOxidation(class_5955.class_5811.field_28705);
        else this.setOxidation(class_5955.class_5811.field_28704);
    }

    @Override
    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (this.method_73183().method_8608()) return;
        class_2680 state = this.getRopeState(blockHitResult);
        if (state != null) {
            class_2338 placePos = new class_2338(blockHitResult.method_17777().method_10093(blockHitResult.method_17780()));
            if (this.method_24921() instanceof class_3222 serverPlayerEntity) {
                VAAdvancementCriteria.FIRE_CLIMBING_ROPE_FROM_CROSSBOW.method_9141(serverPlayerEntity);
            }
            this.method_73183().method_8501(placePos, state);
            this.method_73183().method_64310(placePos, state.method_26204(), 1);
            this.method_73183().method_8396(this, placePos, state.method_26231().method_10598(), class_3419.field_15245,1.0F, 0.8F);
            this.method_31472();
        }
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OXIDATION_LEVEL, 0);
    }

    protected class_2680 getRopeState(class_3965 result) {
        if (this.method_54759().method_57826(class_9334.field_49634)) {
            class_2694 chachedPos = new class_2694(this.method_73183(), result.method_17777(), false);
            if (!this.method_54759().method_58694(class_9334.field_49634).method_38070(chachedPos)) return null;
        }
        class_2350 dir = result.method_17780();
        class_2338 pos = result.method_17777().method_10093(dir);
        if (dir != class_2350.field_11036 && this.method_54759().method_31573(VAItemTags.CLIMBING_ROPES) && this.method_54759().method_7909() instanceof class_1747 blockItem) {
            class_2760 half = ClimbingRopeAnchorBlock.getPlacementHeight(this.method_73183(), result.method_17777(), result.method_17780());
            class_2680 state = blockItem.method_7711().method_9564().method_11657(ClimbingRopeAnchorBlock.HALF, half).method_11657(ClimbingRopeAnchorBlock.FACING, dir.method_10153());
            if (this.method_73183().method_8320(pos).method_26215() && ClimbingRopeAnchorBlock.canPlaceAt(blockItem.method_7711(), state, this.method_73183(), pos)) {
                return state;
            }
        }
        return null;
    }

    public class_5955.class_5811 getOxidationLevel() {
        return switch (this.field_6011.method_12789(OXIDATION_LEVEL)) {
            case 3 -> class_5955.class_5811.field_28707;
            case 2 -> class_5955.class_5811.field_28706;
            case 1 -> class_5955.class_5811.field_28705;
            default -> class_5955.class_5811.field_28704;
        };
    }

    public void setOxidation(class_5955.class_5811 level) {
        switch (level) {
            case field_28704 -> this.field_6011.method_12778(OXIDATION_LEVEL, 0);
            case field_28705 -> this.field_6011.method_12778(OXIDATION_LEVEL, 1);
            case field_28706 -> this.field_6011.method_12778(OXIDATION_LEVEL, 2);
            case field_28707 -> this.field_6011.method_12778(OXIDATION_LEVEL, 3);
        }
    }

    @Override
    public void method_7485(double x, double y, double z, float speed, float divergence) {
        speed *= this.getSpeedMultipler();
        super.method_7485(x, y, z, speed, 0);
    }

    @Override
    public void method_24919(class_1297 shooter, float pitch, float yaw, float roll,  float speed, float divergence) {
        speed *= this.getSpeedMultipler();
        super.method_24919(shooter, pitch, yaw, roll, speed, 0);
    }

    protected float getSpeedMultipler() {
        return switch (this.getOxidationLevel()) {
            case field_28704 -> 1.0F;
            case field_28705 -> 0.8F;
            case field_28706 -> 0.6F;
            case field_28707 -> 0.4F;
        };
    }

    @Override
    protected class_3414 method_7440() {
        return VASoundEvents.BLOCK_ROPE_HIT_GROUND;
    }

    @Override
    protected boolean method_26958(class_1297 entity) {
        return false;
    }

    @Override
    protected class_1799 method_57314() {
        return new class_1799(VAItems.CLIMBING_ROPE);
    }
}
