package com.github.suninvr.virtualadditions.entity;

import com.github.suninvr.virtualadditions.VirtualAdditions;
import com.github.suninvr.virtualadditions.entity.goal.SpectreBuffEntityGoal;
import com.github.suninvr.virtualadditions.registry.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10339;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1395;
import net.minecraft.class_1400;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.entity.ai.goal.*;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class SpectreEntity extends class_1588 {
    private static final class_2940<Boolean> IS_BUFFING_TARGET = class_2945.method_12791(SpectreEntity.class, class_2943.field_13323);
    private static final class_2940<UUID> BUFF_TARGET = class_2945.method_12791(SpectreEntity.class, VATrackedDataHandlerRegistry.UUID);
    private static final UUID EMPTY_ID = UUID.fromString("0-0-0-0-0");
    private static final Map<UUID, UUID> spectreToTarget = new HashMap<>();
    private static final Map<UUID, UUID> targetToSpectre = new HashMap<>();
    private class_1309 buffTarget = null;
    private UUID buffTargetId = EMPTY_ID;
    private int buffTicks = 0;

    public SpectreEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6207 = new class_1331(this, 210, true);
    }

    public static class_5132 createSpectreAttributes() {
        return class_1308.method_26828()
                .method_26868(class_5134.field_23716, 10.0)
                .method_26868(class_5134.field_23720, 0.1)
                .method_26868(class_5134.field_23719, 0.1)
                .method_26868(class_5134.field_23721, 4.0)
                .method_26868(class_5134.field_23717, 16.0)
                .method_26866();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_BUFFING_TARGET, false);
        builder.method_56912(BUFF_TARGET, EMPTY_ID);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, new SpectreBuffEntityGoal(this, 1.5, 8.0F, 5.0F, 16.0F));
        this.field_6201.method_6277(4, new class_1395(this, 1.0F));
        this.field_6201.method_6277(4, new class_1361(this, class_1308.class, 8.0F));
        this.field_6201.method_6277(5, new class_1376(this));
        this.field_6185.method_6277(1, new class_1400<>(this, class_1657.class, true));
    }

    @Override
    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Override
    public void method_6091(class_243 movementInput) {
        this.method_70670(movementInput, this.method_6029());
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.method_5875(true);
        if (this.method_29504()) return;
        if (!this.method_73183().method_8608()) {
            if (this.checkBuffTarget() && this.isBuffingTarget()) {
                int difficulty = this.method_73183().method_8407().method_5461();
                if (this.field_6012 % 20 == 0) this.applyEffects(this.buffTarget, difficulty);
            }
        }
    }

    @Override
    public void method_6007() {
        super.method_6007();
        if (this.method_73183().method_8608()) {
            if (this.field_6012 % 40 == 0) this.refreshTarget();
            this.spawnAmbientEffects();
            if (this.isBuffingTarget()) {
                if (this.buffTarget instanceof class_1309 livingEntity) {
                    this.spawnBuffEffects(livingEntity);
                }
            }
        }
        if (this.isBuffingTarget()) this.buffTicks += 1;
        else this.buffTicks = 0;
    }

    @Override
    public void method_48850(List<class_2945.class_7834<?>> entries) {
        super.method_48850(entries);
        if (this.method_73183().method_8608()) this.refreshTarget();
    }

    @Environment(EnvType.CLIENT)
    private void refreshTarget() {
        this.buffTarget = (class_1309) this.method_73183().method_66347(this.field_6011.method_12789(BUFF_TARGET));
    }

    private void spawnAmbientEffects() {
        if (this.field_6012 % 3 == 0) {
            this.method_73183().method_8406(VAParticleTypes.SPECTRAL_FLAME, this.method_23322(0.25), this.method_23323(1), this.method_23325(0.25), 0.0, 0.0, 0.0);
        }
    }

    private void spawnBuffEffects(class_1309 buffTarget) {
        if (buffTarget == null || this.method_29504() || this.method_31481()) return;
        for (int i = 0; i < 1; ++i) {
            class_243 pos = new class_243(buffTarget.method_23322(0.6), buffTarget.method_23319(), buffTarget.method_23325(0.6));
            class_2394 effect = new class_10339(pos, 0xE0EFFF, this.method_73183().field_9229.method_43048(20) + 10);
            this.method_73183().method_8466(effect, true, true, this.method_23322(0.35), this.method_23323(0.5), this.method_23325(0.35), 0.0, 0.0, 0.0);
        }
        if (this.buffTicks % 2 == 0) this.method_73183().method_8406(VAParticleTypes.SPECTRAL_POWER, buffTarget.method_23322(1), buffTarget.method_23323(0.25), buffTarget.method_23325(1), 0.0, 0.0, 0.0);
        if (this.buffTicks % 50 == 0 && !this.method_5701()) this.method_73183().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), VASoundEvents.ENTITY_SPECTRE_EMPOWER_AMBIENT, class_3419.field_15251, 0.2F, 1.0F, true);
    }

    private void applyEffects(class_1309 buffTarget, int difficulty) {
        if (buffTarget == null) return;
        buffTarget.method_6092(new class_1293(class_1294.field_5910, 30, 0, true, true));
        buffTarget.method_6092(new class_1293(class_1294.field_5904, 30, 0, true, true));
        buffTarget.method_6092(new class_1293(class_1294.field_5907, 30, difficulty - 1, true, true));
        this.method_6092(new class_1293(class_1294.field_5907, 30, difficulty - 1, true, false));
    }

    public void setIsBuffing(boolean bl) {
        if (bl && this.isBuffingTarget()) return;
        this.field_6011.method_12778(IS_BUFFING_TARGET, bl);
        if (bl && !this.method_5701() && checkBuffTarget()) this.method_73183().method_43128(this, this.method_23317(), this.method_23318(), this.method_23321(), VASoundEvents.ENTITY_SPECTRE_EMPOWER_START, class_3419.field_15251, 0.6F, 1.0F);
    }

    public boolean isBuffingTarget() {
        return this.field_6011.method_12789(IS_BUFFING_TARGET);
    }

    public void setBuffTarget(class_1308 target) {
        targetToSpectre.remove(spectreToTarget.get(this.field_6021));
        spectreToTarget.remove(this.field_6021);
        if (target == null) {
            this.buffTarget = null;
            this.buffTargetId = EMPTY_ID;
            this.setIsBuffing(false);
        } else if (!(targetToSpectre.containsKey(target.method_5667()))) {
            this.buffTarget = target;
            UUID targetId = this.buffTarget.method_5667();
            UUID thisId = this.method_5667();
            targetToSpectre.put(targetId, thisId);
            spectreToTarget.put(thisId, targetId);
            this.buffTargetId = targetId;
        }
        this.field_6011.method_12778(BUFF_TARGET, this.buffTargetId);
        if (VirtualAdditions.DEBUG) VirtualAdditions.LOGGER.log(Level.INFO, "Spectre Target Maps: T->S = " + targetToSpectre.size() + ", S->T = " + spectreToTarget.size());
    }

    public class_1309 getBuffTarget() {
        this.checkBuffTarget();
        return this.buffTarget;
    }

    public static UUID getBuffingSpectreId(class_1309 entity) {
        return targetToSpectre.get(entity.method_5667());
    }

    private boolean checkBuffTarget() {
        if (this.buffTarget == null && buffTargetId != EMPTY_ID) this.setBuffTarget((class_1308) this.method_73183().method_66347(buffTargetId));
        if (this.buffTarget == null) return false;
        if (this.buffTarget.method_29504() || this.buffTarget.method_31481()) this.buffTarget = null;
        if (buffTarget == null) this.setIsBuffing(false);
        return this.buffTarget != null;
    }

    @Override
    public void method_5651(class_11368 view) {
        super.method_5651(view);
        this.buffTargetId = view.method_71426("buff_target", class_4844.field_40825).orElse(EMPTY_ID);
    }

    @Override
    public void method_5647(class_11372 view) {
        super.method_5647(view);
        view.method_71468("buff_target", class_4844.field_40825, this.buffTargetId);
    }

    @Nullable
    @Override
    protected class_3414 method_5994() {
        return VASoundEvents.ENTITY_SPECTRE_AMBIENT;
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return VASoundEvents.ENTITY_SPECTRE_HURT;
    }

    @Override
    protected class_3414 method_6002() {
        return VASoundEvents.ENTITY_SPECTRE_DEATH;
    }

    @Override
    public boolean method_29503() {
        return true;
    }

    public static boolean method_20680(class_1299<? extends class_1588> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        class_2680 state = world.method_8320(pos.method_10074());
        return (state.method_26164(VABlockTags.SPECTRE_SPAWNABLE_ON) || !spawnReason.equals(class_3730.field_16459)) && ((spawnReason.equals(class_3730.field_16469) && world.method_8320(pos).method_27852(VABlocks.SPECTRAL_FIRE)) || class_1588.method_20680(type, world, spawnReason, pos, random));
    }

    @Override
    protected class_1408 method_5965(class_1937 world) {
        class_1407 birdNavigation = new class_1407(this, world) {
            @Override
            protected boolean method_6341(class_243 origin, class_243 target) {
                return super.method_6341(origin, target);
            }
        };
        birdNavigation.method_70687(false);
        birdNavigation.method_6354(true);
        birdNavigation.method_61439(48.0F);
        return birdNavigation;
    }
}
