package com.github.suninvr.virtualadditions.entity.goal;

import com.github.suninvr.virtualadditions.entity.SpectreEntity;
import com.github.suninvr.virtualadditions.registry.VAEntityTypeTags;
import net.minecraft.class_1308;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1547;
import net.minecraft.class_1588;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.entity.mob.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Predicate;

public class SpectreBuffEntityGoal extends class_1352 {
    private final SpectreEntity mob;
    @Nullable
    private class_1308 target;
    private final double speed;
    private final class_1408 navigation;
    private int updateCountdownTicks;
    private long targetLastSeen;
    private final float minDistance;
    private final float maxDistance;
    private final float buffMaxDistance;
    private List<class_1308> nearbyMobs = new ArrayList<>();
    private static final Predicate<class_1308> targetPredicate;
    private static final Map<Class<?>, Integer> targetPriority = new HashMap<>();

    public SpectreBuffEntityGoal(SpectreEntity mob, double speed, float buffMaxDistance, float minDistance, float maxDistance) {
        this.mob = mob;
        this.speed = speed;
        this.navigation = mob.method_5942();
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.buffMaxDistance = buffMaxDistance;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        if (!(mob.method_5942() instanceof class_1409) && !(mob.method_5942() instanceof class_1407)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
    }

    @Override
    public boolean method_6264() {
        if (canTargetMob( (class_1308) this.mob.getBuffTarget())) {
            this.target = (class_1308) this.mob.getBuffTarget();
            return true;
        }

        this.updateList();
        class_1308 entity = null;
        int priority = -1;
        double distance = Double.MAX_VALUE;
        for (class_1308 mobEntity : this.nearbyMobs) {
            if (!canStartTargetMob(mobEntity)) continue;
            int i = getPriority(mobEntity);
            double d = this.mob.method_5739(mobEntity);
            if (i > priority || (i == priority && d < distance)) {
                entity = mobEntity;
                priority = i;
                distance = d;
            }
        }
        if (entity != null) {
            this.setTarget(entity);
            return true;
        }
        return false;
    }

    private boolean canStartTargetMob(class_1308 entity) {
        if (entity == null) return false;
        UUID spectreId = SpectreEntity.getBuffingSpectreId(entity);
        boolean isAvailable = spectreId == null || spectreId.equals(this.mob.method_5667());
        return canTargetMob(entity) && isAvailable && (this.mob.getBuffTarget() == entity || this.mob.method_5985().method_6369(entity));
    }

    private boolean canTargetMob(class_1308 entity) {
        return entity != null && !entity.method_29504() && !entity.method_31481() && !entity.method_5767() && !(this.mob.method_5739(entity) > 24);
    }

    private void updateList() {
        this.nearbyMobs = this.mob.method_73183().method_8390(class_1308.class, this.mob.method_5829().method_1014(this.maxDistance), this.targetPredicate);
    }

    @Override
    public boolean method_6266() {
        return this.canStartTargetMob(this.target) && this.mob.method_73183().method_8510() - this.targetLastSeen < 100;
    }

    @Override
    public void method_6269() {
        this.updateCountdownTicks = 0;
    }

    @Override
    public void method_6270() {
        this.setTarget(null);
        this.navigation.method_6340();
    }

    private void setTarget(class_1308 entity) {
        this.target = entity;
        this.mob.setBuffTarget(entity);
    }

    @Override
    public void method_6268() {
        if (this.target != null && !this.mob.method_60953()) {
            this.mob.method_5988().method_6226(this.target, 10.0F, this.mob.method_5978());
            if (--this.updateCountdownTicks <= 0) {
                boolean bl = this.mob.method_5985().method_6369(this.target);
                if (bl) this.targetLastSeen = this.mob.method_73183().method_8510();
                this.updateCountdownTicks = this.method_38847(10);
                double targetY = this.target.method_23320();
                double d = this.mob.method_23317() - this.target.method_23317();
                double e = this.mob.method_23318() - targetY;
                double f = this.mob.method_23321() - this.target.method_23321();
                double g = d * d + e * e + f * f;
                if (!bl || !(g <= this.minDistance * this.minDistance)) {
                    this.navigation.method_6337(this.target.method_23317(), targetY, this.target.method_23321(), this.speed);
                } else {
                    this.navigation.method_6340();
                    class_1333 lookControl = this.target.method_5988();
                    if (g <= this.minDistance
                            || lookControl.method_6225() == this.mob.method_23317() && lookControl.method_6227() == this.mob.method_23318() && lookControl.method_6228() == this.mob.method_23321()) {
                        double h = this.target.method_23317() - this.mob.method_23317();
                        double i = this.target.method_23321() - this.mob.method_23321();
                        this.navigation.method_6337(this.mob.method_23317() - h, this.mob.method_23318(), this.mob.method_23321() - i, this.speed);
                    }
                }
                this.mob.setIsBuffing(g <= this.buffMaxDistance * this.buffMaxDistance && bl);
            }
        }
    }

    private static int getPriority(class_1308 entity) {
        int i = targetPriority.getOrDefault(entity.getClass(), 0) + entity.method_6096();
        i += (int) (entity.method_6063() - entity.method_6032());
        return i;
    }

    static {
        targetPriority.put(class_1639.class, 5);
        targetPriority.put(class_1547.class, 3);
        targetPriority.put(class_1642.class, 2);
        targetPriority.put(class_1588.class, 1);
        targetPredicate = target -> target != null && !target.method_29504() && !target.method_31481() && SpectreEntity.class != target.getClass() && target.method_5864().method_20210(VAEntityTypeTags.SPECTRE_BUFF_TARGETS);
    }
}
